/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.testtools.FileBasedTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtilsListFilesTestCase
extends FileBasedTestCase {
    public FileUtilsListFilesTestCase(String name) {
        super(name);
    }

    private File getLocalTestDirectory() {
        return new File(FileUtilsListFilesTestCase.getTestDirectory(), "list-files");
    }

    protected void setUp() throws Exception {
        File dir = this.getLocalTestDirectory();
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
        File file = new File(dir, "dummy-build.xml");
        FileUtils.touch((File)file);
        file = new File(dir, "README");
        FileUtils.touch((File)file);
        dir = new File(dir, "subdir1");
        dir.mkdirs();
        file = new File(dir, "dummy-build.xml");
        FileUtils.touch((File)file);
        file = new File(dir, "dummy-readme.txt");
        FileUtils.touch((File)file);
        dir = new File(dir, "subsubdir1");
        dir.mkdirs();
        file = new File(dir, "dummy-file.txt");
        FileUtils.touch((File)file);
        file = new File(dir, "dummy-index.html");
        FileUtils.touch((File)file);
        dir = dir.getParentFile();
        dir = new File(dir, "CVS");
        dir.mkdirs();
        file = new File(dir, "Entries");
        FileUtils.touch((File)file);
        file = new File(dir, "Repository");
        FileUtils.touch((File)file);
    }

    protected void tearDown() throws Exception {
        File dir = this.getLocalTestDirectory();
        FileUtils.deleteDirectory((File)dir);
    }

    private Collection<String> filesToFilenames(Collection<File> files) {
        ArrayList<String> filenames = new ArrayList<String>(files.size());
        for (File file : files) {
            filenames.add(file.getName());
        }
        return filenames;
    }

    private Collection<String> filesToFilenames(Iterator<File> files) {
        ArrayList<String> filenames = new ArrayList<String>();
        while (files.hasNext()) {
            filenames.add(files.next().getName());
        }
        return filenames;
    }

    public void testIterateFilesByExtension() throws Exception {
        String[] extensions = new String[]{"xml", "txt"};
        Iterator files = FileUtils.iterateFiles((File)this.getLocalTestDirectory(), (String[])extensions, (boolean)false);
        Collection<String> filenames = this.filesToFilenames(files);
        FileUtilsListFilesTestCase.assertEquals((int)1, (int)filenames.size());
        FileUtilsListFilesTestCase.assertTrue((boolean)filenames.contains("dummy-build.xml"));
        FileUtilsListFilesTestCase.assertFalse((boolean)filenames.contains("README"));
        FileUtilsListFilesTestCase.assertFalse((boolean)filenames.contains("dummy-file.txt"));
        files = FileUtils.iterateFiles((File)this.getLocalTestDirectory(), (String[])extensions, (boolean)true);
        filenames = this.filesToFilenames(files);
        FileUtilsListFilesTestCase.assertEquals((int)4, (int)filenames.size());
        FileUtilsListFilesTestCase.assertTrue((boolean)filenames.contains("dummy-file.txt"));
        FileUtilsListFilesTestCase.assertFalse((boolean)filenames.contains("dummy-index.html"));
        files = FileUtils.iterateFiles((File)this.getLocalTestDirectory(), null, (boolean)false);
        filenames = this.filesToFilenames(files);
        FileUtilsListFilesTestCase.assertEquals((int)2, (int)filenames.size());
        FileUtilsListFilesTestCase.assertTrue((boolean)filenames.contains("dummy-build.xml"));
        FileUtilsListFilesTestCase.assertTrue((boolean)filenames.contains("README"));
        FileUtilsListFilesTestCase.assertFalse((boolean)filenames.contains("dummy-file.txt"));
    }

    public void testListFilesByExtension() throws Exception {
        String[] extensions = new String[]{"xml", "txt"};
        Collection files = FileUtils.listFiles((File)this.getLocalTestDirectory(), (String[])extensions, (boolean)false);
        FileUtilsListFilesTestCase.assertEquals((int)1, (int)files.size());
        Collection<String> filenames = this.filesToFilenames(files);
        FileUtilsListFilesTestCase.assertTrue((boolean)filenames.contains("dummy-build.xml"));
        FileUtilsListFilesTestCase.assertFalse((boolean)filenames.contains("README"));
        FileUtilsListFilesTestCase.assertFalse((boolean)filenames.contains("dummy-file.txt"));
        files = FileUtils.listFiles((File)this.getLocalTestDirectory(), (String[])extensions, (boolean)true);
        filenames = this.filesToFilenames(files);
        FileUtilsListFilesTestCase.assertEquals((int)4, (int)filenames.size());
        FileUtilsListFilesTestCase.assertTrue((boolean)filenames.contains("dummy-file.txt"));
        FileUtilsListFilesTestCase.assertFalse((boolean)filenames.contains("dummy-index.html"));
        files = FileUtils.listFiles((File)this.getLocalTestDirectory(), null, (boolean)false);
        FileUtilsListFilesTestCase.assertEquals((int)2, (int)files.size());
        filenames = this.filesToFilenames(files);
        FileUtilsListFilesTestCase.assertTrue((boolean)filenames.contains("dummy-build.xml"));
        FileUtilsListFilesTestCase.assertTrue((boolean)filenames.contains("README"));
        FileUtilsListFilesTestCase.assertFalse((boolean)filenames.contains("dummy-file.txt"));
    }

    public void testListFiles() throws Exception {
        IOFileFilter fileFilter = FileFilterUtils.trueFileFilter();
        Collection files = FileUtils.listFiles((File)this.getLocalTestDirectory(), (IOFileFilter)fileFilter, (IOFileFilter)null);
        Collection<String> filenames = this.filesToFilenames(files);
        FileUtilsListFilesTestCase.assertTrue((String)"'dummy-build.xml' is missing", (boolean)filenames.contains("dummy-build.xml"));
        FileUtilsListFilesTestCase.assertFalse((String)"'dummy-index.html' shouldn't be found", (boolean)filenames.contains("dummy-index.html"));
        FileUtilsListFilesTestCase.assertFalse((String)"'Entries' shouldn't be found", (boolean)filenames.contains("Entries"));
        fileFilter = FileFilterUtils.trueFileFilter();
        IOFileFilter dirFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"CVS"));
        files = FileUtils.listFiles((File)this.getLocalTestDirectory(), (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        filenames = this.filesToFilenames(files);
        FileUtilsListFilesTestCase.assertTrue((String)"'dummy-build.xml' is missing", (boolean)filenames.contains("dummy-build.xml"));
        FileUtilsListFilesTestCase.assertTrue((String)"'dummy-index.html' is missing", (boolean)filenames.contains("dummy-index.html"));
        FileUtilsListFilesTestCase.assertFalse((String)"'Entries' shouldn't be found", (boolean)filenames.contains("Entries"));
        fileFilter = FileFilterUtils.trueFileFilter();
        dirFilter = FileFilterUtils.makeCVSAware(null);
        files = FileUtils.listFiles((File)this.getLocalTestDirectory(), (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        filenames = this.filesToFilenames(files);
        FileUtilsListFilesTestCase.assertTrue((String)"'dummy-build.xml' is missing", (boolean)filenames.contains("dummy-build.xml"));
        FileUtilsListFilesTestCase.assertTrue((String)"'dummy-index.html' is missing", (boolean)filenames.contains("dummy-index.html"));
        FileUtilsListFilesTestCase.assertFalse((String)"'Entries' shouldn't be found", (boolean)filenames.contains("Entries"));
        fileFilter = FileFilterUtils.trueFileFilter();
        dirFilter = FileFilterUtils.prefixFileFilter((String)"sub");
        dirFilter = FileFilterUtils.makeCVSAware((IOFileFilter)dirFilter);
        files = FileUtils.listFiles((File)this.getLocalTestDirectory(), (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        filenames = this.filesToFilenames(files);
        FileUtilsListFilesTestCase.assertTrue((String)"'dummy-build.xml' is missing", (boolean)filenames.contains("dummy-build.xml"));
        FileUtilsListFilesTestCase.assertTrue((String)"'dummy-index.html' is missing", (boolean)filenames.contains("dummy-index.html"));
        FileUtilsListFilesTestCase.assertFalse((String)"'Entries' shouldn't be found", (boolean)filenames.contains("Entries"));
        try {
            FileUtils.listFiles((File)this.getLocalTestDirectory(), (IOFileFilter)null, (IOFileFilter)null);
            FileUtilsListFilesTestCase.fail((String)"Expected error about null parameter");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }
}

