/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.io.testtools.FileBasedTestCase;
import org.junit.Assert;

public class FileUtilsTestCase
extends FileBasedTestCase {
    private static final int TEST_DIRECTORY_SIZE = 0;
    private static final ListDirectoryWalker LIST_WALKER = new ListDirectoryWalker();
    private File testFile1 = new File(FileUtilsTestCase.getTestDirectory(), "file1-test.txt");
    private File testFile2 = new File(FileUtilsTestCase.getTestDirectory(), "file1a-test.txt");
    private int testFile1Size = (int)this.testFile1.length();
    private int testFile2Size = (int)this.testFile2.length();

    public FileUtilsTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        FileUtilsTestCase.getTestDirectory().mkdirs();
        this.createFile(this.testFile1, this.testFile1Size);
        this.createFile(this.testFile2, this.testFile2Size);
        FileUtils.deleteDirectory((File)FileUtilsTestCase.getTestDirectory());
        FileUtilsTestCase.getTestDirectory().mkdirs();
        this.createFile(this.testFile1, this.testFile1Size);
        this.createFile(this.testFile2, this.testFile2Size);
    }

    protected void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)FileUtilsTestCase.getTestDirectory());
    }

    public void testGetFile() {
        File expected_A = new File("src");
        File expected_B = new File(expected_A, "main");
        File expected_C = new File(expected_B, "java");
        FileUtilsTestCase.assertEquals((String)"A", (Object)expected_A, (Object)FileUtils.getFile((String[])new String[]{"src"}));
        FileUtilsTestCase.assertEquals((String)"B", (Object)expected_B, (Object)FileUtils.getFile((String[])new String[]{"src", "main"}));
        FileUtilsTestCase.assertEquals((String)"C", (Object)expected_C, (Object)FileUtils.getFile((String[])new String[]{"src", "main", "java"}));
        try {
            FileUtils.getFile((String[])null);
            FileUtilsTestCase.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void testGetFile_Parent() {
        File parent = new File("parent");
        File expected_A = new File(parent, "src");
        File expected_B = new File(expected_A, "main");
        File expected_C = new File(expected_B, "java");
        FileUtilsTestCase.assertEquals((String)"A", (Object)expected_A, (Object)FileUtils.getFile((File)parent, (String[])new String[]{"src"}));
        FileUtilsTestCase.assertEquals((String)"B", (Object)expected_B, (Object)FileUtils.getFile((File)parent, (String[])new String[]{"src", "main"}));
        FileUtilsTestCase.assertEquals((String)"C", (Object)expected_C, (Object)FileUtils.getFile((File)parent, (String[])new String[]{"src", "main", "java"}));
        try {
            FileUtils.getFile((File)parent, (String[])null);
            FileUtilsTestCase.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            FileUtils.getFile((File)null, (String[])new String[]{"src"});
            FileUtilsTestCase.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void testGetTempDirectoryPath() {
        FileUtilsTestCase.assertEquals((String)System.getProperty("java.io.tmpdir"), (String)FileUtils.getTempDirectoryPath());
    }

    public void testGetTempDirectory() {
        File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        FileUtilsTestCase.assertEquals((Object)tempDirectory, (Object)FileUtils.getTempDirectory());
    }

    public void testGetUserDirectoryPath() {
        FileUtilsTestCase.assertEquals((String)System.getProperty("user.home"), (String)FileUtils.getUserDirectoryPath());
    }

    public void testGetUserDirectory() {
        File userDirectory = new File(System.getProperty("user.home"));
        FileUtilsTestCase.assertEquals((Object)userDirectory, (Object)FileUtils.getUserDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_openInputStream_exists() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "test.txt");
        this.createLineBasedFile(file, new String[]{"Hello"});
        FileInputStream in = null;
        try {
            in = FileUtils.openInputStream((File)file);
            FileUtilsTestCase.assertEquals((int)72, (int)in.read());
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_openInputStream_existsButIsDirectory() throws Exception {
        File directory = new File(FileUtilsTestCase.getTestDirectory(), "subdir");
        directory.mkdirs();
        FileInputStream in = null;
        try {
            in = FileUtils.openInputStream((File)directory);
            FileUtilsTestCase.fail();
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_openInputStream_notExists() throws Exception {
        File directory = new File(FileUtilsTestCase.getTestDirectory(), "test.txt");
        FileInputStream in = null;
        try {
            in = FileUtils.openInputStream((File)directory);
            FileUtilsTestCase.fail();
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openOutputStream_noParent(boolean createFile) throws Exception {
        File file = new File("test.txt");
        FileUtilsTestCase.assertNull((Object)file.getParentFile());
        try {
            if (createFile) {
                this.createLineBasedFile(file, new String[]{"Hello"});
            }
            FileOutputStream out = null;
            try {
                out = FileUtils.openOutputStream((File)file);
                out.write(0);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
            FileUtilsTestCase.assertTrue((boolean)file.exists());
        }
        finally {
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public void test_openOutputStream_noParentCreateFile() throws Exception {
        this.openOutputStream_noParent(true);
    }

    public void test_openOutputStream_noParentNoFile() throws Exception {
        this.openOutputStream_noParent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_openOutputStream_exists() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "test.txt");
        this.createLineBasedFile(file, new String[]{"Hello"});
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream((File)file);
            out.write(0);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        FileUtilsTestCase.assertTrue((boolean)file.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_openOutputStream_existsButIsDirectory() throws Exception {
        File directory = new File(FileUtilsTestCase.getTestDirectory(), "subdir");
        directory.mkdirs();
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream((File)directory);
            FileUtilsTestCase.fail();
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_openOutputStream_notExists() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "a/test.txt");
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream((File)file);
            out.write(0);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        FileUtilsTestCase.assertTrue((boolean)file.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_openOutputStream_notExistsCannotCreate() throws Exception {
        String longStr = "abcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyzabcdevwxyz";
        File file = new File(FileUtilsTestCase.getTestDirectory(), "a/" + longStr + "/test.txt");
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream((File)file);
            FileUtilsTestCase.fail();
        }
        catch (IOException ioe) {
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void testByteCountToDisplaySize() {
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)0L), (String)"0 bytes");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)1L), (String)"1 bytes");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)1023L), (String)"1023 bytes");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)1024L), (String)"1 KB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)1025L), (String)"1 KB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)1047552L), (String)"1023 KB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)0x100000L), (String)"1 MB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)0x100400L), (String)"1 MB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)0x3FF00000L), (String)"1023 MB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)0x40000000L), (String)"1 GB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)0x40100000L), (String)"1 GB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)Integer.MAX_VALUE), (String)"1 GB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)0x10000000000L), (String)"1 TB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)0x4000000000000L), (String)"1 PB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)0x1000000000000000L), (String)"1 EB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)Long.MAX_VALUE), (String)"7 EB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)65535L), (String)"63 KB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)32767L), (String)"31 KB");
        FileUtilsTestCase.assertEquals((String)FileUtils.byteCountToDisplaySize((long)Integer.MAX_VALUE), (String)"1 GB");
    }

    public void testToFile1() throws Exception {
        URL url = new URL("file", null, "a/b/c/file.txt");
        File file = FileUtils.toFile((URL)url);
        FileUtilsTestCase.assertTrue((file.toString().indexOf("file.txt") >= 0 ? 1 : 0) != 0);
    }

    public void testToFile2() throws Exception {
        URL url = new URL("file", null, "a/b/c/file%20n%61me%2520.tx%74");
        File file = FileUtils.toFile((URL)url);
        FileUtilsTestCase.assertTrue((file.toString().indexOf("file name%20.txt") >= 0 ? 1 : 0) != 0);
    }

    public void testToFile3() throws Exception {
        FileUtilsTestCase.assertEquals(null, (Object)FileUtils.toFile((URL)null));
        FileUtilsTestCase.assertEquals(null, (Object)FileUtils.toFile((URL)new URL("http://jakarta.apache.org")));
    }

    public void testToFile4() throws Exception {
        URL url = new URL("file", null, "a/b/c/file%%20%me.txt%");
        File file = FileUtils.toFile((URL)url);
        FileUtilsTestCase.assertTrue((file.toString().indexOf("file% %me.txt%") >= 0 ? 1 : 0) != 0);
    }

    public void testToFile5() throws Exception {
        URL url = new URL("file", null, "both%20are%20100%20%25%20true");
        File file = FileUtils.toFile((URL)url);
        FileUtilsTestCase.assertEquals((String)"both are 100 % true", (String)file.toString());
    }

    public void testToFileUtf8() throws Exception {
        URL url = new URL("file", null, "/home/%C3%A4%C3%B6%C3%BC%C3%9F");
        File file = FileUtils.toFile((URL)url);
        FileUtilsTestCase.assertTrue((file.toString().indexOf("\u00e4\u00f6\u00fc\u00df") >= 0 ? 1 : 0) != 0);
    }

    public void testDecodeUrl() {
        FileUtilsTestCase.assertEquals((String)"", (String)FileUtils.decodeUrl((String)""));
        FileUtilsTestCase.assertEquals((String)"foo", (String)FileUtils.decodeUrl((String)"foo"));
        FileUtilsTestCase.assertEquals((String)"+", (String)FileUtils.decodeUrl((String)"+"));
        FileUtilsTestCase.assertEquals((String)"% ", (String)FileUtils.decodeUrl((String)"%25%20"));
        FileUtilsTestCase.assertEquals((String)"%20", (String)FileUtils.decodeUrl((String)"%2520"));
        FileUtilsTestCase.assertEquals((String)"jar:file:/C:/dir/sub dir/1.0/foo-1.0.jar!/org/Bar.class", (String)FileUtils.decodeUrl((String)"jar:file:/C:/dir/sub%20dir/1.0/foo-1.0.jar!/org/Bar.class"));
    }

    public void testDecodeUrlLenient() {
        FileUtilsTestCase.assertEquals((String)" ", (String)FileUtils.decodeUrl((String)" "));
        FileUtilsTestCase.assertEquals((String)"\u00e4\u00f6\u00fc\u00df", (String)FileUtils.decodeUrl((String)"\u00e4\u00f6\u00fc\u00df"));
        FileUtilsTestCase.assertEquals((String)"%", (String)FileUtils.decodeUrl((String)"%"));
        FileUtilsTestCase.assertEquals((String)"% ", (String)FileUtils.decodeUrl((String)"%%20"));
        FileUtilsTestCase.assertEquals((String)"%2", (String)FileUtils.decodeUrl((String)"%2"));
        FileUtilsTestCase.assertEquals((String)"%2G", (String)FileUtils.decodeUrl((String)"%2G"));
    }

    public void testDecodeUrlNullSafe() {
        FileUtilsTestCase.assertNull((Object)FileUtils.decodeUrl(null));
    }

    public void testDecodeUrlEncodingUtf8() {
        FileUtilsTestCase.assertEquals((String)"\u00e4\u00f6\u00fc\u00df", (String)FileUtils.decodeUrl((String)"%C3%A4%C3%B6%C3%BC%C3%9F"));
    }

    public void testToFiles1() throws Exception {
        URL[] urls = new URL[]{new URL("file", null, "file1.txt"), new URL("file", null, "file2.txt")};
        File[] files = FileUtils.toFiles((URL[])urls);
        FileUtilsTestCase.assertEquals((int)urls.length, (int)files.length);
        FileUtilsTestCase.assertEquals((String)("File: " + files[0]), (boolean)true, (files[0].toString().indexOf("file1.txt") >= 0 ? 1 : 0) != 0);
        FileUtilsTestCase.assertEquals((String)("File: " + files[1]), (boolean)true, (files[1].toString().indexOf("file2.txt") >= 0 ? 1 : 0) != 0);
    }

    public void testToFiles2() throws Exception {
        URL[] urls = new URL[]{new URL("file", null, "file1.txt"), null};
        File[] files = FileUtils.toFiles((URL[])urls);
        FileUtilsTestCase.assertEquals((int)urls.length, (int)files.length);
        FileUtilsTestCase.assertEquals((String)("File: " + files[0]), (boolean)true, (files[0].toString().indexOf("file1.txt") >= 0 ? 1 : 0) != 0);
        FileUtilsTestCase.assertEquals((String)("File: " + files[1]), null, (Object)files[1]);
    }

    public void testToFiles3() throws Exception {
        URL[] urls = null;
        File[] files = FileUtils.toFiles(urls);
        FileUtilsTestCase.assertEquals((int)0, (int)files.length);
    }

    public void testToFiles4() throws Exception {
        URL[] urls = new URL[]{new URL("file", null, "file1.txt"), new URL("http", "jakarta.apache.org", "file1.txt")};
        try {
            FileUtils.toFiles((URL[])urls);
            FileUtilsTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToURLs1() throws Exception {
        File[] files = new File[]{new File(FileUtilsTestCase.getTestDirectory(), "file1.txt"), new File(FileUtilsTestCase.getTestDirectory(), "file2.txt"), new File(FileUtilsTestCase.getTestDirectory(), "test file.txt")};
        URL[] urls = FileUtils.toURLs((File[])files);
        FileUtilsTestCase.assertEquals((int)files.length, (int)urls.length);
        FileUtilsTestCase.assertTrue((boolean)urls[0].toExternalForm().startsWith("file:"));
        FileUtilsTestCase.assertTrue((urls[0].toExternalForm().indexOf("file1.txt") >= 0 ? 1 : 0) != 0);
        FileUtilsTestCase.assertTrue((boolean)urls[1].toExternalForm().startsWith("file:"));
        FileUtilsTestCase.assertTrue((urls[1].toExternalForm().indexOf("file2.txt") >= 0 ? 1 : 0) != 0);
        FileUtilsTestCase.assertTrue((boolean)urls[2].toExternalForm().startsWith("file:"));
        FileUtilsTestCase.assertTrue((urls[2].toExternalForm().indexOf("test%20file.txt") >= 0 ? 1 : 0) != 0);
    }

    public void testContentEquals() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), this.getName());
        File file2 = new File(FileUtilsTestCase.getTestDirectory(), this.getName() + "2");
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file2));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)file2, (File)file2));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)file2, (File)file));
        try {
            FileUtils.contentEquals((File)FileUtilsTestCase.getTestDirectory(), (File)FileUtilsTestCase.getTestDirectory());
            FileUtilsTestCase.fail((String)"Comparing directories should fail with an IOException");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        File objFile1 = new File(FileUtilsTestCase.getTestDirectory(), this.getName() + ".object");
        objFile1.deleteOnExit();
        FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("/java/lang/Object.class"), (File)objFile1);
        File objFile1b = new File(FileUtilsTestCase.getTestDirectory(), this.getName() + ".object2");
        objFile1.deleteOnExit();
        FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("/java/lang/Object.class"), (File)objFile1b);
        File objFile2 = new File(FileUtilsTestCase.getTestDirectory(), this.getName() + ".collection");
        objFile2.deleteOnExit();
        FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("/java/util/Collection.class"), (File)objFile2);
        FileUtilsTestCase.assertFalse((boolean)FileUtils.contentEquals((File)objFile1, (File)objFile2));
        FileUtilsTestCase.assertFalse((boolean)FileUtils.contentEquals((File)objFile1b, (File)objFile2));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)objFile1, (File)objFile1b));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)objFile1, (File)objFile1));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)objFile1b, (File)objFile1b));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)objFile2, (File)objFile2));
        file.createNewFile();
        file2.createNewFile();
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file2));
    }

    public void testContentEqualsIgnoreEOL() throws Exception {
        File file1 = new File(FileUtilsTestCase.getTestDirectory(), this.getName());
        File file2 = new File(FileUtilsTestCase.getTestDirectory(), this.getName() + "2");
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file1, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file2, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file2, (File)file2, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file2, (File)file1, null));
        try {
            FileUtils.contentEqualsIgnoreEOL((File)FileUtilsTestCase.getTestDirectory(), (File)FileUtilsTestCase.getTestDirectory(), null);
            FileUtilsTestCase.fail((String)"Comparing directories should fail with an IOException");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        File tfile1 = new File(FileUtilsTestCase.getTestDirectory(), this.getName() + ".txt1");
        tfile1.deleteOnExit();
        FileUtils.write((File)tfile1, (CharSequence)"123\r");
        File tfile2 = new File(FileUtilsTestCase.getTestDirectory(), this.getName() + ".txt2");
        tfile1.deleteOnExit();
        FileUtils.write((File)tfile2, (CharSequence)"123\n");
        File tfile3 = new File(FileUtilsTestCase.getTestDirectory(), this.getName() + ".collection");
        tfile3.deleteOnExit();
        FileUtils.write((File)tfile3, (CharSequence)"123\r\n2");
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile1, (File)tfile1, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile2, (File)tfile2, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile3, (File)tfile3, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile1, (File)tfile2, null));
        FileUtilsTestCase.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile1, (File)tfile3, null));
        FileUtilsTestCase.assertFalse((boolean)FileUtils.contentEqualsIgnoreEOL((File)tfile2, (File)tfile3, null));
        URL urlCR = ((Object)((Object)this)).getClass().getResource("FileUtilsTestDataCR.dat");
        FileUtilsTestCase.assertNotNull((Object)urlCR);
        File cr = new File(urlCR.getPath());
        FileUtilsTestCase.assertTrue((boolean)cr.exists());
        URL urlCRLF = ((Object)((Object)this)).getClass().getResource("FileUtilsTestDataCRLF.dat");
        FileUtilsTestCase.assertNotNull((Object)urlCRLF);
        File crlf = new File(urlCRLF.getPath());
        FileUtilsTestCase.assertTrue((boolean)crlf.exists());
        URL urlLF = ((Object)((Object)this)).getClass().getResource("FileUtilsTestDataLF.dat");
        FileUtilsTestCase.assertNotNull((Object)urlLF);
        File lf = new File(urlLF.getPath());
        FileUtilsTestCase.assertTrue((boolean)lf.exists());
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)cr, (File)cr, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)crlf, (File)crlf, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)lf, (File)lf, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)cr, (File)crlf, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)cr, (File)lf, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)crlf, (File)lf, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)cr, (File)cr));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)crlf, (File)crlf));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEquals((File)lf, (File)lf));
        FileUtilsTestCase.assertFalse((boolean)FileUtils.contentEquals((File)cr, (File)crlf));
        FileUtilsTestCase.assertFalse((boolean)FileUtils.contentEquals((File)cr, (File)lf));
        FileUtilsTestCase.assertFalse((boolean)FileUtils.contentEquals((File)crlf, (File)lf));
        file1.createNewFile();
        file2.createNewFile();
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file1, null));
        FileUtilsTestCase.assertTrue((boolean)FileUtils.contentEqualsIgnoreEOL((File)file1, (File)file2, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyURLToFile() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), this.getName());
        file.deleteOnExit();
        String resourceName = "/java/lang/Object.class";
        FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource(resourceName), (File)file);
        FileInputStream fis = new FileInputStream(file);
        try {
            FileUtilsTestCase.assertTrue((String)"Content is not equal.", (boolean)IOUtils.contentEquals((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(resourceName), (InputStream)fis));
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyURLToFileWithTimeout() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "testCopyURLToFileWithTimeout");
        file.deleteOnExit();
        String resourceName = "/java/lang/Object.class";
        FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource(resourceName), (File)file, (int)500, (int)500);
        FileInputStream fis = new FileInputStream(file);
        try {
            FileUtilsTestCase.assertTrue((String)"Content is not equal.", (boolean)IOUtils.contentEquals((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(resourceName), (InputStream)fis));
        }
        finally {
            fis.close();
        }
    }

    public void testForceMkdir() throws Exception {
        FileUtils.forceMkdir((File)FileUtilsTestCase.getTestDirectory());
        File testFile = new File(FileUtilsTestCase.getTestDirectory(), this.getName());
        testFile.deleteOnExit();
        testFile.createNewFile();
        FileUtilsTestCase.assertTrue((String)"Test file does not exist.", (boolean)testFile.exists());
        try {
            FileUtils.forceMkdir((File)testFile);
            FileUtilsTestCase.fail((String)"Exception expected.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        testFile.delete();
        FileUtils.forceMkdir((File)testFile);
        FileUtilsTestCase.assertTrue((String)"Directory was not created.", (boolean)testFile.exists());
    }

    public void testSizeOfDirectory() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), this.getName());
        try {
            FileUtils.sizeOfDirectory((File)file);
            FileUtilsTestCase.fail((String)"Exception expected.");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        file.createNewFile();
        file.deleteOnExit();
        try {
            FileUtils.sizeOfDirectory((File)file);
            FileUtilsTestCase.fail((String)"Exception expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        file.delete();
        file.mkdir();
        FileUtilsTestCase.assertEquals((String)"Unexpected directory size", (long)0L, (long)FileUtils.sizeOfDirectory((File)file));
    }

    public void testSizeOf() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), this.getName());
        try {
            FileUtils.sizeOf(null);
            FileUtilsTestCase.fail((String)"Exception expected.");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            FileUtils.sizeOf((File)file);
            FileUtilsTestCase.fail((String)"Exception expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        file.createNewFile();
        file.deleteOnExit();
        FileUtilsTestCase.assertEquals((long)0L, (long)FileUtils.sizeOf((File)file));
        file.delete();
        FileUtilsTestCase.assertEquals((String)"Unexpected files size", (long)this.testFile1Size, (long)FileUtils.sizeOf((File)this.testFile1));
        FileUtilsTestCase.assertEquals((String)"Unexpected directory size", (long)0L, (long)FileUtils.sizeOf((File)FileUtilsTestCase.getTestDirectory()));
    }

    public void testIsFileNewerOlder() throws Exception {
        String message;
        File reference = new File(FileUtilsTestCase.getTestDirectory(), "FileUtils-reference.txt");
        File oldFile = new File(FileUtilsTestCase.getTestDirectory(), "FileUtils-old.txt");
        File newFile = new File(FileUtilsTestCase.getTestDirectory(), "FileUtils-new.txt");
        File invalidFile = new File(FileUtilsTestCase.getTestDirectory(), "FileUtils-invalid-file.txt");
        this.createFile(oldFile, 0L);
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.createFile(reference, 0L);
        } while (oldFile.lastModified() == reference.lastModified());
        Date date = new Date();
        long now = date.getTime();
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.createFile(newFile, 0L);
        } while (reference.lastModified() == newFile.lastModified());
        FileUtilsTestCase.assertFalse((String)"Old File - Newer - File", (boolean)FileUtils.isFileNewer((File)oldFile, (File)reference));
        FileUtilsTestCase.assertFalse((String)"Old File - Newer - Date", (boolean)FileUtils.isFileNewer((File)oldFile, (Date)date));
        FileUtilsTestCase.assertFalse((String)"Old File - Newer - Mili", (boolean)FileUtils.isFileNewer((File)oldFile, (long)now));
        FileUtilsTestCase.assertTrue((String)"New File - Newer - File", (boolean)FileUtils.isFileNewer((File)newFile, (File)reference));
        FileUtilsTestCase.assertTrue((String)"New File - Newer - Date", (boolean)FileUtils.isFileNewer((File)newFile, (Date)date));
        FileUtilsTestCase.assertTrue((String)"New File - Newer - Mili", (boolean)FileUtils.isFileNewer((File)newFile, (long)now));
        FileUtilsTestCase.assertFalse((String)"Invalid - Newer - File", (boolean)FileUtils.isFileNewer((File)invalidFile, (File)reference));
        String invalidFileName = invalidFile.getName();
        try {
            FileUtils.isFileNewer((File)newFile, (File)invalidFile);
            FileUtilsTestCase.fail((String)"Should have cause IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            message = iae.getMessage();
            FileUtilsTestCase.assertTrue((String)("Message should contain: " + invalidFileName + " but was: " + message), (boolean)message.contains(invalidFileName));
        }
        FileUtilsTestCase.assertTrue((String)"Old File - Older - File", (boolean)FileUtils.isFileOlder((File)oldFile, (File)reference));
        FileUtilsTestCase.assertTrue((String)"Old File - Older - Date", (boolean)FileUtils.isFileOlder((File)oldFile, (Date)date));
        FileUtilsTestCase.assertTrue((String)"Old File - Older - Mili", (boolean)FileUtils.isFileOlder((File)oldFile, (long)now));
        FileUtilsTestCase.assertFalse((String)"New File - Older - File", (boolean)FileUtils.isFileOlder((File)newFile, (File)reference));
        FileUtilsTestCase.assertFalse((String)"New File - Older - Date", (boolean)FileUtils.isFileOlder((File)newFile, (Date)date));
        FileUtilsTestCase.assertFalse((String)"New File - Older - Mili", (boolean)FileUtils.isFileOlder((File)newFile, (long)now));
        FileUtilsTestCase.assertFalse((String)"Invalid - Older - File", (boolean)FileUtils.isFileOlder((File)invalidFile, (File)reference));
        try {
            FileUtils.isFileOlder((File)newFile, (File)invalidFile);
            FileUtilsTestCase.fail((String)"Should have cause IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            message = iae.getMessage();
            FileUtilsTestCase.assertTrue((String)("Message should contain: " + invalidFileName + " but was: " + message), (boolean)message.contains(invalidFileName));
        }
        try {
            FileUtils.isFileNewer(null, (long)now);
            FileUtilsTestCase.fail((String)"Newer Null, expected IllegalArgumentExcepion");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            FileUtils.isFileNewer((File)oldFile, (File)null);
            FileUtilsTestCase.fail((String)"Newer Null reference, expected IllegalArgumentExcepion");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            FileUtils.isFileNewer((File)oldFile, (File)invalidFile);
            FileUtilsTestCase.fail((String)"Newer invalid reference, expected IllegalArgumentExcepion");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            FileUtils.isFileNewer((File)oldFile, (Date)null);
            FileUtilsTestCase.fail((String)"Newer Null date, expected IllegalArgumentExcepion");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            FileUtils.isFileOlder(null, (long)now);
            FileUtilsTestCase.fail((String)"Older Null, expected IllegalArgumentExcepion");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            FileUtils.isFileOlder((File)oldFile, (File)null);
            FileUtilsTestCase.fail((String)"Older Null reference, expected IllegalArgumentExcepion");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            FileUtils.isFileOlder((File)oldFile, (File)invalidFile);
            FileUtilsTestCase.fail((String)"Older invalid reference, expected IllegalArgumentExcepion");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            FileUtils.isFileOlder((File)oldFile, (Date)null);
            FileUtilsTestCase.fail((String)"Older Null date, expected IllegalArgumentExcepion");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    public void testCopyFile1() throws Exception {
        File destination = new File(FileUtilsTestCase.getTestDirectory(), "copy1.txt");
        FileUtils.copyFile((File)this.testFile1, (File)destination);
        FileUtilsTestCase.assertTrue((String)"Check Exist", (boolean)destination.exists());
        FileUtilsTestCase.assertEquals((String)"Check Full copy", (long)this.testFile1Size, (long)destination.length());
    }

    public void testCopyFileToOutputStream() throws Exception {
        ByteArrayOutputStream destination = new ByteArrayOutputStream();
        FileUtils.copyFile((File)this.testFile1, (OutputStream)destination);
        FileUtilsTestCase.assertEquals((String)"Check Full copy size", (int)this.testFile1Size, (int)destination.size());
        byte[] expected = FileUtils.readFileToByteArray((File)this.testFile1);
        Assert.assertArrayEquals((String)"Check Full copy", (byte[])expected, (byte[])destination.toByteArray());
    }

    public void IGNOREtestCopyFileLarge() throws Exception {
        File largeFile = new File(FileUtilsTestCase.getTestDirectory(), "large.txt");
        File destination = new File(FileUtilsTestCase.getTestDirectory(), "copylarge.txt");
        System.out.println("START:   " + new Date());
        this.createFile(largeFile, 0x40000000L);
        System.out.println("CREATED: " + new Date());
        FileUtils.copyFile((File)largeFile, (File)destination);
        System.out.println("COPIED:  " + new Date());
        FileUtilsTestCase.assertTrue((String)"Check Exist", (boolean)destination.exists());
        FileUtilsTestCase.assertEquals((String)"Check Full copy", (long)largeFile.length(), (long)destination.length());
    }

    public void testCopyFile2() throws Exception {
        File destination = new File(FileUtilsTestCase.getTestDirectory(), "copy2.txt");
        FileUtils.copyFile((File)this.testFile1, (File)destination);
        FileUtilsTestCase.assertTrue((String)"Check Exist", (boolean)destination.exists());
        FileUtilsTestCase.assertEquals((String)"Check Full copy", (long)this.testFile2Size, (long)destination.length());
    }

    public void testCopyToSelf() throws Exception {
        File destination = new File(FileUtilsTestCase.getTestDirectory(), "copy3.txt");
        FileUtils.copyFile((File)this.testFile1, (File)destination);
        try {
            FileUtils.copyFile((File)destination, (File)destination);
            FileUtilsTestCase.fail((String)"file copy to self should not be possible");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testCopyFile2WithoutFileDatePreservation() throws Exception {
        File destination = new File(FileUtilsTestCase.getTestDirectory(), "copy2.txt");
        FileUtils.copyFile((File)this.testFile1, (File)destination, (boolean)false);
        FileUtilsTestCase.assertTrue((String)"Check Exist", (boolean)destination.exists());
        FileUtilsTestCase.assertEquals((String)"Check Full copy", (long)this.testFile2Size, (long)destination.length());
    }

    public void testCopyDirectoryToDirectory_NonExistingDest() throws Exception {
        this.createFile(this.testFile1, 1234L);
        this.createFile(this.testFile2, 4321L);
        File srcDir = FileUtilsTestCase.getTestDirectory();
        File subDir = new File(srcDir, "sub");
        subDir.mkdir();
        File subFile = new File(subDir, "A.txt");
        FileUtils.writeStringToFile((File)subFile, (String)"HELLO WORLD", (String)"UTF8");
        File destDir = new File(System.getProperty("java.io.tmpdir"), "tmp-FileUtilsTestCase");
        FileUtils.deleteDirectory((File)destDir);
        File actualDestDir = new File(destDir, srcDir.getName());
        FileUtils.copyDirectoryToDirectory((File)srcDir, (File)destDir);
        FileUtilsTestCase.assertTrue((String)"Check exists", (boolean)destDir.exists());
        FileUtilsTestCase.assertTrue((String)"Check exists", (boolean)actualDestDir.exists());
        FileUtilsTestCase.assertEquals((String)"Check size", (long)FileUtils.sizeOfDirectory((File)srcDir), (long)FileUtils.sizeOfDirectory((File)actualDestDir));
        FileUtilsTestCase.assertTrue((boolean)new File(actualDestDir, "sub/A.txt").exists());
        FileUtils.deleteDirectory((File)destDir);
    }

    public void testCopyDirectoryToNonExistingDest() throws Exception {
        this.createFile(this.testFile1, 1234L);
        this.createFile(this.testFile2, 4321L);
        File srcDir = FileUtilsTestCase.getTestDirectory();
        File subDir = new File(srcDir, "sub");
        subDir.mkdir();
        File subFile = new File(subDir, "A.txt");
        FileUtils.writeStringToFile((File)subFile, (String)"HELLO WORLD", (String)"UTF8");
        File destDir = new File(System.getProperty("java.io.tmpdir"), "tmp-FileUtilsTestCase");
        FileUtils.deleteDirectory((File)destDir);
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
        FileUtilsTestCase.assertTrue((String)"Check exists", (boolean)destDir.exists());
        FileUtilsTestCase.assertEquals((String)"Check size", (long)FileUtils.sizeOfDirectory((File)srcDir), (long)FileUtils.sizeOfDirectory((File)destDir));
        FileUtilsTestCase.assertTrue((boolean)new File(destDir, "sub/A.txt").exists());
        FileUtils.deleteDirectory((File)destDir);
    }

    public void testCopyDirectoryToExistingDest() throws Exception {
        this.createFile(this.testFile1, 1234L);
        this.createFile(this.testFile2, 4321L);
        File srcDir = FileUtilsTestCase.getTestDirectory();
        File subDir = new File(srcDir, "sub");
        subDir.mkdir();
        File subFile = new File(subDir, "A.txt");
        FileUtils.writeStringToFile((File)subFile, (String)"HELLO WORLD", (String)"UTF8");
        File destDir = new File(System.getProperty("java.io.tmpdir"), "tmp-FileUtilsTestCase");
        FileUtils.deleteDirectory((File)destDir);
        destDir.mkdirs();
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
        FileUtilsTestCase.assertEquals((long)FileUtils.sizeOfDirectory((File)srcDir), (long)FileUtils.sizeOfDirectory((File)destDir));
        FileUtilsTestCase.assertTrue((boolean)new File(destDir, "sub/A.txt").exists());
    }

    public void testCopyDirectoryFiltered() throws Exception {
        File grandParentDir = new File(FileUtilsTestCase.getTestDirectory(), "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parentDir, childDir);
        NameFileFilter filter = new NameFileFilter(new String[]{"parent", "child", "file3.txt"});
        File destDir = new File(FileUtilsTestCase.getTestDirectory(), "copydest");
        FileUtils.copyDirectory((File)grandParentDir, (File)destDir, (FileFilter)filter);
        List<File> files = LIST_WALKER.list(destDir);
        FileUtilsTestCase.assertEquals((int)3, (int)files.size());
        FileUtilsTestCase.assertEquals((String)"parent", (String)files.get(0).getName());
        FileUtilsTestCase.assertEquals((String)"child", (String)files.get(1).getName());
        FileUtilsTestCase.assertEquals((String)"file3.txt", (String)files.get(2).getName());
    }

    public void testCopyDirectoryPreserveDates() throws Exception {
        File source = new File(FileUtilsTestCase.getTestDirectory(), "source");
        File sourceDirectory = new File(source, "directory");
        File sourceFile = new File(sourceDirectory, "hello.txt");
        source.mkdirs();
        sourceDirectory.mkdir();
        FileUtils.writeStringToFile((File)sourceFile, (String)"HELLO WORLD", (String)"UTF8");
        sourceFile.setLastModified(1000000002000L);
        sourceDirectory.setLastModified(1000000001000L);
        source.setLastModified(1000000000000L);
        File target = new File(FileUtilsTestCase.getTestDirectory(), "target");
        File targetDirectory = new File(target, "directory");
        File targetFile = new File(targetDirectory, "hello.txt");
        FileUtils.copyDirectory((File)source, (File)target, (boolean)false);
        FileUtilsTestCase.assertTrue((1000000000000L != target.lastModified() ? 1 : 0) != 0);
        FileUtilsTestCase.assertTrue((1000000001000L != targetDirectory.lastModified() ? 1 : 0) != 0);
        FileUtilsTestCase.assertTrue((1000000002000L != targetFile.lastModified() ? 1 : 0) != 0);
        FileUtils.deleteDirectory((File)target);
        FileUtils.copyDirectory((File)source, (File)target, (boolean)true);
        FileUtilsTestCase.assertEquals((long)1000000000000L, (long)target.lastModified());
        FileUtilsTestCase.assertEquals((long)1000000001000L, (long)targetDirectory.lastModified());
        FileUtilsTestCase.assertEquals((long)1000000002000L, (long)targetFile.lastModified());
        FileUtils.deleteDirectory((File)target);
        target.mkdirs();
        FileUtils.copyDirectory((File)source, (File)target, (boolean)true);
        FileUtilsTestCase.assertEquals((long)1000000000000L, (long)target.lastModified());
        FileUtilsTestCase.assertEquals((long)1000000001000L, (long)targetDirectory.lastModified());
        FileUtilsTestCase.assertEquals((long)1000000002000L, (long)targetFile.lastModified());
        FileUtils.deleteDirectory((File)target);
        targetDirectory.mkdirs();
        FileUtils.copyDirectory((File)source, (File)target, (boolean)true);
        FileUtilsTestCase.assertEquals((long)1000000000000L, (long)target.lastModified());
        FileUtilsTestCase.assertEquals((long)1000000001000L, (long)targetDirectory.lastModified());
        FileUtilsTestCase.assertEquals((long)1000000002000L, (long)targetFile.lastModified());
        FileUtils.deleteDirectory((File)target);
    }

    public void testCopyDirectoryToChild() throws Exception {
        File grandParentDir = new File(FileUtilsTestCase.getTestDirectory(), "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parentDir, childDir);
        long expectedCount = LIST_WALKER.list(grandParentDir).size() + LIST_WALKER.list(parentDir).size();
        long expectedSize = FileUtils.sizeOfDirectory((File)grandParentDir) + FileUtils.sizeOfDirectory((File)parentDir);
        FileUtils.copyDirectory((File)parentDir, (File)childDir);
        FileUtilsTestCase.assertEquals((long)expectedCount, (long)LIST_WALKER.list(grandParentDir).size());
        FileUtilsTestCase.assertEquals((long)expectedSize, (long)FileUtils.sizeOfDirectory((File)grandParentDir));
    }

    public void testCopyDirectoryToGrandChild() throws Exception {
        File grandParentDir = new File(FileUtilsTestCase.getTestDirectory(), "grandparent");
        File parentDir = new File(grandParentDir, "parent");
        File childDir = new File(parentDir, "child");
        this.createFilesForTestCopyDirectory(grandParentDir, parentDir, childDir);
        long expectedCount = LIST_WALKER.list(grandParentDir).size() * 2;
        long expectedSize = FileUtils.sizeOfDirectory((File)grandParentDir) * 2L;
        FileUtils.copyDirectory((File)grandParentDir, (File)childDir);
        FileUtilsTestCase.assertEquals((long)expectedCount, (long)LIST_WALKER.list(grandParentDir).size());
        FileUtilsTestCase.assertEquals((long)expectedSize, (long)FileUtils.sizeOfDirectory((File)grandParentDir));
    }

    public void testCopyDirectoryToItself() throws Exception {
        File dir = new File(FileUtilsTestCase.getTestDirectory(), "itself");
        dir.mkdirs();
        FileUtils.copyDirectoryToDirectory((File)dir, (File)dir);
        FileUtilsTestCase.assertEquals((int)1, (int)LIST_WALKER.list(dir).size());
    }

    private void createFilesForTestCopyDirectory(File grandParentDir, File parentDir, File childDir) throws Exception {
        File childDir2 = new File(parentDir, "child2");
        File grandChildDir = new File(childDir, "grandChild");
        File grandChild2Dir = new File(childDir2, "grandChild2");
        File file1 = new File(grandParentDir, "file1.txt");
        File file2 = new File(parentDir, "file2.txt");
        File file3 = new File(childDir, "file3.txt");
        File file4 = new File(childDir2, "file4.txt");
        File file5 = new File(grandChildDir, "file5.txt");
        File file6 = new File(grandChild2Dir, "file6.txt");
        FileUtils.deleteDirectory((File)grandParentDir);
        grandChildDir.mkdirs();
        grandChild2Dir.mkdirs();
        FileUtils.writeStringToFile((File)file1, (String)"File 1 in grandparent", (String)"UTF8");
        FileUtils.writeStringToFile((File)file2, (String)"File 2 in parent", (String)"UTF8");
        FileUtils.writeStringToFile((File)file3, (String)"File 3 in child", (String)"UTF8");
        FileUtils.writeStringToFile((File)file4, (String)"File 4 in child2", (String)"UTF8");
        FileUtils.writeStringToFile((File)file5, (String)"File 5 in grandChild", (String)"UTF8");
        FileUtils.writeStringToFile((File)file6, (String)"File 6 in grandChild2", (String)"UTF8");
    }

    public void testCopyDirectoryErrors() throws Exception {
        try {
            FileUtils.copyDirectory(null, null);
            FileUtilsTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            FileUtils.copyDirectory((File)new File("a"), null);
            FileUtilsTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            FileUtils.copyDirectory(null, (File)new File("a"));
            FileUtilsTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            FileUtils.copyDirectory((File)new File("doesnt-exist"), (File)new File("a"));
            FileUtilsTestCase.fail();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            FileUtils.copyDirectory((File)this.testFile1, (File)new File("a"));
            FileUtilsTestCase.fail();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            FileUtils.copyDirectory((File)FileUtilsTestCase.getTestDirectory(), (File)this.testFile1);
            FileUtilsTestCase.fail();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            FileUtils.copyDirectory((File)FileUtilsTestCase.getTestDirectory(), (File)FileUtilsTestCase.getTestDirectory());
            FileUtilsTestCase.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testForceDeleteAFile1() throws Exception {
        File destination = new File(FileUtilsTestCase.getTestDirectory(), "copy1.txt");
        destination.createNewFile();
        FileUtilsTestCase.assertTrue((String)"Copy1.txt doesn't exist to delete", (boolean)destination.exists());
        FileUtils.forceDelete((File)destination);
        FileUtilsTestCase.assertTrue((String)"Check No Exist", (!destination.exists() ? 1 : 0) != 0);
    }

    public void testForceDeleteAFile2() throws Exception {
        File destination = new File(FileUtilsTestCase.getTestDirectory(), "copy2.txt");
        destination.createNewFile();
        FileUtilsTestCase.assertTrue((String)"Copy2.txt doesn't exist to delete", (boolean)destination.exists());
        FileUtils.forceDelete((File)destination);
        FileUtilsTestCase.assertTrue((String)"Check No Exist", (!destination.exists() ? 1 : 0) != 0);
    }

    public void testForceDeleteAFile3() throws Exception {
        File destination = new File(FileUtilsTestCase.getTestDirectory(), "no_such_file");
        FileUtilsTestCase.assertTrue((String)"Check No Exist", (!destination.exists() ? 1 : 0) != 0);
        try {
            FileUtils.forceDelete((File)destination);
            FileUtilsTestCase.fail((String)"Should generate FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void testCopyFile1ToDir() throws Exception {
        File directory = new File(FileUtilsTestCase.getTestDirectory(), "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File destination = new File(directory, this.testFile1.getName());
        FileUtils.copyFileToDirectory((File)this.testFile1, (File)directory);
        FileUtilsTestCase.assertTrue((String)"Check Exist", (boolean)destination.exists());
        FileUtilsTestCase.assertEquals((String)"Check Full copy", (long)this.testFile1Size, (long)destination.length());
        try {
            FileUtils.copyFileToDirectory((File)destination, (File)directory);
            FileUtilsTestCase.fail((String)"Should not be able to copy a file into the same directory as itself");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testCopyFile2ToDir() throws Exception {
        File directory = new File(FileUtilsTestCase.getTestDirectory(), "subdir");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File destination = new File(directory, this.testFile1.getName());
        FileUtils.copyFileToDirectory((File)this.testFile1, (File)directory);
        FileUtilsTestCase.assertTrue((String)"Check Exist", (boolean)destination.exists());
        FileUtilsTestCase.assertEquals((String)"Check Full copy", (long)this.testFile2Size, (long)destination.length());
    }

    public void testForceDeleteDir() throws Exception {
        File testDirectory = FileUtilsTestCase.getTestDirectory();
        FileUtils.forceDelete((File)testDirectory.getParentFile());
        FileUtilsTestCase.assertTrue((String)"Check No Exist", (!testDirectory.getParentFile().exists() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFileUtils() throws Exception {
        File file1 = new File(FileUtilsTestCase.getTestDirectory(), "test.txt");
        String filename = file1.getAbsolutePath();
        FileOutputStream out = new FileOutputStream(file1);
        try {
            ((OutputStream)out).write("This is a test".getBytes("UTF-8"));
        }
        finally {
            ((OutputStream)out).close();
        }
        File file2 = new File(FileUtilsTestCase.getTestDirectory(), "test2.txt");
        FileUtils.writeStringToFile((File)file2, (String)filename, (String)"UTF-8");
        FileUtilsTestCase.assertTrue((boolean)file2.exists());
        FileUtilsTestCase.assertTrue((file2.length() > 0L ? 1 : 0) != 0);
        String file2contents = FileUtils.readFileToString((File)file2, (String)"UTF-8");
        FileUtilsTestCase.assertTrue((String)"Second file's contents correct", (boolean)filename.equals(file2contents));
        FileUtilsTestCase.assertTrue((boolean)file2.delete());
        String contents = FileUtils.readFileToString((File)new File(filename), (String)"UTF-8");
        FileUtilsTestCase.assertEquals((String)"FileUtils.fileRead()", (String)"This is a test", (String)contents);
    }

    public void testTouch() throws IOException {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "touch.txt");
        if (file.exists()) {
            file.delete();
        }
        FileUtilsTestCase.assertTrue((String)"Bad test: test file still exists", (!file.exists() ? 1 : 0) != 0);
        FileUtils.touch((File)file);
        FileUtilsTestCase.assertTrue((String)"FileUtils.touch() created file", (boolean)file.exists());
        FileOutputStream out = new FileOutputStream(file);
        FileUtilsTestCase.assertEquals((String)"Created empty file.", (long)0L, (long)file.length());
        out.write(0);
        out.close();
        FileUtilsTestCase.assertEquals((String)"Wrote one byte to file", (long)1L, (long)file.length());
        long y2k = new GregorianCalendar(2000, 0, 1).getTime().getTime();
        boolean res = file.setLastModified(y2k);
        FileUtilsTestCase.assertEquals((String)"Bad test: set lastModified failed", (boolean)true, (boolean)res);
        FileUtilsTestCase.assertEquals((String)"Bad test: set lastModified set incorrect value", (long)y2k, (long)file.lastModified());
        long now = System.currentTimeMillis();
        FileUtils.touch((File)file);
        FileUtilsTestCase.assertEquals((String)"FileUtils.touch() didn't empty the file.", (long)1L, (long)file.length());
        FileUtilsTestCase.assertEquals((String)"FileUtils.touch() changed lastModified", (boolean)false, (y2k == file.lastModified() ? 1 : 0) != 0);
        FileUtilsTestCase.assertEquals((String)"FileUtils.touch() changed lastModified to more than now-3s", (boolean)true, (file.lastModified() >= now - 3000L ? 1 : 0) != 0);
        FileUtilsTestCase.assertEquals((String)"FileUtils.touch() changed lastModified to less than now+3s", (boolean)true, (file.lastModified() <= now + 3000L ? 1 : 0) != 0);
    }

    public void testListFiles() throws Exception {
        File srcDir = FileUtilsTestCase.getTestDirectory();
        File subDir = new File(srcDir, "list_test");
        subDir.mkdir();
        File subDir2 = new File(subDir, "subdir");
        subDir2.mkdir();
        String[] fileNames = new String[]{"a.txt", "b.txt", "c.txt", "d.txt", "e.txt", "f.txt"};
        int[] fileSizes = new int[]{123, 234, 345, 456, 678, 789};
        for (int i = 0; i < fileNames.length; ++i) {
            File theFile = new File(subDir, fileNames[i]);
            this.createFile(theFile, fileSizes[i]);
        }
        Collection files = FileUtils.listFiles((File)subDir, (IOFileFilter)new WildcardFileFilter("*.*"), (IOFileFilter)new WildcardFileFilter("*"));
        int count = files.size();
        Object[] fileObjs = files.toArray();
        FileUtilsTestCase.assertEquals((int)fileNames.length, (int)files.size());
        HashMap<String, String> foundFileNames = new HashMap<String, String>();
        for (int i = 0; i < count; ++i) {
            boolean found = false;
            for (int j = 0; !found && j < fileNames.length; ++j) {
                if (!fileNames[j].equals(((File)fileObjs[i]).getName())) continue;
                foundFileNames.put(fileNames[j], fileNames[j]);
                found = true;
            }
        }
        FileUtilsTestCase.assertEquals((int)foundFileNames.size(), (int)fileNames.length);
        subDir.delete();
    }

    public void testListFilesWithDirs() throws IOException {
        File srcDir = FileUtilsTestCase.getTestDirectory();
        File subDir1 = new File(srcDir, "subdir");
        subDir1.mkdir();
        File subDir2 = new File(subDir1, "subdir2");
        subDir2.mkdir();
        File someFile = new File(subDir2, "a.txt");
        this.createFile(someFile, 100L);
        File subDir3 = new File(subDir2, "subdir3");
        subDir3.mkdir();
        Collection files = FileUtils.listFilesAndDirs((File)subDir1, (IOFileFilter)new WildcardFileFilter("*.*"), (IOFileFilter)new WildcardFileFilter("*"));
        FileUtilsTestCase.assertEquals((int)4, (int)files.size());
        FileUtilsTestCase.assertTrue((String)"Should contain the directory.", (boolean)files.contains(subDir1));
        FileUtilsTestCase.assertTrue((String)"Should contain the directory.", (boolean)files.contains(subDir2));
        FileUtilsTestCase.assertTrue((String)"Should contain the file.", (boolean)files.contains(someFile));
        FileUtilsTestCase.assertTrue((String)"Should contain the directory.", (boolean)files.contains(subDir3));
        subDir1.delete();
    }

    public void testIterateFiles() throws Exception {
        File srcDir = FileUtilsTestCase.getTestDirectory();
        File subDir = new File(srcDir, "list_test");
        subDir.mkdir();
        String[] fileNames = new String[]{"a.txt", "b.txt", "c.txt", "d.txt", "e.txt", "f.txt"};
        int[] fileSizes = new int[]{123, 234, 345, 456, 678, 789};
        for (int i = 0; i < fileNames.length; ++i) {
            File theFile = new File(subDir, fileNames[i]);
            this.createFile(theFile, fileSizes[i]);
        }
        Iterator files = FileUtils.iterateFiles((File)subDir, (IOFileFilter)new WildcardFileFilter("*.*"), (IOFileFilter)new WildcardFileFilter("*"));
        HashMap<String, String> foundFileNames = new HashMap<String, String>();
        while (files.hasNext()) {
            boolean found = false;
            String fileName = ((File)files.next()).getName();
            for (int j = 0; !found && j < fileNames.length; ++j) {
                if (!fileNames[j].equals(fileName)) continue;
                foundFileNames.put(fileNames[j], fileNames[j]);
                found = true;
            }
        }
        FileUtilsTestCase.assertEquals((int)foundFileNames.size(), (int)fileNames.length);
        subDir.delete();
    }

    public void testIterateFilesAndDirs() throws IOException {
        File srcDir = FileUtilsTestCase.getTestDirectory();
        File subDir1 = new File(srcDir, "subdir");
        subDir1.mkdir();
        File subDir2 = new File(subDir1, "subdir2");
        subDir2.mkdir();
        File someFile = new File(subDir2, "a.txt");
        this.createFile(someFile, 100L);
        File subDir3 = new File(subDir2, "subdir3");
        subDir3.mkdir();
        List<File> filesAndDirs = Arrays.asList(subDir1, subDir2, someFile, subDir3);
        int filesCount = 0;
        Iterator files = FileUtils.iterateFilesAndDirs((File)subDir1, (IOFileFilter)new WildcardFileFilter("*.*"), (IOFileFilter)new WildcardFileFilter("*"));
        while (files.hasNext()) {
            ++filesCount;
            File file = (File)files.next();
            FileUtilsTestCase.assertTrue((String)"Should contain the directory/file", (boolean)filesAndDirs.contains(file));
        }
        FileUtilsTestCase.assertEquals((int)filesCount, (int)filesAndDirs.size());
    }

    public void testReadFileToStringWithDefaultEncoding() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "read.obj");
        FileOutputStream out = new FileOutputStream(file);
        byte[] text = "Hello /u1234".getBytes();
        out.write(text);
        out.close();
        String data = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)"Hello /u1234", (String)data);
    }

    public void testReadFileToStringWithEncoding() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "read.obj");
        FileOutputStream out = new FileOutputStream(file);
        byte[] text = "Hello /u1234".getBytes("UTF8");
        out.write(text);
        out.close();
        String data = FileUtils.readFileToString((File)file, (String)"UTF8");
        FileUtilsTestCase.assertEquals((String)"Hello /u1234", (String)data);
    }

    public void testReadFileToByteArray() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "read.txt");
        FileOutputStream out = new FileOutputStream(file);
        out.write(11);
        out.write(21);
        out.write(31);
        out.close();
        byte[] data = FileUtils.readFileToByteArray((File)file);
        FileUtilsTestCase.assertEquals((int)3, (int)data.length);
        FileUtilsTestCase.assertEquals((int)11, (int)data[0]);
        FileUtilsTestCase.assertEquals((int)21, (int)data[1]);
        FileUtilsTestCase.assertEquals((int)31, (int)data[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadLines() throws Exception {
        File file = this.newFile("lines.txt");
        try {
            String[] data = new String[]{"hello", "/u1234", "", "this is", "some text"};
            this.createLineBasedFile(file, data);
            List lines = FileUtils.readLines((File)file, (String)"UTF-8");
            FileUtilsTestCase.assertEquals(Arrays.asList(data), (Object)lines);
        }
        finally {
            this.deleteFile(file);
        }
    }

    public void testWriteStringToFile1() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "write.txt");
        FileUtils.writeStringToFile((File)file, (String)"Hello /u1234", (String)"UTF8");
        byte[] text = "Hello /u1234".getBytes("UTF8");
        this.assertEqualContent(text, file);
    }

    public void testWriteStringToFile2() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "write.txt");
        FileUtils.writeStringToFile((File)file, (String)"Hello /u1234", null);
        byte[] text = "Hello /u1234".getBytes();
        this.assertEqualContent(text, file);
    }

    public void testWriteCharSequence1() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "write.txt");
        FileUtils.write((File)file, (CharSequence)"Hello /u1234", (String)"UTF8");
        byte[] text = "Hello /u1234".getBytes("UTF8");
        this.assertEqualContent(text, file);
    }

    public void testWriteCharSequence2() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "write.txt");
        FileUtils.write((File)file, (CharSequence)"Hello /u1234", null);
        byte[] text = "Hello /u1234".getBytes();
        this.assertEqualContent(text, file);
    }

    public void testWriteByteArrayToFile() throws Exception {
        File file = new File(FileUtilsTestCase.getTestDirectory(), "write.obj");
        byte[] data = new byte[]{11, 21, 31};
        FileUtils.writeByteArrayToFile((File)file, (byte[])data);
        this.assertEqualContent(data, file);
    }

    public void testWriteLines_4arg() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        File file = this.newFile("lines.txt");
        FileUtils.writeLines((File)file, (String)"US-ASCII", list, (String)"*");
        String expected = "hello*world**this is**some text*";
        String actual = FileUtils.readFileToString((File)file, (String)"US-ASCII");
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_4arg_Writer_nullData() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeLines((File)file, (String)"US-ASCII", (Collection)null, (String)"*");
        FileUtilsTestCase.assertEquals((String)"Sizes differ", (long)0L, (long)file.length());
    }

    public void testWriteLines_4arg_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        File file = this.newFile("lines.txt");
        FileUtils.writeLines((File)file, (String)"US-ASCII", list, null);
        String expected = "hello" + IOUtils.LINE_SEPARATOR + "world" + IOUtils.LINE_SEPARATOR + IOUtils.LINE_SEPARATOR + "this is" + IOUtils.LINE_SEPARATOR + IOUtils.LINE_SEPARATOR + "some text" + IOUtils.LINE_SEPARATOR;
        String actual = FileUtils.readFileToString((File)file, (String)"US-ASCII");
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_3arg_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        File file = this.newFile("lines.txt");
        FileUtils.writeLines((File)file, (String)"US-ASCII", list);
        String expected = "hello" + IOUtils.LINE_SEPARATOR + "world" + IOUtils.LINE_SEPARATOR + IOUtils.LINE_SEPARATOR + "this is" + IOUtils.LINE_SEPARATOR + IOUtils.LINE_SEPARATOR + "some text" + IOUtils.LINE_SEPARATOR;
        String actual = FileUtils.readFileToString((File)file, (String)"US-ASCII");
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_5argsWithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, null, linesToAppend, null, (boolean)true);
        String expected = "This line was there before you...my first line" + IOUtils.LINE_SEPARATOR + "The second Line" + IOUtils.LINE_SEPARATOR;
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_5argsWithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, null, linesToAppend, null, (boolean)false);
        String expected = "my first line" + IOUtils.LINE_SEPARATOR + "The second Line" + IOUtils.LINE_SEPARATOR;
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_4argsWithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, linesToAppend, null, (boolean)true);
        String expected = "This line was there before you...my first line" + IOUtils.LINE_SEPARATOR + "The second Line" + IOUtils.LINE_SEPARATOR;
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_4argsWithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, linesToAppend, null, (boolean)false);
        String expected = "my first line" + IOUtils.LINE_SEPARATOR + "The second Line" + IOUtils.LINE_SEPARATOR;
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLinesEncoding_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, null, linesToAppend, (boolean)true);
        String expected = "This line was there before you...my first line" + IOUtils.LINE_SEPARATOR + "The second Line" + IOUtils.LINE_SEPARATOR;
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLinesEncoding_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, null, linesToAppend, (boolean)false);
        String expected = "my first line" + IOUtils.LINE_SEPARATOR + "The second Line" + IOUtils.LINE_SEPARATOR;
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_3argsWithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, linesToAppend, (boolean)true);
        String expected = "This line was there before you...my first line" + IOUtils.LINE_SEPARATOR + "The second Line" + IOUtils.LINE_SEPARATOR;
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_3argsWithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        List<String> linesToAppend = Arrays.asList("my first line", "The second Line");
        FileUtils.writeLines((File)file, linesToAppend, (boolean)false);
        String expected = "my first line" + IOUtils.LINE_SEPARATOR + "The second Line" + IOUtils.LINE_SEPARATOR;
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteStringToFileWithEncoding_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeStringToFile((File)file, (String)"this is brand new data", null, (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteStringToFileWithEncoding_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeStringToFile((File)file, (String)"this is brand new data", null, (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteStringToFile_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeStringToFile((File)file, (String)"this is brand new data", (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteStringToFile_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeStringToFile((File)file, (String)"this is brand new data", (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteWithEncoding_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.write((File)file, (CharSequence)"this is brand new data", null, (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteWithEncoding_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.write((File)file, (CharSequence)"this is brand new data", null, (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWrite_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.write((File)file, (CharSequence)"this is brand new data", (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWrite_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.write((File)file, (CharSequence)"this is brand new data", (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteByteArrayToFile_WithAppendOptionTrue_ShouldNotDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeByteArrayToFile((File)file, (byte[])"this is brand new data".getBytes(), (boolean)true);
        String expected = "This line was there before you...this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteByteArrayToFile_WithAppendOptionFalse_ShouldDeletePreviousFileLines() throws Exception {
        File file = this.newFile("lines.txt");
        FileUtils.writeStringToFile((File)file, (String)"This line was there before you...");
        FileUtils.writeByteArrayToFile((File)file, (byte[])"this is brand new data".getBytes(), (boolean)false);
        String expected = "this is brand new data";
        String actual = FileUtils.readFileToString((File)file);
        FileUtilsTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testChecksumCRC32() throws Exception {
        String text = "Imagination is more important than knowledge - Einstein";
        File file = new File(FileUtilsTestCase.getTestDirectory(), "checksum-test.txt");
        FileUtils.writeStringToFile((File)file, (String)text, (String)"US-ASCII");
        CRC32 expectedChecksum = new CRC32();
        expectedChecksum.update(text.getBytes("US-ASCII"), 0, text.length());
        long expectedValue = expectedChecksum.getValue();
        long resultValue = FileUtils.checksumCRC32((File)file);
        FileUtilsTestCase.assertEquals((long)expectedValue, (long)resultValue);
    }

    public void testChecksum() throws Exception {
        String text = "Imagination is more important than knowledge - Einstein";
        File file = new File(FileUtilsTestCase.getTestDirectory(), "checksum-test.txt");
        FileUtils.writeStringToFile((File)file, (String)text, (String)"US-ASCII");
        CRC32 expectedChecksum = new CRC32();
        expectedChecksum.update(text.getBytes("US-ASCII"), 0, text.length());
        long expectedValue = expectedChecksum.getValue();
        CRC32 testChecksum = new CRC32();
        Checksum resultChecksum = FileUtils.checksum((File)file, (Checksum)testChecksum);
        long resultValue = resultChecksum.getValue();
        FileUtilsTestCase.assertSame((Object)testChecksum, (Object)resultChecksum);
        FileUtilsTestCase.assertEquals((long)expectedValue, (long)resultValue);
    }

    public void testChecksumOnNullFile() throws Exception {
        try {
            FileUtils.checksum((File)null, (Checksum)new CRC32());
            FileUtilsTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testChecksumOnNullChecksum() throws Exception {
        String text = "Imagination is more important than knowledge - Einstein";
        File file = new File(FileUtilsTestCase.getTestDirectory(), "checksum-test.txt");
        FileUtils.writeStringToFile((File)file, (String)text, (String)"US-ASCII");
        try {
            FileUtils.checksum((File)file, (Checksum)null);
            FileUtilsTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testChecksumOnDirectory() throws Exception {
        try {
            FileUtils.checksum((File)new File("."), (Checksum)new CRC32());
            FileUtilsTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testChecksumDouble() throws Exception {
        String text1 = "Imagination is more important than knowledge - Einstein";
        File file1 = new File(FileUtilsTestCase.getTestDirectory(), "checksum-test.txt");
        FileUtils.writeStringToFile((File)file1, (String)text1, (String)"US-ASCII");
        String text2 = "To be or not to be - Shakespeare";
        File file2 = new File(FileUtilsTestCase.getTestDirectory(), "checksum-test2.txt");
        FileUtils.writeStringToFile((File)file2, (String)text2, (String)"US-ASCII");
        CRC32 expectedChecksum = new CRC32();
        expectedChecksum.update(text1.getBytes("US-ASCII"), 0, text1.length());
        expectedChecksum.update(text2.getBytes("US-ASCII"), 0, text2.length());
        long expectedValue = expectedChecksum.getValue();
        CRC32 testChecksum = new CRC32();
        FileUtils.checksum((File)file1, (Checksum)testChecksum);
        FileUtils.checksum((File)file2, (Checksum)testChecksum);
        long resultValue = testChecksum.getValue();
        FileUtilsTestCase.assertEquals((long)expectedValue, (long)resultValue);
    }

    public void testDeleteQuietlyForNull() {
        try {
            FileUtils.deleteQuietly(null);
        }
        catch (Exception ex) {
            FileUtilsTestCase.fail((String)ex.getMessage());
        }
    }

    public void testDeleteQuietlyDir() throws IOException {
        File testDirectory = new File(FileUtilsTestCase.getTestDirectory(), "testDeleteQuietlyDir");
        File testFile = new File(testDirectory, "testDeleteQuietlyFile");
        testDirectory.mkdirs();
        this.createFile(testFile, 0L);
        FileUtilsTestCase.assertTrue((boolean)testDirectory.exists());
        FileUtilsTestCase.assertTrue((boolean)testFile.exists());
        FileUtils.deleteQuietly((File)testDirectory);
        FileUtilsTestCase.assertFalse((String)"Check No Exist", (boolean)testDirectory.exists());
        FileUtilsTestCase.assertFalse((String)"Check No Exist", (boolean)testFile.exists());
    }

    public void testDeleteQuietlyFile() throws IOException {
        File testFile = new File(FileUtilsTestCase.getTestDirectory(), "testDeleteQuietlyFile");
        this.createFile(testFile, 0L);
        FileUtilsTestCase.assertTrue((boolean)testFile.exists());
        FileUtils.deleteQuietly((File)testFile);
        FileUtilsTestCase.assertFalse((String)"Check No Exist", (boolean)testFile.exists());
    }

    public void testDeleteQuietlyNonExistent() {
        File testFile = new File("testDeleteQuietlyNonExistent");
        FileUtilsTestCase.assertFalse((boolean)testFile.exists());
        try {
            FileUtils.deleteQuietly((File)testFile);
        }
        catch (Exception ex) {
            FileUtilsTestCase.fail((String)ex.getMessage());
        }
    }

    public void testMoveFile_Rename() throws Exception {
        File destination = new File(FileUtilsTestCase.getTestDirectory(), "move1.txt");
        FileUtils.moveFile((File)this.testFile1, (File)destination);
        FileUtilsTestCase.assertTrue((String)"Check Exist", (boolean)destination.exists());
        FileUtilsTestCase.assertTrue((String)"Original deleted", (!this.testFile1.exists() ? 1 : 0) != 0);
    }

    public void testMoveFile_CopyDelete() throws Exception {
        File destination = new File(FileUtilsTestCase.getTestDirectory(), "move2.txt");
        File src = new File(this.testFile1.getAbsolutePath()){

            public boolean renameTo(File f) {
                return false;
            }
        };
        FileUtils.moveFile((File)src, (File)destination);
        FileUtilsTestCase.assertTrue((String)"Check Exist", (boolean)destination.exists());
        FileUtilsTestCase.assertTrue((String)"Original deleted", (!src.exists() ? 1 : 0) != 0);
    }

    public void testMoveFile_CopyDelete_Failed() throws Exception {
        File destination = new File(FileUtilsTestCase.getTestDirectory(), "move3.txt");
        File src = new File(this.testFile1.getAbsolutePath()){

            public boolean renameTo(File f) {
                return false;
            }

            public boolean delete() {
                return false;
            }
        };
        try {
            FileUtils.moveFile((File)src, (File)destination);
            FileUtilsTestCase.fail((String)"move should have failed as src has not been deleted");
        }
        catch (IOException e) {
            FileUtilsTestCase.assertTrue((String)"Check Rollback", (!destination.exists() ? 1 : 0) != 0);
            FileUtilsTestCase.assertTrue((String)"Original exists", (boolean)src.exists());
        }
    }

    public void testMoveFile_Errors() throws Exception {
        try {
            FileUtils.moveFile(null, (File)new File("foo"));
            FileUtilsTestCase.fail((String)"Expected NullPointerException when source is null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            FileUtils.moveFile((File)new File("foo"), null);
            FileUtilsTestCase.fail((String)"Expected NullPointerException when destination is null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            FileUtils.moveFile((File)new File("nonexistant"), (File)new File("foo"));
            FileUtilsTestCase.fail((String)"Expected FileNotFoundException for source");
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try {
            FileUtils.moveFile((File)FileUtilsTestCase.getTestDirectory(), (File)new File("foo"));
            FileUtilsTestCase.fail((String)"Expected IOException when source is a directory");
        }
        catch (IOException e) {
            // empty catch block
        }
        File testSourceFile = new File(FileUtilsTestCase.getTestDirectory(), "testMoveFileSource");
        File testDestFile = new File(FileUtilsTestCase.getTestDirectory(), "testMoveFileSource");
        this.createFile(testSourceFile, 0L);
        this.createFile(testDestFile, 0L);
        try {
            FileUtils.moveFile((File)testSourceFile, (File)testDestFile);
            FileUtilsTestCase.fail((String)"Expected FileExistsException when dest already exists");
        }
        catch (FileExistsException fileExistsException) {
            // empty catch block
        }
    }

    public void testMoveFileToDirectory() throws Exception {
        File destDir = new File(FileUtilsTestCase.getTestDirectory(), "moveFileDestDir");
        File movedFile = new File(destDir, this.testFile1.getName());
        FileUtilsTestCase.assertFalse((String)"Check Exist before", (boolean)destDir.exists());
        FileUtilsTestCase.assertFalse((String)"Check Exist before", (boolean)movedFile.exists());
        FileUtils.moveFileToDirectory((File)this.testFile1, (File)destDir, (boolean)true);
        FileUtilsTestCase.assertTrue((String)"Check Exist after", (boolean)movedFile.exists());
        FileUtilsTestCase.assertTrue((String)"Original deleted", (!this.testFile1.exists() ? 1 : 0) != 0);
    }

    public void testMoveFileToDirectory_Errors() throws Exception {
        try {
            FileUtils.moveFileToDirectory(null, (File)new File("foo"), (boolean)true);
            FileUtilsTestCase.fail((String)"Expected NullPointerException when source is null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            FileUtils.moveFileToDirectory((File)new File("foo"), null, (boolean)true);
            FileUtilsTestCase.fail((String)"Expected NullPointerException when destination is null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        File testFile1 = new File(FileUtilsTestCase.getTestDirectory(), "testMoveFileFile1");
        File testFile2 = new File(FileUtilsTestCase.getTestDirectory(), "testMoveFileFile2");
        this.createFile(testFile1, 0L);
        this.createFile(testFile2, 0L);
        try {
            FileUtils.moveFileToDirectory((File)testFile1, (File)testFile2, (boolean)true);
            FileUtilsTestCase.fail((String)"Expected IOException when dest not a directory");
        }
        catch (IOException e) {
            // empty catch block
        }
        File nonexistant = new File(FileUtilsTestCase.getTestDirectory(), "testMoveFileNonExistant");
        try {
            FileUtils.moveFileToDirectory((File)testFile1, (File)nonexistant, (boolean)false);
            FileUtilsTestCase.fail((String)"Expected IOException when dest does not exist and create=false");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void testMoveDirectory_Rename() throws Exception {
        File dir = FileUtilsTestCase.getTestDirectory();
        File src = new File(dir, "testMoveDirectory1Source");
        File testDir = new File(src, "foo");
        File testFile = new File(testDir, "bar");
        testDir.mkdirs();
        this.createFile(testFile, 0L);
        File destination = new File(dir, "testMoveDirectory1Dest");
        FileUtils.deleteDirectory((File)destination);
        FileUtils.moveDirectory((File)src, (File)destination);
        FileUtilsTestCase.assertTrue((String)"Check Exist", (boolean)destination.exists());
        FileUtilsTestCase.assertTrue((String)"Original deleted", (!src.exists() ? 1 : 0) != 0);
        File movedDir = new File(destination, testDir.getName());
        File movedFile = new File(movedDir, testFile.getName());
        FileUtilsTestCase.assertTrue((String)"Check dir moved", (boolean)movedDir.exists());
        FileUtilsTestCase.assertTrue((String)"Check file moved", (boolean)movedFile.exists());
    }

    public void testMoveDirectory_CopyDelete() throws Exception {
        File dir = FileUtilsTestCase.getTestDirectory();
        File src = new File(dir, "testMoveDirectory2Source"){

            public boolean renameTo(File dest) {
                return false;
            }
        };
        File testDir = new File(src, "foo");
        File testFile = new File(testDir, "bar");
        testDir.mkdirs();
        this.createFile(testFile, 0L);
        File destination = new File(dir, "testMoveDirectory1Dest");
        FileUtils.deleteDirectory((File)destination);
        FileUtils.moveDirectory((File)src, (File)destination);
        FileUtilsTestCase.assertTrue((String)"Check Exist", (boolean)destination.exists());
        FileUtilsTestCase.assertTrue((String)"Original deleted", (!src.exists() ? 1 : 0) != 0);
        File movedDir = new File(destination, testDir.getName());
        File movedFile = new File(movedDir, testFile.getName());
        FileUtilsTestCase.assertTrue((String)"Check dir moved", (boolean)movedDir.exists());
        FileUtilsTestCase.assertTrue((String)"Check file moved", (boolean)movedFile.exists());
    }

    public void testMoveDirectory_Errors() throws Exception {
        try {
            FileUtils.moveDirectory(null, (File)new File("foo"));
            FileUtilsTestCase.fail((String)"Expected NullPointerException when source is null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            FileUtils.moveDirectory((File)new File("foo"), null);
            FileUtilsTestCase.fail((String)"Expected NullPointerException when destination is null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            FileUtils.moveDirectory((File)new File("nonexistant"), (File)new File("foo"));
            FileUtilsTestCase.fail((String)"Expected FileNotFoundException for source");
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        File testFile = new File(FileUtilsTestCase.getTestDirectory(), "testMoveDirectoryFile");
        this.createFile(testFile, 0L);
        try {
            FileUtils.moveDirectory((File)testFile, (File)new File("foo"));
            FileUtilsTestCase.fail((String)"Expected IOException when source is not a directory");
        }
        catch (IOException e) {
            // empty catch block
        }
        File testSrcFile = new File(FileUtilsTestCase.getTestDirectory(), "testMoveDirectorySource");
        File testDestFile = new File(FileUtilsTestCase.getTestDirectory(), "testMoveDirectoryDest");
        testSrcFile.mkdir();
        testDestFile.mkdir();
        try {
            FileUtils.moveDirectory((File)testSrcFile, (File)testDestFile);
            FileUtilsTestCase.fail((String)"Expected FileExistsException when dest already exists");
        }
        catch (FileExistsException e) {
            // empty catch block
        }
    }

    public void testMoveDirectoryToDirectory() throws Exception {
        File dir = FileUtilsTestCase.getTestDirectory();
        File src = new File(dir, "testMoveDirectory1Source");
        File testChildDir = new File(src, "foo");
        File testFile = new File(testChildDir, "bar");
        testChildDir.mkdirs();
        this.createFile(testFile, 0L);
        File destDir = new File(dir, "testMoveDirectory1Dest");
        FileUtils.deleteDirectory((File)destDir);
        FileUtilsTestCase.assertFalse((String)"Check Exist before", (boolean)destDir.exists());
        FileUtils.moveDirectoryToDirectory((File)src, (File)destDir, (boolean)true);
        FileUtilsTestCase.assertTrue((String)"Check Exist after", (boolean)destDir.exists());
        FileUtilsTestCase.assertTrue((String)"Original deleted", (!src.exists() ? 1 : 0) != 0);
        File movedDir = new File(destDir, src.getName());
        File movedChildDir = new File(movedDir, testChildDir.getName());
        File movedFile = new File(movedChildDir, testFile.getName());
        FileUtilsTestCase.assertTrue((String)"Check dir moved", (boolean)movedDir.exists());
        FileUtilsTestCase.assertTrue((String)"Check child dir moved", (boolean)movedChildDir.exists());
        FileUtilsTestCase.assertTrue((String)"Check file moved", (boolean)movedFile.exists());
    }

    public void testMoveDirectoryToDirectory_Errors() throws Exception {
        try {
            FileUtils.moveDirectoryToDirectory(null, (File)new File("foo"), (boolean)true);
            FileUtilsTestCase.fail((String)"Expected NullPointerException when source is null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            FileUtils.moveDirectoryToDirectory((File)new File("foo"), null, (boolean)true);
            FileUtilsTestCase.fail((String)"Expected NullPointerException when destination is null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        File testFile1 = new File(FileUtilsTestCase.getTestDirectory(), "testMoveFileFile1");
        File testFile2 = new File(FileUtilsTestCase.getTestDirectory(), "testMoveFileFile2");
        this.createFile(testFile1, 0L);
        this.createFile(testFile2, 0L);
        try {
            FileUtils.moveDirectoryToDirectory((File)testFile1, (File)testFile2, (boolean)true);
            FileUtilsTestCase.fail((String)"Expected IOException when dest not a directory");
        }
        catch (IOException e) {
            // empty catch block
        }
        File nonexistant = new File(FileUtilsTestCase.getTestDirectory(), "testMoveFileNonExistant");
        try {
            FileUtils.moveDirectoryToDirectory((File)testFile1, (File)nonexistant, (boolean)false);
            FileUtilsTestCase.fail((String)"Expected IOException when dest does not exist and create=false");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void testMoveToDirectory() throws Exception {
        File destDir = new File(FileUtilsTestCase.getTestDirectory(), "testMoveToDirectoryDestDir");
        File testDir = new File(FileUtilsTestCase.getTestDirectory(), "testMoveToDirectoryTestDir");
        File testFile = new File(FileUtilsTestCase.getTestDirectory(), "testMoveToDirectoryTestFile");
        testDir.mkdirs();
        this.createFile(testFile, 0L);
        File movedFile = new File(destDir, testFile.getName());
        File movedDir = new File(destDir, testFile.getName());
        FileUtilsTestCase.assertFalse((String)"Check File Doesnt exist", (boolean)movedFile.exists());
        FileUtilsTestCase.assertFalse((String)"Check Dir Doesnt exist", (boolean)movedDir.exists());
        FileUtils.moveToDirectory((File)testFile, (File)destDir, (boolean)true);
        FileUtilsTestCase.assertTrue((String)"Check File exists", (boolean)movedFile.exists());
        FileUtilsTestCase.assertFalse((String)"Check Original File doesn't exist", (boolean)testFile.exists());
        FileUtils.moveToDirectory((File)testDir, (File)destDir, (boolean)true);
        FileUtilsTestCase.assertTrue((String)"Check Dir exists", (boolean)movedDir.exists());
        FileUtilsTestCase.assertFalse((String)"Check Original Dir doesn't exist", (boolean)testDir.exists());
    }

    public void testMoveToDirectory_Errors() throws Exception {
        try {
            FileUtils.moveDirectoryToDirectory(null, (File)new File("foo"), (boolean)true);
            FileUtilsTestCase.fail((String)"Expected NullPointerException when source is null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            FileUtils.moveDirectoryToDirectory((File)new File("foo"), null, (boolean)true);
            FileUtilsTestCase.fail((String)"Expected NullPointerException when destination is null");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        File nonexistant = new File(FileUtilsTestCase.getTestDirectory(), "nonexistant");
        File destDir = new File(FileUtilsTestCase.getTestDirectory(), "MoveToDirectoryDestDir");
        try {
            FileUtils.moveToDirectory((File)nonexistant, (File)destDir, (boolean)true);
            FileUtilsTestCase.fail((String)"Expected IOException when source does not exist");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testIO300() throws Exception {
        File testDirectory = FileUtilsTestCase.getTestDirectory();
        File src = new File(testDirectory, "dir1");
        File dest = new File(src, "dir2");
        FileUtilsTestCase.assertTrue((boolean)dest.mkdirs());
        FileUtilsTestCase.assertTrue((boolean)src.exists());
        try {
            FileUtils.moveDirectoryToDirectory((File)src, (File)dest, (boolean)false);
            FileUtilsTestCase.fail((String)"expected IOException");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        FileUtilsTestCase.assertTrue((boolean)src.exists());
    }

    public void testIO276() throws Exception {
        File dir = new File("target", "IO276");
        FileUtilsTestCase.assertTrue((String)(dir + " should not be present"), (boolean)dir.mkdirs());
        File file = new File(dir, "IO276.txt");
        FileUtilsTestCase.assertTrue((String)(file + " should not be present"), (boolean)file.createNewFile());
        FileUtils.forceDeleteOnExit((File)dir);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListDirectoryWalker
    extends DirectoryWalker<File> {
        ListDirectoryWalker() {
        }

        List<File> list(File startDirectory) throws IOException {
            ArrayList<File> files = new ArrayList<File>();
            this.walk(startDirectory, files);
            return files;
        }

        protected void handleDirectoryStart(File directory, int depth, Collection<File> results) throws IOException {
            if (depth > 0) {
                results.add(directory);
            }
        }

        protected void handleFile(File file, int depth, Collection<File> results) throws IOException {
            results.add(file);
        }
    }
}

