/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.testtools.FileBasedTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineIteratorTestCase
extends FileBasedTestCase {
    public LineIteratorTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertLines(List<String> lines, LineIterator iterator) {
        try {
            for (int i = 0; i < lines.size(); ++i) {
                String line = iterator.nextLine();
                LineIteratorTestCase.assertEquals((String)("nextLine() line " + i), (String)lines.get(i), (String)line);
            }
            LineIteratorTestCase.assertFalse((String)"No more expected", (boolean)iterator.hasNext());
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    private List<String> createLinesFile(File file, int lineCount) throws Exception {
        List<String> lines = this.createStringLines(lineCount);
        FileUtils.writeLines((File)file, lines);
        return lines;
    }

    private List<String> createLinesFile(File file, String encoding, int lineCount) throws Exception {
        List<String> lines = this.createStringLines(lineCount);
        FileUtils.writeLines((File)file, (String)encoding, lines);
        return lines;
    }

    private List<String> createStringLines(int lineCount) {
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < lineCount; ++i) {
            lines.add("LINE " + i);
        }
        return lines;
    }

    protected void setUp() throws Exception {
        File dir = LineIteratorTestCase.getTestDirectory();
        if (dir.exists()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
    }

    protected void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)LineIteratorTestCase.getTestDirectory());
    }

    public void testConstructor() throws Exception {
        try {
            new LineIterator((Reader)null);
            LineIteratorTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testZeroLines() throws Exception {
        this.doTestFileWithSpecifiedLines(0);
    }

    public void testOneLines() throws Exception {
        this.doTestFileWithSpecifiedLines(1);
    }

    public void testTwoLines() throws Exception {
        this.doTestFileWithSpecifiedLines(2);
    }

    public void testThreeLines() throws Exception {
        this.doTestFileWithSpecifiedLines(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingFile() throws Exception {
        File testFile = new File(LineIteratorTestCase.getTestDirectory(), "dummy-missing-file.txt");
        LineIterator iterator = null;
        try {
            iterator = FileUtils.lineIterator((File)testFile, (String)"UTF-8");
            LineIteratorTestCase.fail((String)"Expected FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testValidEncoding() throws Exception {
        String encoding = "UTF-8";
        File testFile = new File(LineIteratorTestCase.getTestDirectory(), "LineIterator-validEncoding.txt");
        this.createLinesFile(testFile, encoding, 3);
        LineIterator iterator = FileUtils.lineIterator((File)testFile, (String)encoding);
        try {
            int count = 0;
            while (iterator.hasNext()) {
                LineIteratorTestCase.assertNotNull((Object)iterator.next());
                ++count;
            }
            LineIteratorTestCase.assertEquals((int)3, (int)count);
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidEncoding() throws Exception {
        String encoding = "XXXXXXXX";
        File testFile = new File(LineIteratorTestCase.getTestDirectory(), "LineIterator-invalidEncoding.txt");
        this.createLinesFile(testFile, "UTF-8", 3);
        LineIterator iterator = null;
        try {
            iterator = FileUtils.lineIterator((File)testFile, (String)encoding);
            LineIteratorTestCase.fail((String)"Expected UnsupportedEncodingException");
        }
        catch (UnsupportedEncodingException expected) {
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    public void testNextLineOnlyDefaultEncoding() throws Exception {
        File testFile = new File(LineIteratorTestCase.getTestDirectory(), "LineIterator-nextOnly.txt");
        List<String> lines = this.createLinesFile(testFile, 3);
        LineIterator iterator = FileUtils.lineIterator((File)testFile);
        this.assertLines(lines, iterator);
    }

    public void testNextLineOnlyNullEncoding() throws Exception {
        String encoding = null;
        File testFile = new File(LineIteratorTestCase.getTestDirectory(), "LineIterator-nextOnly.txt");
        List<String> lines = this.createLinesFile(testFile, encoding, 3);
        LineIterator iterator = FileUtils.lineIterator((File)testFile, encoding);
        this.assertLines(lines, iterator);
    }

    public void testNextLineOnlyUtf8Encoding() throws Exception {
        String encoding = "UTF-8";
        File testFile = new File(LineIteratorTestCase.getTestDirectory(), "LineIterator-nextOnly.txt");
        List<String> lines = this.createLinesFile(testFile, encoding, 3);
        LineIterator iterator = FileUtils.lineIterator((File)testFile, (String)encoding);
        this.assertLines(lines, iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNextOnly() throws Exception {
        String encoding = null;
        File testFile = new File(LineIteratorTestCase.getTestDirectory(), "LineIterator-nextOnly.txt");
        List<String> lines = this.createLinesFile(testFile, encoding, 3);
        LineIterator iterator = FileUtils.lineIterator((File)testFile, encoding);
        try {
            for (int i = 0; i < lines.size(); ++i) {
                String line = iterator.next();
                LineIteratorTestCase.assertEquals((String)("next() line " + i), (String)lines.get(i), (String)line);
            }
            LineIteratorTestCase.assertEquals((String)"No more expected", (boolean)false, (boolean)iterator.hasNext());
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    public void testNextWithException() throws Exception {
        BufferedReader reader = new BufferedReader(new StringReader("")){

            public String readLine() throws IOException {
                throw new IOException("hasNext");
            }
        };
        try {
            new LineIterator((Reader)reader).hasNext();
            LineIteratorTestCase.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCloseEarly() throws Exception {
        String encoding = "UTF-8";
        File testFile = new File(LineIteratorTestCase.getTestDirectory(), "LineIterator-closeEarly.txt");
        this.createLinesFile(testFile, encoding, 3);
        LineIterator iterator = FileUtils.lineIterator((File)testFile, (String)encoding);
        try {
            LineIteratorTestCase.assertNotNull((String)"Line expected", (Object)iterator.next());
            LineIteratorTestCase.assertTrue((String)"More expected", (boolean)iterator.hasNext());
            iterator.close();
            LineIteratorTestCase.assertFalse((String)"No more expected", (boolean)iterator.hasNext());
            try {
                iterator.next();
                LineIteratorTestCase.fail();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            try {
                iterator.nextLine();
                LineIteratorTestCase.fail();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            iterator.close();
            try {
                iterator.next();
                LineIteratorTestCase.fail();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
            try {
                iterator.nextLine();
                LineIteratorTestCase.fail();
            }
            catch (NoSuchElementException ex) {
                // empty catch block
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestFileWithSpecifiedLines(int lineCount) throws Exception {
        String encoding = "UTF-8";
        String fileName = "LineIterator-" + lineCount + "-test.txt";
        File testFile = new File(LineIteratorTestCase.getTestDirectory(), fileName);
        List<String> lines = this.createLinesFile(testFile, encoding, lineCount);
        LineIterator iterator = FileUtils.lineIterator((File)testFile, (String)encoding);
        try {
            try {
                iterator.remove();
                LineIteratorTestCase.fail((String)"Remove is unsupported");
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            int idx = 0;
            while (iterator.hasNext()) {
                String line = iterator.next();
                LineIteratorTestCase.assertEquals((String)("Comparing line " + idx), (String)lines.get(idx), (String)line);
                LineIteratorTestCase.assertTrue((String)("Exceeded expected idx=" + idx + " size=" + lines.size()), (idx < lines.size() ? 1 : 0) != 0);
                ++idx;
            }
            LineIteratorTestCase.assertEquals((String)"Line Count doesn't match", (int)idx, (int)lines.size());
            try {
                iterator.next();
                LineIteratorTestCase.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException expected) {
                // empty catch block
            }
            try {
                iterator.nextLine();
                LineIteratorTestCase.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException expected) {
                // empty catch block
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    public void testFilteringFileReader() throws Exception {
        String encoding = "UTF-8";
        String fileName = "LineIterator-Filter-test.txt";
        File testFile = new File(LineIteratorTestCase.getTestDirectory(), fileName);
        List<String> lines = this.createLinesFile(testFile, encoding, 9);
        FileReader reader = new FileReader(testFile);
        this.testFiltering(lines, reader);
    }

    public void testFilteringBufferedReader() throws Exception {
        String encoding = "UTF-8";
        String fileName = "LineIterator-Filter-test.txt";
        File testFile = new File(LineIteratorTestCase.getTestDirectory(), fileName);
        List<String> lines = this.createLinesFile(testFile, encoding, 9);
        BufferedReader reader = new BufferedReader(new FileReader(testFile));
        this.testFiltering(lines, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFiltering(List<String> lines, Reader reader) {
        LineIterator iterator = new LineIterator(reader){

            protected boolean isValidLine(String line) {
                char c = line.charAt(line.length() - 1);
                return (c - 48) % 3 != 1;
            }
        };
        try {
            try {
                iterator.remove();
                LineIteratorTestCase.fail((String)"Remove is unsupported");
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            int idx = 0;
            int actualLines = 0;
            while (iterator.hasNext()) {
                String line = iterator.next();
                ++actualLines;
                LineIteratorTestCase.assertEquals((String)("Comparing line " + idx), (String)lines.get(idx), (String)line);
                LineIteratorTestCase.assertTrue((String)("Exceeded expected idx=" + idx + " size=" + lines.size()), (idx < lines.size() ? 1 : 0) != 0);
                if (++idx % 3 != 1) continue;
                ++idx;
            }
            LineIteratorTestCase.assertEquals((String)"Line Count doesn't match", (int)9, (int)lines.size());
            LineIteratorTestCase.assertEquals((String)"Line Count doesn't match", (int)9, (int)idx);
            LineIteratorTestCase.assertEquals((String)"Line Count doesn't match", (int)6, (int)actualLines);
            try {
                iterator.next();
                LineIteratorTestCase.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException expected) {
                // empty catch block
            }
            try {
                iterator.nextLine();
                LineIteratorTestCase.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException expected) {
                // empty catch block
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }
}

