/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.io.comparator.ComparatorAbstractTestCase;
import org.apache.commons.io.comparator.CompositeFileComparator;
import org.apache.commons.io.comparator.ExtensionFileComparator;
import org.apache.commons.io.comparator.ReverseComparator;
import org.apache.commons.io.comparator.SizeFileComparator;

public class CompositeFileComparatorTest
extends ComparatorAbstractTestCase {
    public CompositeFileComparatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.comparator = new CompositeFileComparator(new Comparator[]{SizeFileComparator.SIZE_COMPARATOR, ExtensionFileComparator.EXTENSION_COMPARATOR});
        this.reverse = new ReverseComparator((Comparator)this.comparator);
        File dir = CompositeFileComparatorTest.getTestDirectory();
        this.lessFile = new File(dir, "xyz.txt");
        this.equalFile1 = new File(dir, "foo.txt");
        this.equalFile2 = new File(dir, "bar.txt");
        this.moreFile = new File(dir, "foo.xyz");
        this.createFile(this.lessFile, 32L);
        this.createFile(this.equalFile1, 48L);
        this.createFile(this.equalFile2, 48L);
        this.createFile(this.moreFile, 48L);
    }

    public void testConstructorIterable() {
        ArrayList<Comparator> list = new ArrayList<Comparator>();
        list.add(SizeFileComparator.SIZE_COMPARATOR);
        list.add(ExtensionFileComparator.EXTENSION_COMPARATOR);
        CompositeFileComparator c = new CompositeFileComparator(list);
        CompositeFileComparatorTest.assertEquals((String)"equal", (int)0, (int)c.compare(this.equalFile1, this.equalFile2));
        CompositeFileComparatorTest.assertTrue((String)"less", (c.compare(this.lessFile, this.moreFile) < 0 ? 1 : 0) != 0);
        CompositeFileComparatorTest.assertTrue((String)"more", (c.compare(this.moreFile, this.lessFile) > 0 ? 1 : 0) != 0);
    }

    public void testConstructorIterableNull() {
        CompositeFileComparator c = new CompositeFileComparator((Iterable)null);
        CompositeFileComparatorTest.assertEquals((String)"less,more", (int)0, (int)c.compare(this.lessFile, this.moreFile));
        CompositeFileComparatorTest.assertEquals((String)"more,less", (int)0, (int)c.compare(this.moreFile, this.lessFile));
        CompositeFileComparatorTest.assertEquals((String)"toString", (String)"CompositeFileComparator{}", (String)c.toString());
    }

    public void testConstructorArrayNull() {
        CompositeFileComparator c = new CompositeFileComparator((Comparator[])null);
        CompositeFileComparatorTest.assertEquals((String)"less,more", (int)0, (int)c.compare(this.lessFile, this.moreFile));
        CompositeFileComparatorTest.assertEquals((String)"more,less", (int)0, (int)c.compare(this.moreFile, this.lessFile));
        CompositeFileComparatorTest.assertEquals((String)"toString", (String)"CompositeFileComparator{}", (String)c.toString());
    }
}

