/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.ComparatorAbstractTestCase;
import org.apache.commons.io.comparator.LastModifiedFileComparator;

public class LastModifiedFileComparatorTest
extends ComparatorAbstractTestCase {
    public LastModifiedFileComparatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.comparator = (AbstractFileComparator)LastModifiedFileComparator.LASTMODIFIED_COMPARATOR;
        this.reverse = LastModifiedFileComparator.LASTMODIFIED_REVERSE;
        File dir = LastModifiedFileComparatorTest.getTestDirectory();
        File olderFile = new File(dir, "older.txt");
        this.createFile(olderFile, 0L);
        File equalFile = new File(dir, "equal.txt");
        this.createFile(equalFile, 0L);
        do {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            equalFile.setLastModified(System.currentTimeMillis());
        } while (olderFile.lastModified() == equalFile.lastModified());
        File newerFile = new File(dir, "newer.txt");
        this.createFile(newerFile, 0L);
        do {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            newerFile.setLastModified(System.currentTimeMillis());
        } while (equalFile.lastModified() == newerFile.lastModified());
        this.equalFile1 = equalFile;
        this.equalFile2 = equalFile;
        this.lessFile = olderFile;
        this.moreFile = newerFile;
    }
}

