/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.ComparatorAbstractTestCase;
import org.apache.commons.io.comparator.SizeFileComparator;

public class SizeFileComparatorTest
extends ComparatorAbstractTestCase {
    private File smallerDir;
    private File largerDir;
    private File smallerFile;
    private File largerFile;

    public SizeFileComparatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.comparator = (AbstractFileComparator)SizeFileComparator.SIZE_COMPARATOR;
        this.reverse = SizeFileComparator.SIZE_REVERSE;
        File dir = SizeFileComparatorTest.getTestDirectory();
        this.smallerDir = new File(dir, "smallerdir");
        this.largerDir = new File(dir, "largerdir");
        this.smallerFile = new File(this.smallerDir, "smaller.txt");
        File equalFile = new File(dir, "equal.txt");
        this.largerFile = new File(this.largerDir, "larger.txt");
        this.smallerDir.mkdir();
        this.largerDir.mkdir();
        this.createFile(this.smallerFile, 32L);
        this.createFile(equalFile, 48L);
        this.createFile(this.largerFile, 64L);
        this.equalFile1 = equalFile;
        this.equalFile2 = equalFile;
        this.lessFile = this.smallerFile;
        this.moreFile = this.largerFile;
    }

    public void testNonexistantFile() {
        File nonexistantFile = new File(new File("."), "nonexistant.txt");
        SizeFileComparatorTest.assertFalse((boolean)nonexistantFile.exists());
        SizeFileComparatorTest.assertTrue((String)"less", (this.comparator.compare((Object)nonexistantFile, (Object)this.moreFile) < 0 ? 1 : 0) != 0);
    }

    public void testCompareDirectorySizes() {
        SizeFileComparatorTest.assertEquals((String)"sumDirectoryContents=false", (int)0, (int)this.comparator.compare((Object)this.smallerDir, (Object)this.largerDir));
        SizeFileComparatorTest.assertEquals((String)"less", (int)-1, (int)SizeFileComparator.SIZE_SUMDIR_COMPARATOR.compare(this.smallerDir, this.largerDir));
        SizeFileComparatorTest.assertEquals((String)"less", (int)1, (int)SizeFileComparator.SIZE_SUMDIR_REVERSE.compare(this.smallerDir, this.largerDir));
    }
}

