/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.filefilter.ConditionalFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.IOFileFilterAbstractTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConditionalFileFilterAbstractTestCase
extends IOFileFilterAbstractTestCase {
    private static final String TEST_FILE_NAME_PREFIX = "TestFile";
    private static final String TEST_FILE_TYPE = ".tst";
    protected IOFileFilterAbstractTestCase.TesterTrueFileFilter[] trueFilters;
    protected IOFileFilterAbstractTestCase.TesterFalseFileFilter[] falseFilters;
    private File file;
    private File workingPath;

    public ConditionalFileFilterAbstractTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.workingPath = this.determineWorkingDirectoryPath(this.getWorkingPathNamePropertyKey(), this.getDefaultWorkingPath());
        this.file = new File(this.workingPath, "TestFile1.tst");
        this.trueFilters = new IOFileFilterAbstractTestCase.TesterTrueFileFilter[4];
        this.falseFilters = new IOFileFilterAbstractTestCase.TesterFalseFileFilter[4];
        this.trueFilters[1] = new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this);
        this.trueFilters[2] = new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this);
        this.trueFilters[3] = new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this);
        this.falseFilters[1] = new IOFileFilterAbstractTestCase.TesterFalseFileFilter(this);
        this.falseFilters[2] = new IOFileFilterAbstractTestCase.TesterFalseFileFilter(this);
        this.falseFilters[3] = new IOFileFilterAbstractTestCase.TesterFalseFileFilter(this);
    }

    public void testAdd() {
        ArrayList<IOFileFilterAbstractTestCase.TesterTrueFileFilter> filters = new ArrayList<IOFileFilterAbstractTestCase.TesterTrueFileFilter>();
        ConditionalFileFilter fileFilter = this.getConditionalFileFilter();
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        for (int i = 0; i < filters.size(); ++i) {
            ConditionalFileFilterAbstractTestCase.assertEquals((String)"file filters count: ", (int)i, (int)fileFilter.getFileFilters().size());
            fileFilter.addFileFilter((IOFileFilter)filters.get(i));
            ConditionalFileFilterAbstractTestCase.assertEquals((String)"file filters count: ", (int)(i + 1), (int)fileFilter.getFileFilters().size());
        }
        for (IOFileFilter filter : fileFilter.getFileFilters()) {
            ConditionalFileFilterAbstractTestCase.assertTrue((String)"found file filter", (boolean)filters.contains(filter));
        }
        ConditionalFileFilterAbstractTestCase.assertEquals((String)"file filters count", (int)filters.size(), (int)fileFilter.getFileFilters().size());
    }

    public void testRemove() {
        ArrayList<IOFileFilterAbstractTestCase.TesterTrueFileFilter> filters = new ArrayList<IOFileFilterAbstractTestCase.TesterTrueFileFilter>();
        ConditionalFileFilter fileFilter = this.getConditionalFileFilter();
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        filters.add(new IOFileFilterAbstractTestCase.TesterTrueFileFilter(this));
        for (int i = 0; i < filters.size(); ++i) {
            fileFilter.removeFileFilter((IOFileFilter)filters.get(i));
            ConditionalFileFilterAbstractTestCase.assertTrue((String)"file filter removed", (!fileFilter.getFileFilters().contains(filters.get(i)) ? 1 : 0) != 0);
        }
        ConditionalFileFilterAbstractTestCase.assertEquals((String)"file filters count", (int)0, (int)fileFilter.getFileFilters().size());
    }

    public void testNoFilters() throws Exception {
        ConditionalFileFilter fileFilter = this.getConditionalFileFilter();
        File file = new File(this.workingPath, "TestFile1.tst");
        this.assertFileFiltering(1, (IOFileFilter)fileFilter, file, false);
        this.assertFilenameFiltering(1, (IOFileFilter)fileFilter, file, false);
    }

    public void testFilterBuiltUsingConstructor() throws Exception {
        List<List<IOFileFilter>> testFilters = this.getTestFilters();
        List<boolean[]> testTrueResults = this.getTrueResults();
        List<boolean[]> testFalseResults = this.getFalseResults();
        List<Boolean> testFileResults = this.getFileResults();
        List<Boolean> testFilenameResults = this.getFilenameResults();
        for (int i = 1; i < testFilters.size(); ++i) {
            List<IOFileFilter> filters = testFilters.get(i);
            boolean[] trueResults = testTrueResults.get(i);
            boolean[] falseResults = testFalseResults.get(i);
            boolean fileResults = testFileResults.get(i);
            boolean filenameResults = testFilenameResults.get(i);
            IOFileFilter filter = this.buildFilterUsingConstructor(filters);
            this.resetTrueFilters(this.trueFilters);
            this.resetFalseFilters(this.falseFilters);
            this.assertFileFiltering(i, filter, this.file, fileResults);
            this.assertTrueFiltersInvoked(i, this.trueFilters, trueResults);
            this.assertFalseFiltersInvoked(i, this.falseFilters, falseResults);
            this.resetTrueFilters(this.trueFilters);
            this.resetFalseFilters(this.falseFilters);
            this.assertFilenameFiltering(i, filter, this.file, filenameResults);
            this.assertTrueFiltersInvoked(i, this.trueFilters, trueResults);
            this.assertFalseFiltersInvoked(i, this.falseFilters, falseResults);
        }
    }

    public void testFilterBuiltUsingAdd() throws Exception {
        List<List<IOFileFilter>> testFilters = this.getTestFilters();
        List<boolean[]> testTrueResults = this.getTrueResults();
        List<boolean[]> testFalseResults = this.getFalseResults();
        List<Boolean> testFileResults = this.getFileResults();
        List<Boolean> testFilenameResults = this.getFilenameResults();
        for (int i = 1; i < testFilters.size(); ++i) {
            List<IOFileFilter> filters = testFilters.get(i);
            boolean[] trueResults = testTrueResults.get(i);
            boolean[] falseResults = testFalseResults.get(i);
            boolean fileResults = testFileResults.get(i);
            boolean filenameResults = testFilenameResults.get(i);
            IOFileFilter filter = this.buildFilterUsingAdd(filters);
            this.resetTrueFilters(this.trueFilters);
            this.resetFalseFilters(this.falseFilters);
            this.assertFileFiltering(i, filter, this.file, fileResults);
            this.assertTrueFiltersInvoked(i, this.trueFilters, trueResults);
            this.assertFalseFiltersInvoked(i, this.falseFilters, falseResults);
            this.resetTrueFilters(this.trueFilters);
            this.resetFalseFilters(this.falseFilters);
            this.assertFilenameFiltering(i, filter, this.file, filenameResults);
            this.assertTrueFiltersInvoked(i, this.trueFilters, trueResults);
            this.assertFalseFiltersInvoked(i, this.falseFilters, falseResults);
        }
    }

    protected abstract ConditionalFileFilter getConditionalFileFilter();

    protected abstract IOFileFilter buildFilterUsingAdd(List<IOFileFilter> var1);

    protected abstract IOFileFilter buildFilterUsingConstructor(List<IOFileFilter> var1);

    protected abstract List<List<IOFileFilter>> getTestFilters();

    protected abstract List<boolean[]> getTrueResults();

    protected abstract List<boolean[]> getFalseResults();

    protected abstract List<Boolean> getFileResults();

    protected abstract List<Boolean> getFilenameResults();

    protected abstract String getWorkingPathNamePropertyKey();

    protected abstract String getDefaultWorkingPath();
}

