/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.io.input.AutoCloseInputStream;

public class AutoCloseInputStreamTest
extends TestCase {
    private byte[] data;
    private InputStream stream;
    private boolean closed;

    protected void setUp() {
        this.data = new byte[]{120, 121, 122};
        this.stream = new AutoCloseInputStream((InputStream)new ByteArrayInputStream(this.data){

            public void close() {
                AutoCloseInputStreamTest.this.closed = true;
            }
        });
        this.closed = false;
    }

    public void testClose() throws IOException {
        this.stream.close();
        AutoCloseInputStreamTest.assertTrue((String)"closed", (boolean)this.closed);
        AutoCloseInputStreamTest.assertEquals((String)"read()", (int)-1, (int)this.stream.read());
    }

    public void testRead() throws IOException {
        for (byte element : this.data) {
            AutoCloseInputStreamTest.assertEquals((String)"read()", (int)element, (int)this.stream.read());
            AutoCloseInputStreamTest.assertFalse((String)"closed", (boolean)this.closed);
        }
        AutoCloseInputStreamTest.assertEquals((String)"read()", (int)-1, (int)this.stream.read());
        AutoCloseInputStreamTest.assertTrue((String)"closed", (boolean)this.closed);
    }

    public void testReadBuffer() throws IOException {
        byte[] b = new byte[this.data.length * 2];
        int total = 0;
        int n = 0;
        while (n != -1) {
            AutoCloseInputStreamTest.assertFalse((String)"closed", (boolean)this.closed);
            for (int i = 0; i < n; ++i) {
                AutoCloseInputStreamTest.assertEquals((String)"read(b)", (byte)this.data[total + i], (byte)b[i]);
            }
            total += n;
            n = this.stream.read(b);
        }
        AutoCloseInputStreamTest.assertEquals((String)"read(b)", (int)this.data.length, (int)total);
        AutoCloseInputStreamTest.assertTrue((String)"closed", (boolean)this.closed);
        AutoCloseInputStreamTest.assertEquals((String)"read(b)", (int)-1, (int)this.stream.read(b));
    }

    public void testReadBufferOffsetLength() throws IOException {
        byte[] b = new byte[this.data.length * 2];
        int total = 0;
        int n = 0;
        while (n != -1) {
            AutoCloseInputStreamTest.assertFalse((String)"closed", (boolean)this.closed);
            n = this.stream.read(b, total += n, b.length - total);
        }
        AutoCloseInputStreamTest.assertEquals((String)"read(b, off, len)", (int)this.data.length, (int)total);
        for (int i = 0; i < this.data.length; ++i) {
            AutoCloseInputStreamTest.assertEquals((String)"read(b, off, len)", (byte)this.data[i], (byte)b[i]);
        }
        AutoCloseInputStreamTest.assertTrue((String)"closed", (boolean)this.closed);
        AutoCloseInputStreamTest.assertEquals((String)"read(b, off, len)", (int)-1, (int)this.stream.read(b, 0, b.length));
    }
}

