/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;

public class BoundedInputStreamTest
extends TestCase {
    public BoundedInputStreamTest(String name) {
        super(name);
    }

    public void testReadSingle() throws Exception {
        int i;
        BoundedInputStream bounded = null;
        byte[] helloWorld = "Hello World".getBytes();
        byte[] hello = "Hello".getBytes();
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)helloWorld.length);
        for (i = 0; i < helloWorld.length; ++i) {
            BoundedInputStreamTest.assertEquals((String)("limit = length byte[" + i + "]"), (int)helloWorld[i], (int)bounded.read());
        }
        BoundedInputStreamTest.assertEquals((String)"limit = length end", (int)-1, (int)bounded.read());
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)(helloWorld.length + 1));
        for (i = 0; i < helloWorld.length; ++i) {
            BoundedInputStreamTest.assertEquals((String)("limit > length byte[" + i + "]"), (int)helloWorld[i], (int)bounded.read());
        }
        BoundedInputStreamTest.assertEquals((String)"limit > length end", (int)-1, (int)bounded.read());
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)hello.length);
        for (i = 0; i < hello.length; ++i) {
            BoundedInputStreamTest.assertEquals((String)("limit < length byte[" + i + "]"), (int)hello[i], (int)bounded.read());
        }
        BoundedInputStreamTest.assertEquals((String)"limit < length end", (int)-1, (int)bounded.read());
    }

    public void testReadArray() throws Exception {
        BoundedInputStream bounded = null;
        byte[] helloWorld = "Hello World".getBytes();
        byte[] hello = "Hello".getBytes();
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld));
        this.compare("limit = -1", helloWorld, IOUtils.toByteArray((InputStream)bounded));
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), 0L);
        this.compare("limit = 0", new byte[0], IOUtils.toByteArray((InputStream)bounded));
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)helloWorld.length);
        this.compare("limit = length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)(helloWorld.length + 1));
        this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)(helloWorld.length - 6));
        this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
    }

    private void compare(String msg, byte[] expected, byte[] actual) {
        BoundedInputStreamTest.assertEquals((String)(msg + " length"), (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            BoundedInputStreamTest.assertEquals((String)(msg + " byte[" + i + "]"), (byte)expected[i], (byte)actual[i]);
        }
    }
}

