/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Random;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.junit.Assert;
import org.junit.Test;

public class CharSequenceInputStreamTest {
    private static final String TEST_STRING = "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre";
    private static final String LARGE_TEST_STRING;
    private Random random = new Random();

    private void testWithSingleByteRead(String testString, String charsetName) throws IOException {
        byte[] bytes = testString.getBytes(charsetName);
        CharSequenceInputStream in = new CharSequenceInputStream((CharSequence)testString, charsetName, 512);
        for (byte b : bytes) {
            int read = in.read();
            Assert.assertTrue((String)("read " + read + " >=0 "), (read >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("read " + read + " <= 255"), (read <= 255 ? 1 : 0) != 0);
            Assert.assertEquals((String)"Should agree with input", (long)b, (long)((byte)read));
        }
        Assert.assertEquals((long)-1L, (long)in.read());
    }

    private void testWithBufferedRead(String testString, String charsetName) throws IOException {
        byte[] expected = testString.getBytes(charsetName);
        CharSequenceInputStream in = new CharSequenceInputStream((CharSequence)testString, charsetName, 512);
        byte[] buffer = new byte[128];
        int offset = 0;
        block0: while (true) {
            int bufferLength;
            int bufferOffset;
            int read;
            if ((read = in.read(buffer, bufferOffset = this.random.nextInt(64), bufferLength = this.random.nextInt(64))) == -1) {
                Assert.assertEquals((String)"EOF: offset should equal length", (long)expected.length, (long)offset);
                break;
            }
            Assert.assertTrue((String)("Read " + read + " <= " + bufferLength), (read <= bufferLength ? 1 : 0) != 0);
            while (true) {
                if (read <= 0) continue block0;
                Assert.assertTrue((String)("offset " + offset + " < " + expected.length), (offset < expected.length ? 1 : 0) != 0);
                Assert.assertEquals((String)"bytes should agree", (long)expected[offset], (long)buffer[bufferOffset]);
                ++offset;
                ++bufferOffset;
                --read;
            }
            break;
        }
    }

    @Test
    public void testUTF8WithSingleByteRead() throws IOException {
        this.testWithSingleByteRead(TEST_STRING, "UTF-8");
    }

    @Test
    public void testLargeUTF8WithSingleByteRead() throws IOException {
        this.testWithSingleByteRead(LARGE_TEST_STRING, "UTF-8");
    }

    @Test
    public void testUTF8WithBufferedRead() throws IOException {
        this.testWithBufferedRead(TEST_STRING, "UTF-8");
    }

    @Test
    public void testLargeUTF8WithBufferedRead() throws IOException {
        this.testWithBufferedRead(LARGE_TEST_STRING, "UTF-8");
    }

    @Test
    public void testUTF16WithSingleByteRead() throws IOException {
        this.testWithSingleByteRead(TEST_STRING, "UTF-16");
    }

    @Test
    public void testReadZero() throws Exception {
        CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", "UTF-8");
        byte[] bytes = new byte[30];
        Assert.assertEquals((long)0L, (long)r.read(bytes, 0, 0));
    }

    @Test
    public void testReadZeroEmptyString() throws Exception {
        CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"", "UTF-8");
        byte[] bytes = new byte[30];
        Assert.assertEquals((long)0L, (long)r.read(bytes, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCharsetMismatchInfiniteLoop() throws IOException {
        char[] inputChars = new char[]{'\u00e0', '\u00b2', '\u00a0'};
        Charset charset = Charset.forName("ASCII");
        CharSequenceInputStream stream = new CharSequenceInputStream((CharSequence)new String(inputChars), charset, 512);
        try {
            while (stream.read() != -1) {
            }
        }
        finally {
            stream.close();
        }
    }

    @Test
    public void testSkip() throws Exception {
        CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", "UTF-8");
        r.skip(1L);
        r.skip(2L);
        Assert.assertEquals((long)116L, (long)r.read());
        r.skip(100L);
        Assert.assertEquals((long)-1L, (long)r.read());
    }

    @Test
    public void testMarkReset() throws Exception {
        CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", "UTF-8");
        r.skip(2L);
        r.mark(0);
        Assert.assertEquals((long)115L, (long)r.read());
        Assert.assertEquals((long)116L, (long)r.read());
        Assert.assertEquals((long)-1L, (long)r.read());
        r.reset();
        Assert.assertEquals((long)115L, (long)r.read());
        Assert.assertEquals((long)116L, (long)r.read());
        Assert.assertEquals((long)-1L, (long)r.read());
        r.reset();
        r.reset();
    }

    @Test
    public void testMarkSupported() throws Exception {
        CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", "UTF-8");
        Assert.assertTrue((boolean)r.markSupported());
    }

    static {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            buffer.append(TEST_STRING);
        }
        LARGE_TEST_STRING = buffer.toString();
    }
}

