/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.io.input.CloseShieldInputStream;

public class CloseShieldInputStreamTest
extends TestCase {
    private byte[] data;
    private InputStream original;
    private InputStream shielded;
    private boolean closed;

    protected void setUp() {
        this.data = new byte[]{120, 121, 122};
        this.original = new ByteArrayInputStream(this.data){

            public void close() {
                CloseShieldInputStreamTest.this.closed = true;
            }
        };
        this.shielded = new CloseShieldInputStream(this.original);
        this.closed = false;
    }

    public void testClose() throws IOException {
        this.shielded.close();
        CloseShieldInputStreamTest.assertFalse((String)"closed", (boolean)this.closed);
        CloseShieldInputStreamTest.assertEquals((String)"read()", (int)-1, (int)this.shielded.read());
        CloseShieldInputStreamTest.assertEquals((String)"read()", (int)this.data[0], (int)this.original.read());
    }
}

