/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.output.NullOutputStream;

public class CountingInputStreamTest
extends TestCase {
    public CountingInputStreamTest(String name) {
        super(name);
    }

    public void testCounting() throws Exception {
        String text = "A piece of text";
        byte[] bytes = text.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        byte[] result = new byte[21];
        byte[] ba = new byte[5];
        int found = cis.read(ba);
        System.arraycopy(ba, 0, result, 0, 5);
        CountingInputStreamTest.assertEquals((int)found, (int)cis.getCount());
        int value = cis.read();
        result[5] = (byte)value;
        CountingInputStreamTest.assertEquals((int)(++found), (int)cis.getCount());
        CountingInputStreamTest.assertEquals((int)(found += cis.read(result, 6, 5)), (int)cis.getCount());
        CountingInputStreamTest.assertEquals((int)(found += cis.read(result, 11, 10)), (int)cis.getCount());
        String textResult = new String(result).trim();
        CountingInputStreamTest.assertEquals((String)textResult, (String)text);
    }

    public void testLargeFiles_IO84() throws Exception {
        long size = 0x80000000L;
        NullInputStream mock = new NullInputStream(size);
        CountingInputStream cis = new CountingInputStream((InputStream)mock);
        NullOutputStream out = new NullOutputStream();
        IOUtils.copyLarge((InputStream)cis, (OutputStream)out);
        try {
            cis.getCount();
            CountingInputStreamTest.fail((String)"Expected getCount() to throw an ArithmeticException");
        }
        catch (ArithmeticException ae) {
            // empty catch block
        }
        try {
            cis.resetCount();
            CountingInputStreamTest.fail((String)"Expected resetCount() to throw an ArithmeticException");
        }
        catch (ArithmeticException ae) {
            // empty catch block
        }
        mock.close();
        IOUtils.copyLarge((InputStream)cis, (OutputStream)out);
        CountingInputStreamTest.assertEquals((String)"getByteCount()", (long)size, (long)cis.getByteCount());
        CountingInputStreamTest.assertEquals((String)"resetByteCount()", (long)size, (long)cis.resetByteCount());
    }

    public void testResetting() throws Exception {
        String text = "A piece of text";
        byte[] bytes = text.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        byte[] result = new byte[bytes.length];
        int found = cis.read(result, 0, 5);
        CountingInputStreamTest.assertEquals((int)found, (int)cis.getCount());
        int count = cis.resetCount();
        found = cis.read(result, 6, 5);
        CountingInputStreamTest.assertEquals((int)found, (int)count);
    }

    public void testZeroLength1() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        int found = cis.read();
        CountingInputStreamTest.assertEquals((int)-1, (int)found);
        CountingInputStreamTest.assertEquals((int)0, (int)cis.getCount());
    }

    public void testZeroLength2() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        byte[] result = new byte[10];
        int found = cis.read(result);
        CountingInputStreamTest.assertEquals((int)-1, (int)found);
        CountingInputStreamTest.assertEquals((int)0, (int)cis.getCount());
    }

    public void testZeroLength3() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        byte[] result = new byte[10];
        int found = cis.read(result, 0, 5);
        CountingInputStreamTest.assertEquals((int)-1, (int)found);
        CountingInputStreamTest.assertEquals((int)0, (int)cis.getCount());
    }

    public void testEOF1() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        int found = cis.read();
        CountingInputStreamTest.assertEquals((int)0, (int)found);
        CountingInputStreamTest.assertEquals((int)1, (int)cis.getCount());
        found = cis.read();
        CountingInputStreamTest.assertEquals((int)0, (int)found);
        CountingInputStreamTest.assertEquals((int)2, (int)cis.getCount());
        found = cis.read();
        CountingInputStreamTest.assertEquals((int)-1, (int)found);
        CountingInputStreamTest.assertEquals((int)2, (int)cis.getCount());
    }

    public void testEOF2() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        byte[] result = new byte[10];
        int found = cis.read(result);
        CountingInputStreamTest.assertEquals((int)2, (int)found);
        CountingInputStreamTest.assertEquals((int)2, (int)cis.getCount());
    }

    public void testEOF3() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        byte[] result = new byte[10];
        int found = cis.read(result, 0, 5);
        CountingInputStreamTest.assertEquals((int)2, (int)found);
        CountingInputStreamTest.assertEquals((int)2, (int)cis.getCount());
    }

    public void testSkipping() throws IOException {
        String text = "Hello World!";
        byte[] bytes = text.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        CountingInputStream cis = new CountingInputStream((InputStream)bais);
        CountingInputStreamTest.assertEquals((long)6L, (long)cis.skip(6L));
        CountingInputStreamTest.assertEquals((int)6, (int)cis.getCount());
        byte[] result = new byte[6];
        cis.read(result);
        CountingInputStreamTest.assertEquals((String)"World!", (String)new String(result));
        CountingInputStreamTest.assertEquals((int)12, (int)cis.getCount());
    }
}

