/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.commons.io.input.XmlStreamReaderException;

public class XmlStreamReaderUtilitiesTest
extends TestCase {
    private static String RAWMGS1 = "encoding mismatch";
    private static String RAWMGS2 = "unknown BOM";
    private static String HTTPMGS1 = "BOM must be NULL";
    private static String HTTPMGS2 = "encoding mismatch";
    private static String HTTPMGS3 = "Invalid MIME";
    private static String APPXML = "application/xml";
    private static String APPXML_UTF8 = "application/xml;charset=UTF-8";
    private static String APPXML_UTF16 = "application/xml;charset=UTF-16";
    private static String APPXML_UTF16BE = "application/xml;charset=UTF-16BE";
    private static String APPXML_UTF16LE = "application/xml;charset=UTF-16LE";
    private static String TXTXML = "text/xml";

    protected void setUp() {
    }

    public void testContentTypeEncoding() {
        this.checkContentTypeEncoding(null, null);
        this.checkContentTypeEncoding(null, "");
        this.checkContentTypeEncoding(null, "application/xml");
        this.checkContentTypeEncoding(null, "application/xml;");
        this.checkContentTypeEncoding(null, "multipart/mixed;boundary=frontier");
        this.checkContentTypeEncoding(null, "multipart/mixed;boundary='frontier'");
        this.checkContentTypeEncoding(null, "multipart/mixed;boundary=\"frontier\"");
        this.checkContentTypeEncoding("UTF-16", "application/xml;charset=utf-16");
        this.checkContentTypeEncoding("UTF-16", "application/xml;charset=UTF-16");
        this.checkContentTypeEncoding("UTF-16", "application/xml;charset='UTF-16'");
        this.checkContentTypeEncoding("UTF-16", "application/xml;charset=\"UTF-16\"");
    }

    private void checkContentTypeEncoding(String expected, String httpContentType) {
        XmlStreamReaderUtilitiesTest.assertEquals((String)("ContentTypeEncoding=[" + httpContentType + "]"), (String)expected, (String)XmlStreamReader.getContentTypeEncoding((String)httpContentType));
    }

    public void testContentTypeMime() {
        this.checkContentTypeMime(null, null);
        this.checkContentTypeMime("", "");
        this.checkContentTypeMime("application/xml", "application/xml");
        this.checkContentTypeMime("application/xml", "application/xml;");
        this.checkContentTypeMime("application/xml", "application/xml;charset=utf-16");
    }

    private void checkContentTypeMime(String expected, String httpContentType) {
        XmlStreamReaderUtilitiesTest.assertEquals((String)("ContentTypeMime=[" + httpContentType + "]"), (String)expected, (String)XmlStreamReader.getContentTypeMime((String)httpContentType));
    }

    public void testAppXml() {
        this.checkAppXml(false, null);
        this.checkAppXml(false, "");
        this.checkAppXml(true, "application/xml");
        this.checkAppXml(true, "application/xml-dtd");
        this.checkAppXml(true, "application/xml-external-parsed-entity");
        this.checkAppXml(true, "application/soap+xml");
        this.checkAppXml(true, "application/atom+xml");
        this.checkAppXml(false, "application/atomxml");
        this.checkAppXml(false, "text/xml");
        this.checkAppXml(false, "text/atom+xml");
        this.checkAppXml(true, "application/xml-dtd");
        this.checkAppXml(true, "application/xml-external-parsed-entity");
    }

    private void checkAppXml(boolean expected, String mime) {
        XmlStreamReaderUtilitiesTest.assertEquals((String)("Mime=[" + mime + "]"), (boolean)expected, (boolean)XmlStreamReader.isAppXml((String)mime));
    }

    public void testTextXml() {
        this.checkTextXml(false, null);
        this.checkTextXml(false, "");
        this.checkTextXml(true, "text/xml");
        this.checkTextXml(true, "text/xml-external-parsed-entity");
        this.checkTextXml(true, "text/soap+xml");
        this.checkTextXml(true, "text/atom+xml");
        this.checkTextXml(false, "text/atomxml");
        this.checkTextXml(false, "application/xml");
        this.checkTextXml(false, "application/atom+xml");
    }

    private void checkTextXml(boolean expected, String mime) {
        XmlStreamReaderUtilitiesTest.assertEquals((String)("Mime=[" + mime + "]"), (boolean)expected, (boolean)XmlStreamReader.isTextXml((String)mime));
    }

    public void testCalculateRawEncodingNoBOM() throws IOException {
        this.checkRawError(RAWMGS2, "UTF-32", null, null, null);
        this.checkRawEncoding("UTF-8", null, null, null, null);
        this.checkRawEncoding("UTF-8", null, "UTF-16BE", null, null);
        this.checkRawEncoding("UTF-8", null, null, "UTF-16BE", null);
        this.checkRawEncoding("UTF-16BE", null, "UTF-16BE", "UTF-16BE", null);
        this.checkRawEncoding("UTF-16BE", null, null, null, "UTF-16BE");
        this.checkRawEncoding("UTF-16BE", null, "UTF-8", null, "UTF-16BE");
        this.checkRawEncoding("UTF-16BE", null, null, "UTF-8", "UTF-16BE");
        this.checkRawEncoding("UTF-8", null, "UTF-8", "UTF-8", "UTF-16BE");
        this.checkRawEncoding("UTF-16BE", null, "UTF-16BE", "UTF-16", null);
        this.checkRawEncoding("UTF-16LE", null, "UTF-16LE", "UTF-16", null);
    }

    public void testCalculateRawEncodingStandard() throws IOException {
        this.testCalculateRawEncodingStandard("UTF-8", "UTF-16BE", "UTF-16LE");
        this.testCalculateRawEncodingStandard("UTF-16BE", "UTF-8", "UTF-16LE");
        this.testCalculateRawEncodingStandard("UTF-16LE", "UTF-8", "UTF-16BE");
    }

    private void testCalculateRawEncodingStandard(String bomEnc, String otherEnc, String defaultEnc) throws IOException {
        this.checkRawEncoding(bomEnc, bomEnc, null, null, defaultEnc);
        this.checkRawEncoding(bomEnc, bomEnc, bomEnc, null, defaultEnc);
        this.checkRawError(RAWMGS1, bomEnc, otherEnc, null, defaultEnc);
        this.checkRawEncoding(bomEnc, bomEnc, null, bomEnc, defaultEnc);
        this.checkRawError(RAWMGS1, bomEnc, null, otherEnc, defaultEnc);
        this.checkRawEncoding(bomEnc, bomEnc, bomEnc, bomEnc, defaultEnc);
        this.checkRawError(RAWMGS1, bomEnc, bomEnc, otherEnc, defaultEnc);
        this.checkRawError(RAWMGS1, bomEnc, otherEnc, bomEnc, defaultEnc);
    }

    public void testCalculateRawEncodingAdditonalkUTF16() throws IOException {
        this.checkRawError(RAWMGS1, "UTF-16BE", "UTF-16", null, null);
        this.checkRawEncoding("UTF-16BE", "UTF-16BE", null, "UTF-16", null);
        this.checkRawEncoding("UTF-16BE", "UTF-16BE", "UTF-16BE", "UTF-16", null);
        this.checkRawError(RAWMGS1, "UTF-16BE", null, "UTF-16LE", null);
        this.checkRawError(RAWMGS1, "UTF-16BE", "UTF-16BE", "UTF-16LE", null);
        this.checkRawError(RAWMGS1, "UTF-16LE", "UTF-16", null, null);
        this.checkRawEncoding("UTF-16LE", "UTF-16LE", null, "UTF-16", null);
        this.checkRawEncoding("UTF-16LE", "UTF-16LE", "UTF-16LE", "UTF-16", null);
        this.checkRawError(RAWMGS1, "UTF-16LE", null, "UTF-16BE", null);
        this.checkRawError(RAWMGS1, "UTF-16LE", "UTF-16LE", "UTF-16BE", null);
    }

    private void checkRawEncoding(String expected, String bomEnc, String xmlGuessEnc, String xmlEnc, String defaultEncoding) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("RawEncoding: ").append(bomEnc).append("], ");
        builder.append("bomEnc=[").append(bomEnc).append("], ");
        builder.append("xmlGuessEnc=[").append(xmlGuessEnc).append("], ");
        builder.append("xmlEnc=[").append(xmlEnc).append("], ");
        builder.append("defaultEncoding=[").append(defaultEncoding).append("],");
        String encoding = this.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc, defaultEncoding);
        XmlStreamReaderUtilitiesTest.assertEquals((String)builder.toString(), (String)expected, (String)encoding);
    }

    protected String calculateRawEncoding(String bomEnc, String xmlGuessEnc, String xmlEnc, String defaultEncoding) throws IOException {
        MockXmlStreamReader mock = new MockXmlStreamReader(defaultEncoding);
        String encoding = mock.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc);
        return encoding;
    }

    private void checkRawError(String msgSuffix, String bomEnc, String xmlGuessEnc, String xmlEnc, String defaultEncoding) {
        try {
            this.checkRawEncoding("XmlStreamReaderException", bomEnc, xmlGuessEnc, xmlEnc, defaultEncoding);
            XmlStreamReaderUtilitiesTest.fail((String)"Expected XmlStreamReaderException");
        }
        catch (XmlStreamReaderException e) {
            XmlStreamReaderUtilitiesTest.assertTrue((String)("Msg Start: " + e.getMessage()), (boolean)e.getMessage().startsWith("Invalid encoding"));
            XmlStreamReaderUtilitiesTest.assertTrue((String)("Msg End: " + e.getMessage()), (boolean)e.getMessage().endsWith(msgSuffix));
            XmlStreamReaderUtilitiesTest.assertEquals((String)"bomEnc", (String)bomEnc, (String)e.getBomEncoding());
            XmlStreamReaderUtilitiesTest.assertEquals((String)"xmlGuessEnc", (String)xmlGuessEnc, (String)e.getXmlGuessEncoding());
            XmlStreamReaderUtilitiesTest.assertEquals((String)"xmlEnc", (String)xmlEnc, (String)e.getXmlEncoding());
            XmlStreamReaderUtilitiesTest.assertNull((String)"ContentTypeEncoding", (Object)e.getContentTypeEncoding());
            XmlStreamReaderUtilitiesTest.assertNull((String)"ContentTypeMime", (Object)e.getContentTypeMime());
        }
        catch (Exception e) {
            XmlStreamReaderUtilitiesTest.fail((String)("Expected XmlStreamReaderException, but threw " + e));
        }
    }

    public void testCalculateHttpEncoding() throws IOException {
        this.checkHttpError(HTTPMGS3, true, null, null, null, null, null);
        this.checkHttpError(HTTPMGS3, false, null, null, null, "UTF-8", null);
        this.checkHttpEncoding("UTF-8", true, null, null, null, "UTF-8", null);
        this.checkHttpEncoding("UTF-16LE", true, null, null, null, "UTF-16LE", null);
        this.checkHttpError(HTTPMGS3, false, "text/css", null, null, null, null);
        this.checkHttpEncoding("US-ASCII", false, TXTXML, null, null, null, null);
        this.checkHttpEncoding("UTF-16BE", false, TXTXML, null, null, null, "UTF-16BE");
        this.checkHttpEncoding("UTF-8", false, APPXML, null, null, null, null);
        this.checkHttpEncoding("UTF-16BE", false, APPXML, null, null, null, "UTF-16BE");
        this.checkHttpEncoding("UTF-8", false, APPXML, "UTF-8", null, null, "UTF-16BE");
        this.checkHttpEncoding("UTF-16LE", false, APPXML_UTF16LE, null, null, null, null);
        this.checkHttpEncoding("UTF-16BE", false, APPXML_UTF16BE, null, null, null, null);
        this.checkHttpError(HTTPMGS1, false, APPXML_UTF16LE, "UTF-16LE", null, null, null);
        this.checkHttpError(HTTPMGS1, false, APPXML_UTF16BE, "UTF-16BE", null, null, null);
        this.checkHttpError(HTTPMGS2, false, APPXML_UTF16, null, null, null, null);
        this.checkHttpError(HTTPMGS2, false, APPXML_UTF16, "UTF-8", null, null, null);
        this.checkHttpEncoding("UTF-16LE", false, APPXML_UTF16, "UTF-16LE", null, null, null);
        this.checkHttpEncoding("UTF-16BE", false, APPXML_UTF16, "UTF-16BE", null, null, null);
        this.checkHttpEncoding("UTF-8", false, APPXML_UTF8, null, null, null, null);
        this.checkHttpEncoding("UTF-8", false, APPXML_UTF8, "UTF-16BE", "UTF-16BE", "UTF-16BE", "UTF-16BE");
    }

    private void checkHttpEncoding(String expected, boolean lenient, String httpContentType, String bomEnc, String xmlGuessEnc, String xmlEnc, String defaultEncoding) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("HttpEncoding: ").append(bomEnc).append("], ");
        builder.append("lenient=[").append(lenient).append("], ");
        builder.append("httpContentType=[").append(httpContentType).append("], ");
        builder.append("bomEnc=[").append(bomEnc).append("], ");
        builder.append("xmlGuessEnc=[").append(xmlGuessEnc).append("], ");
        builder.append("xmlEnc=[").append(xmlEnc).append("], ");
        builder.append("defaultEncoding=[").append(defaultEncoding).append("],");
        String encoding = this.calculateHttpEncoding(httpContentType, bomEnc, xmlGuessEnc, xmlEnc, lenient, defaultEncoding);
        XmlStreamReaderUtilitiesTest.assertEquals((String)builder.toString(), (String)expected, (String)encoding);
    }

    protected String calculateHttpEncoding(String httpContentType, String bomEnc, String xmlGuessEnc, String xmlEnc, boolean lenient, String defaultEncoding) throws IOException {
        MockXmlStreamReader mock = new MockXmlStreamReader(defaultEncoding);
        String encoding = mock.calculateHttpEncoding(httpContentType, bomEnc, xmlGuessEnc, xmlEnc, lenient);
        return encoding;
    }

    private void checkHttpError(String msgSuffix, boolean lenienet, String httpContentType, String bomEnc, String xmlGuessEnc, String xmlEnc, String defaultEncoding) {
        try {
            this.checkHttpEncoding("XmlStreamReaderException", lenienet, httpContentType, bomEnc, xmlGuessEnc, xmlEnc, defaultEncoding);
            XmlStreamReaderUtilitiesTest.fail((String)"Expected XmlStreamReaderException");
        }
        catch (XmlStreamReaderException e) {
            XmlStreamReaderUtilitiesTest.assertTrue((String)("Msg Start: " + e.getMessage()), (boolean)e.getMessage().startsWith("Invalid encoding"));
            XmlStreamReaderUtilitiesTest.assertTrue((String)("Msg End: " + e.getMessage()), (boolean)e.getMessage().endsWith(msgSuffix));
            XmlStreamReaderUtilitiesTest.assertEquals((String)"bomEnc", (String)bomEnc, (String)e.getBomEncoding());
            XmlStreamReaderUtilitiesTest.assertEquals((String)"xmlGuessEnc", (String)xmlGuessEnc, (String)e.getXmlGuessEncoding());
            XmlStreamReaderUtilitiesTest.assertEquals((String)"xmlEnc", (String)xmlEnc, (String)e.getXmlEncoding());
            XmlStreamReaderUtilitiesTest.assertEquals((String)"ContentTypeEncoding", (String)XmlStreamReader.getContentTypeEncoding((String)httpContentType), (String)e.getContentTypeEncoding());
            XmlStreamReaderUtilitiesTest.assertEquals((String)"ContentTypeMime", (String)XmlStreamReader.getContentTypeMime((String)httpContentType), (String)e.getContentTypeMime());
        }
        catch (Exception e) {
            XmlStreamReaderUtilitiesTest.fail((String)("Expected XmlStreamReaderException, but threw " + e));
        }
    }

    private static class MockXmlStreamReader
    extends XmlStreamReader {
        MockXmlStreamReader(String defaultEncoding) throws IOException {
            super((InputStream)new ByteArrayInputStream("".getBytes()), null, true, defaultEncoding);
        }
    }
}

