/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Executors;
import org.apache.commons.io.monitor.AbstractMonitorTestCase;
import org.apache.commons.io.monitor.CollectionFileListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAlterationMonitorTestCase
extends AbstractMonitorTestCase {
    public FileAlterationMonitorTestCase(String name) {
        super(name);
        this.testDirName = "test-monitor";
    }

    @Override
    protected void setUp() throws Exception {
        this.listener = new CollectionFileListener(false);
        super.setUp();
    }

    public void testDefaultConstructor() {
        FileAlterationMonitor monitor = new FileAlterationMonitor();
        FileAlterationMonitorTestCase.assertEquals((String)"Interval", (long)10000L, (long)monitor.getInterval());
    }

    public void testAddRemoveObservers() {
        FileAlterationObserver[] observers = null;
        FileAlterationMonitor monitor = null;
        monitor = new FileAlterationMonitor(123L, observers);
        FileAlterationMonitorTestCase.assertEquals((String)"Interval", (long)123L, (long)monitor.getInterval());
        FileAlterationMonitorTestCase.assertFalse((String)"Observers[1]", (boolean)monitor.getObservers().iterator().hasNext());
        observers = new FileAlterationObserver[1];
        monitor = new FileAlterationMonitor(456L, observers);
        FileAlterationMonitorTestCase.assertFalse((String)"Observers[2]", (boolean)monitor.getObservers().iterator().hasNext());
        monitor.addObserver(null);
        FileAlterationMonitorTestCase.assertFalse((String)"Observers[3]", (boolean)monitor.getObservers().iterator().hasNext());
        monitor.removeObserver(null);
        FileAlterationObserver observer = new FileAlterationObserver("foo");
        monitor.addObserver(observer);
        Iterator it = monitor.getObservers().iterator();
        FileAlterationMonitorTestCase.assertTrue((String)"Observers[4]", (boolean)it.hasNext());
        FileAlterationMonitorTestCase.assertEquals((String)"Added", (Object)observer, it.next());
        FileAlterationMonitorTestCase.assertFalse((String)"Observers[5]", (boolean)it.hasNext());
        monitor.removeObserver(observer);
        FileAlterationMonitorTestCase.assertFalse((String)"Observers[6]", (boolean)monitor.getObservers().iterator().hasNext());
    }

    public void testMonitor() {
        try {
            long interval = 100L;
            this.listener.clear();
            FileAlterationMonitor monitor = new FileAlterationMonitor(interval, new FileAlterationObserver[]{this.observer});
            FileAlterationMonitorTestCase.assertEquals((String)"Interval", (long)interval, (long)monitor.getInterval());
            monitor.start();
            try {
                monitor.start();
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            this.checkCollectionsEmpty("A");
            File file1 = this.touch(new File(this.testDir, "file1.java"));
            this.checkFile("Create", file1, this.listener.getCreatedFiles());
            this.listener.clear();
            this.checkCollectionsEmpty("B");
            file1 = this.touch(file1);
            this.checkFile("Update", file1, this.listener.getChangedFiles());
            this.listener.clear();
            this.checkCollectionsEmpty("C");
            file1.delete();
            this.checkFile("Delete", file1, this.listener.getDeletedFiles());
            this.listener.clear();
            monitor.stop();
            try {
                monitor.stop();
            }
            catch (IllegalStateException e) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            FileAlterationMonitorTestCase.fail((String)("Threw " + e));
        }
    }

    public void testThreadFactory() {
        try {
            long interval = 100L;
            this.listener.clear();
            FileAlterationMonitor monitor = new FileAlterationMonitor(interval, new FileAlterationObserver[]{this.observer});
            monitor.setThreadFactory(Executors.defaultThreadFactory());
            FileAlterationMonitorTestCase.assertEquals((String)"Interval", (long)interval, (long)monitor.getInterval());
            monitor.start();
            this.checkCollectionsEmpty("A");
            File file2 = this.touch(new File(this.testDir, "file2.java"));
            this.checkFile("Create", file2, this.listener.getCreatedFiles());
            this.listener.clear();
            this.checkCollectionsEmpty("B");
            file2.delete();
            this.checkFile("Delete", file2, this.listener.getDeletedFiles());
            this.listener.clear();
            monitor.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            FileAlterationMonitorTestCase.fail((String)("Threw " + e));
        }
    }

    private void checkFile(String label, File file, Collection<File> files) {
        for (int i = 0; i < 20; ++i) {
            if (files.contains(file)) {
                return;
            }
            this.sleepHandleInterruped(this.pauseTime);
        }
        FileAlterationMonitorTestCase.fail((String)(label + " " + file + " not found"));
    }
}

