/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.Assert;

public class TeeOutputStreamTest
extends TestCase {
    public TeeOutputStreamTest(String name) {
        super(name);
    }

    public void testCloseBranchIOException() {
        ExceptionOnCloseByteArrayOutputStream badOs = new ExceptionOnCloseByteArrayOutputStream();
        RecordCloseByteArrayOutputStream goodOs = new RecordCloseByteArrayOutputStream();
        TeeOutputStream tos = new TeeOutputStream((OutputStream)goodOs, (OutputStream)badOs);
        try {
            tos.close();
            Assert.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)goodOs.closed);
        }
    }

    public void testCloseMainIOException() {
        ExceptionOnCloseByteArrayOutputStream badOs = new ExceptionOnCloseByteArrayOutputStream();
        RecordCloseByteArrayOutputStream goodOs = new RecordCloseByteArrayOutputStream();
        TeeOutputStream tos = new TeeOutputStream((OutputStream)badOs, (OutputStream)goodOs);
        try {
            tos.close();
            Assert.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)goodOs.closed);
        }
    }

    public void testTee() throws IOException {
        int i;
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        TeeOutputStream tos = new TeeOutputStream((OutputStream)baos1, (OutputStream)baos2);
        for (int i2 = 0; i2 < 20; ++i2) {
            tos.write(i2);
        }
        this.assertByteArrayEquals("TeeOutputStream.write(int)", baos1.toByteArray(), baos2.toByteArray());
        byte[] array = new byte[10];
        for (i = 20; i < 30; ++i) {
            array[i - 20] = (byte)i;
        }
        tos.write(array);
        this.assertByteArrayEquals("TeeOutputStream.write(byte[])", baos1.toByteArray(), baos2.toByteArray());
        for (i = 25; i < 35; ++i) {
            array[i - 25] = (byte)i;
        }
        tos.write(array, 5, 5);
        this.assertByteArrayEquals("TeeOutputStream.write(byte[], int, int)", baos1.toByteArray(), baos2.toByteArray());
        tos.flush();
        tos.close();
    }

    private void assertByteArrayEquals(String msg, byte[] array1, byte[] array2) {
        TeeOutputStreamTest.assertEquals((String)(msg + ": array size mismatch"), (int)array1.length, (int)array2.length);
        for (int i = 0; i < array1.length; ++i) {
            TeeOutputStreamTest.assertEquals((String)(msg + ": array[ " + i + "] mismatch"), (byte)array1[i], (byte)array2[i]);
        }
    }

    private static class RecordCloseByteArrayOutputStream
    extends ByteArrayOutputStream {
        boolean closed;

        private RecordCloseByteArrayOutputStream() {
        }

        public void close() throws IOException {
            super.close();
            this.closed = true;
        }
    }

    private static class ExceptionOnCloseByteArrayOutputStream
    extends ByteArrayOutputStream {
        private ExceptionOnCloseByteArrayOutputStream() {
        }

        public void close() throws IOException {
            throw new IOException();
        }
    }
}

