/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class FileUtilsFileNewerTestCase
extends FileBasedTestCase {
    private static final int FILE1_SIZE = 1;
    private static final int FILE2_SIZE = 4097;
    private File m_testFile1 = new File(FileUtilsFileNewerTestCase.getTestDirectory(), "file1-test.txt");
    private File m_testFile2 = new File(FileUtilsFileNewerTestCase.getTestDirectory(), "file2-test.txt");

    public FileUtilsFileNewerTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        FileUtilsFileNewerTestCase.getTestDirectory().mkdirs();
        this.createFile(this.m_testFile1, 1L);
        this.createFile(this.m_testFile2, 4097L);
    }

    protected void tearDown() throws Exception {
        this.m_testFile1.delete();
        this.m_testFile2.delete();
    }

    public void testIsFileNewer() {
        if (!this.m_testFile1.exists()) {
            throw new IllegalStateException("The m_testFile1 should exist");
        }
        long fileLastModified = this.m_testFile1.lastModified();
        long TWO_SECOND = 2000L;
        this.testIsFileNewer("two second earlier is not newer", this.m_testFile1, fileLastModified + 2000L, false);
        this.testIsFileNewer("same time is not newer", this.m_testFile1, fileLastModified, false);
        this.testIsFileNewer("two second later is newer", this.m_testFile1, fileLastModified - 2000L, true);
    }

    public void testIsFileNewerImaginaryFile() {
        File imaginaryFile = new File(FileUtilsFileNewerTestCase.getTestDirectory(), "imaginaryFile");
        if (imaginaryFile.exists()) {
            throw new IllegalStateException("The imaginary File exists");
        }
        this.testIsFileNewer("imaginary file can be newer", imaginaryFile, this.m_testFile2.lastModified(), false);
    }

    protected void testIsFileNewer(String description, File file, long time, boolean wantedResult) {
        FileUtilsFileNewerTestCase.assertEquals((String)(description + " - time"), (boolean)wantedResult, (boolean)FileUtils.isFileNewer((File)file, (long)time));
        FileUtilsFileNewerTestCase.assertEquals((String)(description + " - date"), (boolean)wantedResult, (boolean)FileUtils.isFileNewer((File)file, (Date)new Date(time)));
        File temporaryFile = this.m_testFile2;
        temporaryFile.setLastModified(time);
        FileUtilsFileNewerTestCase.assertEquals((String)"The temporary file hasn't the right last modification date", (long)time, (long)temporaryFile.lastModified());
        FileUtilsFileNewerTestCase.assertEquals((String)(description + " - file"), (boolean)wantedResult, (boolean)FileUtils.isFileNewer((File)file, (File)temporaryFile));
    }

    public void testIsFileNewerNoFile() {
        try {
            FileUtils.isFileNewer(null, (long)0L);
            FileUtilsFileNewerTestCase.fail((String)"File not specified");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsFileNewerNoDate() {
        try {
            FileUtils.isFileNewer((File)this.m_testFile1, (Date)null);
            FileUtilsFileNewerTestCase.fail((String)"Date not specified");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsFileNewerNoFileReference() {
        try {
            FileUtils.isFileNewer((File)this.m_testFile1, (File)null);
            FileUtilsFileNewerTestCase.fail((String)"Reference file not specified");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

