/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Selector;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.SelectorAdapter;
import org.apache.commons.io.testtools.FileBasedTestCase;
import org.junit.Assert;

public class IOUtilsTestCase
extends FileBasedTestCase {
    private static final boolean WINDOWS = File.separatorChar == '\\';
    private static final int FILE_SIZE = 4097;
    private File m_testFile;
    private byte[] iarr = null;
    private char[] carr = null;

    public void setUp() {
        int i;
        try {
            IOUtilsTestCase.getTestDirectory().mkdirs();
            this.m_testFile = new File(IOUtilsTestCase.getTestDirectory(), "file2-test.txt");
            this.createFile(this.m_testFile, 4097L);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Can't run this test because the environment could not be built: " + ioe.getMessage());
        }
        this.iarr = new byte[200];
        Arrays.fill(this.iarr, (byte)-1);
        for (i = 0; i < 80; ++i) {
            this.iarr[i] = (byte)i;
        }
        this.carr = new char[200];
        Arrays.fill(this.carr, '\uffff');
        for (i = 0; i < 80; ++i) {
            this.carr[i] = (char)i;
        }
    }

    public void tearDown() {
        this.carr = null;
        this.iarr = null;
        try {
            FileUtils.deleteDirectory((File)IOUtilsTestCase.getTestDirectory());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not clear up " + IOUtilsTestCase.getTestDirectory() + ": " + e);
        }
    }

    public IOUtilsTestCase(String name) {
        super(name);
    }

    public void testCloseQuietlyNullSelector() {
        Selector selector = null;
        IOUtils.closeQuietly(selector);
    }

    public void testCloseableCloseQuietlyOnException() {
        IOUtils.closeQuietly((Closeable)new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        });
    }

    public void testSocketCloseQuietlyOnException() {
        IOUtils.closeQuietly((Socket)new Socket(){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        });
    }

    public void testServerSocketCloseQuietlyOnException() throws IOException {
        IOUtils.closeQuietly((ServerSocket)new ServerSocket(){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        });
    }

    public void testSocketCloseQuietly() {
        IOUtils.closeQuietly((Socket)null);
        IOUtils.closeQuietly((Socket)new Socket());
    }

    public void testServerSocketCloseQuietly() throws IOException {
        IOUtils.closeQuietly((ServerSocket)null);
        IOUtils.closeQuietly((ServerSocket)new ServerSocket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCloseQuietlySelector() {
        Selector selector = null;
        try {
            selector = Selector.open();
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((Selector)selector);
        }
    }

    public void testCloseQuietlySelectorIOException() {
        SelectorAdapter selector = new SelectorAdapter(){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };
        IOUtils.closeQuietly((Selector)selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCloseQuietlySelectorTwice() {
        Selector selector = null;
        try {
            selector = Selector.open();
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((Selector)selector);
            IOUtils.closeQuietly((Selector)selector);
        }
    }

    public void testConstants() throws Exception {
        IOUtilsTestCase.assertEquals((char)'/', (char)'/');
        IOUtilsTestCase.assertEquals((char)'\\', (char)'\\');
        IOUtilsTestCase.assertEquals((String)"\n", (String)"\n");
        IOUtilsTestCase.assertEquals((String)"\r\n", (String)"\r\n");
        if (WINDOWS) {
            IOUtilsTestCase.assertEquals((char)'\\', (char)IOUtils.DIR_SEPARATOR);
            IOUtilsTestCase.assertEquals((String)"\r\n", (String)IOUtils.LINE_SEPARATOR);
        } else {
            IOUtilsTestCase.assertEquals((char)'/', (char)IOUtils.DIR_SEPARATOR);
            IOUtilsTestCase.assertEquals((String)"\n", (String)IOUtils.LINE_SEPARATOR);
        }
    }

    private void assertEqualContent(byte[] b0, byte[] b1) {
        IOUtilsTestCase.assertTrue((String)"Content not equal according to java.util.Arrays#equals()", (boolean)Arrays.equals(b0, b1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamToString() throws Exception {
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            String out = IOUtils.toString((InputStream)fin);
            IOUtilsTestCase.assertNotNull((Object)out);
            IOUtilsTestCase.assertEquals((String)"Not all bytes were read", (int)0, (int)fin.available());
            IOUtilsTestCase.assertEquals((String)"Wrong output size", (int)4097, (int)out.length());
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReaderToString() throws Exception {
        FileReader fin = new FileReader(this.m_testFile);
        try {
            String out = IOUtils.toString((Reader)fin);
            IOUtilsTestCase.assertNotNull((Object)out);
            IOUtilsTestCase.assertEquals((String)"Wrong output size", (int)4097, (int)out.length());
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringToOutputStream() throws Exception {
        String str;
        File destination = this.newFile("copy5.txt");
        FileReader fin = new FileReader(this.m_testFile);
        try {
            str = IOUtils.toString((Reader)fin);
        }
        finally {
            fin.close();
        }
        FileOutputStream fout = new FileOutputStream(destination);
        try {
            CopyUtils.copy((String)str, (OutputStream)fout);
            this.checkFile(destination, this.m_testFile);
            this.checkWrite(fout);
        }
        finally {
            fout.close();
        }
        this.deleteFile(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringToWriter() throws Exception {
        String str;
        File destination = this.newFile("copy6.txt");
        FileReader fin = new FileReader(this.m_testFile);
        try {
            str = IOUtils.toString((Reader)fin);
        }
        finally {
            fin.close();
        }
        FileWriter fout = new FileWriter(destination);
        try {
            CopyUtils.copy((String)str, (Writer)fout);
            fout.flush();
            this.checkFile(destination, this.m_testFile);
            this.checkWrite(fout);
        }
        finally {
            fout.close();
        }
        this.deleteFile(destination);
    }

    public void testToByteArray_Reader() throws IOException {
        String charsetName = "UTF-8";
        byte[] expecteds = "UTF-8".getBytes("UTF-8");
        byte[] actuals = IOUtils.toByteArray((Reader)new InputStreamReader(new ByteArrayInputStream(expecteds)));
        Assert.assertArrayEquals((byte[])expecteds, (byte[])actuals);
        actuals = IOUtils.toByteArray((Reader)new InputStreamReader(new ByteArrayInputStream(expecteds)), (String)"UTF-8");
        Assert.assertArrayEquals((byte[])expecteds, (byte[])actuals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamToByteArray() throws Exception {
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            byte[] out = IOUtils.toByteArray((InputStream)fin);
            IOUtilsTestCase.assertNotNull((Object)out);
            IOUtilsTestCase.assertEquals((String)"Not all bytes were read", (int)0, (int)fin.available());
            IOUtilsTestCase.assertEquals((String)"Wrong output size", (int)4097, (int)out.length);
            this.assertEqualContent(out, this.m_testFile);
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamToByteArray_Size() throws Exception {
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            byte[] out = IOUtils.toByteArray((InputStream)fin, (long)this.m_testFile.length());
            IOUtilsTestCase.assertNotNull((Object)out);
            IOUtilsTestCase.assertEquals((String)"Not all bytes were read", (int)0, (int)fin.available());
            IOUtilsTestCase.assertEquals((String)("Wrong output size: out.length=" + out.length + "!=" + 4097), (int)4097, (int)out.length);
            this.assertEqualContent(out, this.m_testFile);
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamToByteArray_NegativeSize() throws Exception {
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            IOUtils.toByteArray((InputStream)fin, (int)-1);
            IOUtilsTestCase.fail((String)"IllegalArgumentException excepted");
        }
        catch (IllegalArgumentException exc) {
            IOUtilsTestCase.assertTrue((String)"Exception message does not start with \"Size must be equal or greater than zero\"", (boolean)exc.getMessage().startsWith("Size must be equal or greater than zero"));
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamToByteArray_ZeroSize() throws Exception {
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            byte[] out = IOUtils.toByteArray((InputStream)fin, (int)0);
            IOUtilsTestCase.assertNotNull((String)"Out cannot be null", (Object)out);
            IOUtilsTestCase.assertEquals((String)"Out length must be 0", (int)0, (int)out.length);
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamToByteArray_IllegalSize() throws Exception {
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            IOUtils.toByteArray((InputStream)fin, (long)(this.m_testFile.length() + 1L));
            IOUtilsTestCase.fail((String)"IOException excepted");
        }
        catch (IOException exc) {
            IOUtilsTestCase.assertTrue((String)"Exception message does not start with \"Unexpected readed size\"", (boolean)exc.getMessage().startsWith("Unexpected readed size"));
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamToByteArray_LongSize() throws Exception {
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            IOUtils.toByteArray((InputStream)fin, (long)0x80000000L);
            IOUtilsTestCase.fail((String)"IOException excepted");
        }
        catch (IllegalArgumentException exc) {
            IOUtilsTestCase.assertTrue((String)"Exception message does not start with \"Size cannot be greater than Integer max value\"", (boolean)exc.getMessage().startsWith("Size cannot be greater than Integer max value"));
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamToBufferedInputStream() throws Exception {
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            InputStream in = IOUtils.toBufferedInputStream((InputStream)fin);
            byte[] out = IOUtils.toByteArray((InputStream)in);
            IOUtilsTestCase.assertNotNull((Object)out);
            IOUtilsTestCase.assertEquals((String)"Not all bytes were read", (int)0, (int)fin.available());
            IOUtilsTestCase.assertEquals((String)"Wrong output size", (int)4097, (int)out.length);
            this.assertEqualContent(out, this.m_testFile);
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringToByteArray() throws Exception {
        FileReader fin = new FileReader(this.m_testFile);
        try {
            String str = IOUtils.toString((Reader)fin);
            byte[] out = IOUtils.toByteArray((String)str);
            this.assertEqualContent(str.getBytes(), out);
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testByteArrayToWriter() throws Exception {
        byte[] in;
        File destination = this.newFile("copy7.txt");
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            in = IOUtils.toByteArray((InputStream)fin);
        }
        finally {
            fin.close();
        }
        FileWriter fout = new FileWriter(destination);
        try {
            CopyUtils.copy((byte[])in, (Writer)fout);
            fout.flush();
            this.checkFile(destination, this.m_testFile);
            this.checkWrite(fout);
        }
        finally {
            fout.close();
        }
        this.deleteFile(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testByteArrayToString() throws Exception {
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            byte[] in = IOUtils.toByteArray((InputStream)fin);
            String str = IOUtils.toString((byte[])in);
            this.assertEqualContent(in, str.getBytes());
        }
        finally {
            fin.close();
        }
    }

    public void testCharSequenceToInputStream() throws Exception {
        StringBuilder csq = new StringBuilder("Abc123Xyz!");
        InputStream inStream = IOUtils.toInputStream((CharSequence)csq);
        byte[] bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent(((Object)csq).toString().getBytes(), bytes);
        inStream = IOUtils.toInputStream((CharSequence)csq, (String)null);
        bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent(((Object)csq).toString().getBytes(), bytes);
        inStream = IOUtils.toInputStream((CharSequence)csq, (String)"UTF-8");
        bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent(((Object)csq).toString().getBytes("UTF-8"), bytes);
    }

    public void testStringToInputStream() throws Exception {
        String str = "Abc123Xyz!";
        InputStream inStream = IOUtils.toInputStream((String)str);
        byte[] bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent(str.getBytes(), bytes);
        inStream = IOUtils.toInputStream((String)str, (String)null);
        bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent(str.getBytes(), bytes);
        inStream = IOUtils.toInputStream((String)str, (String)"UTF-8");
        bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent(str.getBytes("UTF-8"), bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testByteArrayToOutputStream() throws Exception {
        byte[] in;
        File destination = this.newFile("copy8.txt");
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            in = IOUtils.toByteArray((InputStream)fin);
        }
        finally {
            fin.close();
        }
        FileOutputStream fout = new FileOutputStream(destination);
        try {
            CopyUtils.copy((byte[])in, (OutputStream)fout);
            fout.flush();
            this.checkFile(destination, this.m_testFile);
            this.checkWrite(fout);
        }
        finally {
            fout.close();
        }
        this.deleteFile(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamToCharArray() throws Exception {
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            char[] out = IOUtils.toCharArray((InputStream)fin);
            IOUtilsTestCase.assertNotNull((Object)out);
            IOUtilsTestCase.assertEquals((String)"Not all chars were read", (int)0, (int)fin.available());
            IOUtilsTestCase.assertEquals((String)"Wrong output size", (int)4097, (int)out.length);
            this.assertEqualContent(out, this.m_testFile);
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInputStreamToCharArrayWithEncoding() throws Exception {
        FileInputStream fin = new FileInputStream(this.m_testFile);
        try {
            char[] out = IOUtils.toCharArray((InputStream)fin, (String)"UTF-8");
            IOUtilsTestCase.assertNotNull((Object)out);
            IOUtilsTestCase.assertEquals((String)"Not all chars were read", (int)0, (int)fin.available());
            IOUtilsTestCase.assertEquals((String)"Wrong output size", (int)4097, (int)out.length);
            this.assertEqualContent(out, this.m_testFile);
        }
        finally {
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReaderToCharArray() throws Exception {
        FileReader fr = new FileReader(this.m_testFile);
        try {
            char[] out = IOUtils.toCharArray((Reader)fr);
            IOUtilsTestCase.assertNotNull((Object)out);
            IOUtilsTestCase.assertEquals((String)"Wrong output size", (int)4097, (int)out.length);
            this.assertEqualContent(out, this.m_testFile);
        }
        finally {
            fr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadLines_InputStream() throws Exception {
        File file = this.newFile("lines.txt");
        FileInputStream in = null;
        try {
            String[] data = new String[]{"hello", "world", "", "this is", "some text"};
            this.createLineBasedFile(file, data);
            in = new FileInputStream(file);
            List lines = IOUtils.readLines((InputStream)in);
            IOUtilsTestCase.assertEquals(Arrays.asList(data), (Object)lines);
            IOUtilsTestCase.assertEquals((int)-1, (int)((InputStream)in).read());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            this.deleteFile(file);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        this.deleteFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadLines_InputStream_String() throws Exception {
        File file = this.newFile("lines.txt");
        FileInputStream in = null;
        try {
            String[] data = new String[]{"hello", "/u1234", "", "this is", "some text"};
            this.createLineBasedFile(file, data);
            in = new FileInputStream(file);
            List lines = IOUtils.readLines((InputStream)in, (String)"UTF-8");
            IOUtilsTestCase.assertEquals(Arrays.asList(data), (Object)lines);
            IOUtilsTestCase.assertEquals((int)-1, (int)((InputStream)in).read());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            this.deleteFile(file);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        this.deleteFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadLines_Reader() throws Exception {
        File file = this.newFile("lines.txt");
        InputStreamReader in = null;
        try {
            String[] data = new String[]{"hello", "/u1234", "", "this is", "some text"};
            this.createLineBasedFile(file, data);
            in = new InputStreamReader(new FileInputStream(file));
            List lines = IOUtils.readLines((Reader)in);
            IOUtilsTestCase.assertEquals(Arrays.asList(data), (Object)lines);
            IOUtilsTestCase.assertEquals((int)-1, (int)((Reader)in).read());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            this.deleteFile(file);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        this.deleteFile(file);
    }

    public void testSkipStream() throws Exception {
        int size = 1027;
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[1027]);
        try {
            IOUtils.skipFully((InputStream)input, (long)-1L);
            IOUtilsTestCase.fail((String)"Should have failed with IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        IOUtils.skipFully((InputStream)input, (long)0L);
        IOUtils.skipFully((InputStream)input, (long)1026L);
        try {
            IOUtils.skipFully((InputStream)input, (long)2L);
            IOUtilsTestCase.fail((String)"Should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    public void testSkipReader() throws Exception {
        int size = 1027;
        CharArrayReader input = new CharArrayReader(new char[1027]);
        IOUtils.skipFully((Reader)input, (long)0L);
        IOUtils.skipFully((Reader)input, (long)1024L);
        try {
            IOUtils.skipFully((Reader)input, (long)-1L);
            IOUtilsTestCase.fail((String)"Should have failed with IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            IOUtils.skipFully((Reader)input, (long)5L);
            IOUtilsTestCase.fail((String)"Should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IOUtils.closeQuietly((Reader)input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSkipFileReader() throws Exception {
        FileReader in = new FileReader(this.m_testFile);
        try {
            IOUtilsTestCase.assertEquals((long)4087L, (long)IOUtils.skip((Reader)in, (long)4087L));
            IOUtilsTestCase.assertEquals((long)10L, (long)IOUtils.skip((Reader)in, (long)20L));
            IOUtilsTestCase.assertEquals((long)0L, (long)IOUtils.skip((Reader)in, (long)10L));
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSkipFileInput() throws Exception {
        FileInputStream in = new FileInputStream(this.m_testFile);
        try {
            IOUtilsTestCase.assertEquals((long)4087L, (long)IOUtils.skip((InputStream)in, (long)4087L));
            IOUtilsTestCase.assertEquals((long)10L, (long)IOUtils.skip((InputStream)in, (long)20L));
            IOUtilsTestCase.assertEquals((long)0L, (long)IOUtils.skip((InputStream)in, (long)10L));
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private void testURIToString(String encoding) throws Exception {
        URI url = this.m_testFile.toURI();
        String out = IOUtils.toString((URI)url, (String)encoding);
        IOUtilsTestCase.assertNotNull((Object)out);
        IOUtilsTestCase.assertEquals((String)"Wrong output size", (int)4097, (int)out.length());
    }

    public void testURIToStringNoEncoding() throws Exception {
        URI url = this.m_testFile.toURI();
        String out = IOUtils.toString((URI)url);
        IOUtilsTestCase.assertNotNull((Object)out);
        IOUtilsTestCase.assertEquals((String)"Wrong output size", (int)4097, (int)out.length());
    }

    public void testURIToStringNullEncoding() throws Exception {
        this.testURIToString(null);
    }

    public void testURIToStringUsAciiEncoding() throws Exception {
        this.testURIToString("US-ASCII");
    }

    private void testURLToString(String encoding) throws Exception {
        URL url = this.m_testFile.toURI().toURL();
        String out = IOUtils.toString((URL)url, (String)encoding);
        IOUtilsTestCase.assertNotNull((Object)out);
        IOUtilsTestCase.assertEquals((String)"Wrong output size", (int)4097, (int)out.length());
    }

    public void testURLToStringNoEncoding() throws Exception {
        URL url = this.m_testFile.toURI().toURL();
        String out = IOUtils.toString((URL)url);
        IOUtilsTestCase.assertNotNull((Object)out);
        IOUtilsTestCase.assertEquals((String)"Wrong output size", (int)4097, (int)out.length());
    }

    public void testURLToStringNullEncoding() throws Exception {
        this.testURLToString(null);
    }

    public void testURLToStringUsAciiEncoding() throws Exception {
        this.testURLToString("US-ASCII");
    }

    public void testContentEqualsIgnoreEOL() throws Exception {
        CharArrayReader r1 = new CharArrayReader("".toCharArray());
        CharArrayReader r2 = new CharArrayReader("".toCharArray());
        IOUtilsTestCase.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)r1, (Reader)r2));
        r1 = new CharArrayReader("1".toCharArray());
        r2 = new CharArrayReader("1".toCharArray());
        IOUtilsTestCase.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)r1, (Reader)r2));
        r1 = new CharArrayReader("1".toCharArray());
        r2 = new CharArrayReader("2".toCharArray());
        IOUtilsTestCase.assertFalse((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)r1, (Reader)r2));
        r1 = new CharArrayReader("123\rabc".toCharArray());
        r2 = new CharArrayReader("123\nabc".toCharArray());
        IOUtilsTestCase.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)r1, (Reader)r2));
        r1 = new CharArrayReader("321".toCharArray());
        r2 = new CharArrayReader("321\r\n".toCharArray());
        IOUtilsTestCase.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)r1, (Reader)r2));
    }

    public void testContentEqualsReaderReader() throws Exception {
        IOUtilsTestCase.assertTrue((boolean)IOUtils.contentEquals((Reader)new StringReader(""), (Reader)new StringReader("")));
        IOUtilsTestCase.assertTrue((boolean)IOUtils.contentEquals((Reader)new BufferedReader(new StringReader("")), (Reader)new BufferedReader(new StringReader(""))));
        IOUtilsTestCase.assertTrue((boolean)IOUtils.contentEquals((Reader)new StringReader("ABC"), (Reader)new StringReader("ABC")));
        IOUtilsTestCase.assertFalse((boolean)IOUtils.contentEquals((Reader)new StringReader("ABCD"), (Reader)new StringReader("ABC")));
        IOUtilsTestCase.assertFalse((boolean)IOUtils.contentEquals((Reader)new StringReader("ABC"), (Reader)new StringReader("ABCD")));
    }

    public void testReadStream() throws Exception {
        int size = 1027;
        byte[] buffer = new byte[1027];
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[1027]);
        try {
            IOUtils.readFully((InputStream)input, (byte[])buffer, (int)0, (int)-1);
            IOUtilsTestCase.fail((String)"Should have failed with IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        IOUtils.readFully((InputStream)input, (byte[])buffer, (int)0, (int)0);
        IOUtils.readFully((InputStream)input, (byte[])buffer, (int)0, (int)1026);
        try {
            IOUtils.readFully((InputStream)input, (byte[])buffer, (int)0, (int)2);
            IOUtilsTestCase.fail((String)"Should have failed with EOFxception");
        }
        catch (EOFException expected) {
            // empty catch block
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    public void testReadReader() throws Exception {
        int size = 1027;
        char[] buffer = new char[1027];
        CharArrayReader input = new CharArrayReader(new char[1027]);
        IOUtils.readFully((Reader)input, (char[])buffer, (int)0, (int)0);
        IOUtils.readFully((Reader)input, (char[])buffer, (int)0, (int)1024);
        try {
            IOUtils.readFully((Reader)input, (char[])buffer, (int)0, (int)-1);
            IOUtilsTestCase.fail((String)"Should have failed with IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            IOUtils.readFully((Reader)input, (char[])buffer, (int)0, (int)5);
            IOUtilsTestCase.fail((String)"Should have failed with EOFException");
        }
        catch (EOFException expected) {
            // empty catch block
        }
        IOUtils.closeQuietly((Reader)input);
    }

    public void testReadReaderWithOffset() throws Exception {
        StringReader reader = new StringReader("abcd1234");
        char[] buffer = "wx00000000".toCharArray();
        IOUtils.readFully((Reader)reader, (char[])buffer, (int)2, (int)8);
        IOUtilsTestCase.assertEquals((String)"wxabcd1234", (String)new String(buffer));
        IOUtils.closeQuietly((Reader)reader);
    }

    public void testReadStreamWithOffset() throws Exception {
        byte[] bytes = "abcd1234".getBytes("UTF-8");
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        byte[] buffer = "wx00000000".getBytes("UTF-8");
        IOUtils.readFully((InputStream)stream, (byte[])buffer, (int)2, (int)8);
        IOUtilsTestCase.assertEquals((String)"wxabcd1234", (String)new String(buffer, 0, buffer.length, "UTF-8"));
        IOUtils.closeQuietly((InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoSkip() throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(this.iarr);
            os = new ByteArrayOutputStream();
            IOUtilsTestCase.assertEquals((long)100L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)0L, (long)100L));
            byte[] oarr = os.toByteArray();
            IOUtilsTestCase.assertEquals((int)100, (int)oarr.length);
            IOUtilsTestCase.assertEquals((int)1, (int)oarr[1]);
            IOUtilsTestCase.assertEquals((int)79, (int)oarr[79]);
            IOUtilsTestCase.assertEquals((int)-1, (int)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSkip() throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(this.iarr);
            os = new ByteArrayOutputStream();
            IOUtilsTestCase.assertEquals((long)100L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)10L, (long)100L));
            byte[] oarr = os.toByteArray();
            IOUtilsTestCase.assertEquals((int)100, (int)oarr.length);
            IOUtilsTestCase.assertEquals((int)11, (int)oarr[1]);
            IOUtilsTestCase.assertEquals((int)79, (int)oarr[69]);
            IOUtilsTestCase.assertEquals((int)-1, (int)oarr[70]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testSkipInvalid() throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(this.iarr);
            os = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)1000L, (long)100L);
            IOUtilsTestCase.fail((String)"Should have thrown EOFException");
        }
        catch (EOFException eOFException) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFullLength() throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(this.iarr);
            os = new ByteArrayOutputStream();
            IOUtilsTestCase.assertEquals((long)200L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)0L, (long)-1L));
            byte[] oarr = os.toByteArray();
            IOUtilsTestCase.assertEquals((int)200, (int)oarr.length);
            IOUtilsTestCase.assertEquals((int)1, (int)oarr[1]);
            IOUtilsTestCase.assertEquals((int)79, (int)oarr[79]);
            IOUtilsTestCase.assertEquals((int)-1, (int)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExtraLength() throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(this.iarr);
            os = new ByteArrayOutputStream();
            IOUtilsTestCase.assertEquals((long)200L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)0L, (long)2000L));
            byte[] oarr = os.toByteArray();
            IOUtilsTestCase.assertEquals((int)200, (int)oarr.length);
            IOUtilsTestCase.assertEquals((int)1, (int)oarr[1]);
            IOUtilsTestCase.assertEquals((int)79, (int)oarr[79]);
            IOUtilsTestCase.assertEquals((int)-1, (int)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCharNoSkip() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            IOUtilsTestCase.assertEquals((long)100L, (long)IOUtils.copyLarge((Reader)is, (Writer)os, (long)0L, (long)100L));
            char[] oarr = os.toCharArray();
            IOUtilsTestCase.assertEquals((int)100, (int)oarr.length);
            IOUtilsTestCase.assertEquals((int)1, (int)oarr[1]);
            IOUtilsTestCase.assertEquals((int)79, (int)oarr[79]);
            IOUtilsTestCase.assertEquals((char)'\uffff', (char)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCharSkip() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            IOUtilsTestCase.assertEquals((long)100L, (long)IOUtils.copyLarge((Reader)is, (Writer)os, (long)10L, (long)100L));
            char[] oarr = os.toCharArray();
            IOUtilsTestCase.assertEquals((int)100, (int)oarr.length);
            IOUtilsTestCase.assertEquals((int)11, (int)oarr[1]);
            IOUtilsTestCase.assertEquals((int)79, (int)oarr[69]);
            IOUtilsTestCase.assertEquals((char)'\uffff', (char)oarr[70]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testCharSkipInvalid() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            IOUtils.copyLarge((Reader)is, (Writer)os, (long)1000L, (long)100L);
            IOUtilsTestCase.fail((String)"Should have thrown EOFException");
        }
        catch (EOFException eOFException) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCharFullLength() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            IOUtilsTestCase.assertEquals((long)200L, (long)IOUtils.copyLarge((Reader)is, (Writer)os, (long)0L, (long)-1L));
            char[] oarr = os.toCharArray();
            IOUtilsTestCase.assertEquals((int)200, (int)oarr.length);
            IOUtilsTestCase.assertEquals((int)1, (int)oarr[1]);
            IOUtilsTestCase.assertEquals((int)79, (int)oarr[79]);
            IOUtilsTestCase.assertEquals((char)'\uffff', (char)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCharExtraLength() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            IOUtilsTestCase.assertEquals((long)200L, (long)IOUtils.copyLarge((Reader)is, (Writer)os, (long)0L, (long)2000L));
            char[] oarr = os.toCharArray();
            IOUtilsTestCase.assertEquals((int)200, (int)oarr.length);
            IOUtilsTestCase.assertEquals((int)1, (int)oarr[1]);
            IOUtilsTestCase.assertEquals((int)79, (int)oarr[79]);
            IOUtilsTestCase.assertEquals((char)'\uffff', (char)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }
}

