/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import junit.framework.TestCase;
import org.apache.commons.io.ThreadMonitor;

public class ThreadMonitorTestCase
extends TestCase {
    public ThreadMonitorTestCase(String name) {
        super(name);
    }

    public void testTimeout() {
        try {
            Thread monitor = ThreadMonitor.start((long)100L);
            Thread.sleep(200L);
            ThreadMonitor.stop((Thread)monitor);
            ThreadMonitorTestCase.fail((String)"Expected InterruptedException");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void testCompletedWithoutTimeout() {
        try {
            Thread monitor = ThreadMonitor.start((long)200L);
            Thread.sleep(100L);
            ThreadMonitor.stop((Thread)monitor);
        }
        catch (InterruptedException e) {
            ThreadMonitorTestCase.fail((String)"Timed Out");
        }
    }

    public void testNoTimeout() {
        Thread monitor;
        try {
            monitor = ThreadMonitor.start((long)-1L);
            ThreadMonitorTestCase.assertNull((String)"Timeout -1, Monitor should be null", (Object)monitor);
            Thread.sleep(100L);
            ThreadMonitor.stop((Thread)monitor);
        }
        catch (Exception e) {
            ThreadMonitorTestCase.fail((String)("Timeout -1, threw " + e));
        }
        try {
            monitor = ThreadMonitor.start((long)0L);
            ThreadMonitorTestCase.assertNull((String)"Timeout 0, Monitor should be null", (Object)monitor);
            Thread.sleep(100L);
            ThreadMonitor.stop((Thread)monitor);
        }
        catch (Exception e) {
            ThreadMonitorTestCase.fail((String)("Timeout 0, threw " + e));
        }
    }
}

