/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class FileCleaningTrackerTestCase
extends FileBasedTestCase {
    private File testFile = new File(FileCleaningTrackerTestCase.getTestDirectory(), "file-test.txt");
    private FileCleaningTracker theInstance;

    protected FileCleaningTracker newInstance() {
        return new FileCleaningTracker();
    }

    public FileCleaningTrackerTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.theInstance = this.newInstance();
        FileCleaningTrackerTestCase.getTestDirectory().mkdirs();
    }

    protected void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)FileCleaningTrackerTestCase.getTestDirectory());
        this.theInstance.q = new ReferenceQueue();
        this.theInstance.trackers.clear();
        this.theInstance.deleteFailures.clear();
        this.theInstance.exitWhenFinished = false;
        this.theInstance.reaper = null;
        this.theInstance = null;
    }

    public void testFileCleanerFile() throws Exception {
        String path = this.testFile.getPath();
        FileCleaningTrackerTestCase.assertFalse((boolean)this.testFile.exists());
        RandomAccessFile r = new RandomAccessFile(this.testFile, "rw");
        FileCleaningTrackerTestCase.assertTrue((boolean)this.testFile.exists());
        FileCleaningTrackerTestCase.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        this.theInstance.track(path, (Object)r);
        FileCleaningTrackerTestCase.assertEquals((int)1, (int)this.theInstance.getTrackCount());
        r.close();
        this.testFile = null;
        r = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(new File(path));
        FileCleaningTrackerTestCase.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        FileCleaningTrackerTestCase.assertEquals((String)this.showFailures(), (boolean)false, (boolean)new File(path).exists());
    }

    public void testFileCleanerDirectory() throws Exception {
        this.createFile(this.testFile, 100L);
        FileCleaningTrackerTestCase.assertTrue((boolean)this.testFile.exists());
        FileCleaningTrackerTestCase.assertTrue((boolean)FileCleaningTrackerTestCase.getTestDirectory().exists());
        Object obj = new Object();
        FileCleaningTrackerTestCase.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        this.theInstance.track(FileCleaningTrackerTestCase.getTestDirectory(), obj);
        FileCleaningTrackerTestCase.assertEquals((int)1, (int)this.theInstance.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        FileCleaningTrackerTestCase.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        FileCleaningTrackerTestCase.assertTrue((boolean)this.testFile.exists());
        FileCleaningTrackerTestCase.assertTrue((boolean)this.testFile.getParentFile().exists());
    }

    public void testFileCleanerDirectory_NullStrategy() throws Exception {
        this.createFile(this.testFile, 100L);
        FileCleaningTrackerTestCase.assertTrue((boolean)this.testFile.exists());
        FileCleaningTrackerTestCase.assertTrue((boolean)FileCleaningTrackerTestCase.getTestDirectory().exists());
        Object obj = new Object();
        FileCleaningTrackerTestCase.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        this.theInstance.track(FileCleaningTrackerTestCase.getTestDirectory(), obj, (FileDeleteStrategy)null);
        FileCleaningTrackerTestCase.assertEquals((int)1, (int)this.theInstance.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        FileCleaningTrackerTestCase.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        FileCleaningTrackerTestCase.assertTrue((boolean)this.testFile.exists());
        FileCleaningTrackerTestCase.assertTrue((boolean)this.testFile.getParentFile().exists());
    }

    public void testFileCleanerDirectory_ForceStrategy() throws Exception {
        this.createFile(this.testFile, 100L);
        FileCleaningTrackerTestCase.assertTrue((boolean)this.testFile.exists());
        FileCleaningTrackerTestCase.assertTrue((boolean)FileCleaningTrackerTestCase.getTestDirectory().exists());
        Object obj = new Object();
        FileCleaningTrackerTestCase.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        this.theInstance.track(FileCleaningTrackerTestCase.getTestDirectory(), obj, FileDeleteStrategy.FORCE);
        FileCleaningTrackerTestCase.assertEquals((int)1, (int)this.theInstance.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(this.testFile.getParentFile());
        FileCleaningTrackerTestCase.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        FileCleaningTrackerTestCase.assertEquals((String)this.showFailures(), (boolean)false, (boolean)new File(this.testFile.getPath()).exists());
        FileCleaningTrackerTestCase.assertEquals((String)this.showFailures(), (boolean)false, (boolean)this.testFile.getParentFile().exists());
    }

    public void testFileCleanerNull() throws Exception {
        try {
            this.theInstance.track((File)null, new Object());
            FileCleaningTrackerTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            this.theInstance.track((File)null, new Object(), FileDeleteStrategy.NORMAL);
            FileCleaningTrackerTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            this.theInstance.track((String)null, new Object());
            FileCleaningTrackerTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            this.theInstance.track((String)null, new Object(), FileDeleteStrategy.NORMAL);
            FileCleaningTrackerTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFileCleanerExitWhenFinishedFirst() throws Exception {
        FileCleaningTrackerTestCase.assertFalse((boolean)this.theInstance.exitWhenFinished);
        this.theInstance.exitWhenFinished();
        FileCleaningTrackerTestCase.assertTrue((boolean)this.theInstance.exitWhenFinished);
        FileCleaningTrackerTestCase.assertEquals(null, (Object)this.theInstance.reaper);
        this.waitUntilTrackCount();
        FileCleaningTrackerTestCase.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        FileCleaningTrackerTestCase.assertTrue((boolean)this.theInstance.exitWhenFinished);
        FileCleaningTrackerTestCase.assertEquals(null, (Object)this.theInstance.reaper);
    }

    public void testFileCleanerExitWhenFinished_NoTrackAfter() throws Exception {
        FileCleaningTrackerTestCase.assertFalse((boolean)this.theInstance.exitWhenFinished);
        this.theInstance.exitWhenFinished();
        FileCleaningTrackerTestCase.assertTrue((boolean)this.theInstance.exitWhenFinished);
        FileCleaningTrackerTestCase.assertEquals(null, (Object)this.theInstance.reaper);
        String path = this.testFile.getPath();
        Object marker = new Object();
        try {
            this.theInstance.track(path, marker);
            FileCleaningTrackerTestCase.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        FileCleaningTrackerTestCase.assertTrue((boolean)this.theInstance.exitWhenFinished);
        FileCleaningTrackerTestCase.assertEquals(null, (Object)this.theInstance.reaper);
    }

    public void testFileCleanerExitWhenFinished1() throws Exception {
        String path = this.testFile.getPath();
        FileCleaningTrackerTestCase.assertEquals((String)"1-testFile exists", (boolean)false, (boolean)this.testFile.exists());
        RandomAccessFile r = new RandomAccessFile(this.testFile, "rw");
        FileCleaningTrackerTestCase.assertEquals((String)"2-testFile exists", (boolean)true, (boolean)this.testFile.exists());
        FileCleaningTrackerTestCase.assertEquals((String)"3-Track Count", (int)0, (int)this.theInstance.getTrackCount());
        this.theInstance.track(path, (Object)r);
        FileCleaningTrackerTestCase.assertEquals((String)"4-Track Count", (int)1, (int)this.theInstance.getTrackCount());
        FileCleaningTrackerTestCase.assertEquals((String)"5-exitWhenFinished", (boolean)false, (boolean)this.theInstance.exitWhenFinished);
        FileCleaningTrackerTestCase.assertEquals((String)"6-reaper.isAlive", (boolean)true, (boolean)this.theInstance.reaper.isAlive());
        FileCleaningTrackerTestCase.assertEquals((String)"7-exitWhenFinished", (boolean)false, (boolean)this.theInstance.exitWhenFinished);
        this.theInstance.exitWhenFinished();
        FileCleaningTrackerTestCase.assertEquals((String)"8-exitWhenFinished", (boolean)true, (boolean)this.theInstance.exitWhenFinished);
        FileCleaningTrackerTestCase.assertEquals((String)"9-reaper.isAlive", (boolean)true, (boolean)this.theInstance.reaper.isAlive());
        r.close();
        this.testFile = null;
        r = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(new File(path));
        FileCleaningTrackerTestCase.assertEquals((String)"10-Track Count", (int)0, (int)this.theInstance.getTrackCount());
        FileCleaningTrackerTestCase.assertEquals((String)("11-testFile exists " + this.showFailures()), (boolean)false, (boolean)new File(path).exists());
        FileCleaningTrackerTestCase.assertEquals((String)"12-exitWhenFinished", (boolean)true, (boolean)this.theInstance.exitWhenFinished);
        FileCleaningTrackerTestCase.assertEquals((String)"13-reaper.isAlive", (boolean)false, (boolean)this.theInstance.reaper.isAlive());
    }

    public void testFileCleanerExitWhenFinished2() throws Exception {
        String path = this.testFile.getPath();
        FileCleaningTrackerTestCase.assertFalse((boolean)this.testFile.exists());
        RandomAccessFile r = new RandomAccessFile(this.testFile, "rw");
        FileCleaningTrackerTestCase.assertTrue((boolean)this.testFile.exists());
        FileCleaningTrackerTestCase.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        this.theInstance.track(path, (Object)r);
        FileCleaningTrackerTestCase.assertEquals((int)1, (int)this.theInstance.getTrackCount());
        FileCleaningTrackerTestCase.assertFalse((boolean)this.theInstance.exitWhenFinished);
        FileCleaningTrackerTestCase.assertTrue((boolean)this.theInstance.reaper.isAlive());
        r.close();
        this.testFile = null;
        r = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(new File(path));
        FileCleaningTrackerTestCase.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        FileCleaningTrackerTestCase.assertEquals((String)this.showFailures(), (boolean)false, (boolean)new File(path).exists());
        FileCleaningTrackerTestCase.assertFalse((boolean)this.theInstance.exitWhenFinished);
        FileCleaningTrackerTestCase.assertTrue((boolean)this.theInstance.reaper.isAlive());
        FileCleaningTrackerTestCase.assertFalse((boolean)this.theInstance.exitWhenFinished);
        this.theInstance.exitWhenFinished();
        for (int i = 0; i < 20 && this.theInstance.reaper.isAlive(); ++i) {
            Thread.sleep(500L);
        }
        FileCleaningTrackerTestCase.assertTrue((boolean)this.theInstance.exitWhenFinished);
        FileCleaningTrackerTestCase.assertFalse((boolean)this.theInstance.reaper.isAlive());
    }

    private void pauseForDeleteToComplete(File file) {
        int count = 0;
        while (file.exists() && count++ < 40) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            file = new File(file.getPath());
        }
    }

    private String showFailures() throws Exception {
        if (this.theInstance.deleteFailures.size() == 1) {
            return "[Delete Failed: " + (String)this.theInstance.deleteFailures.get(0) + "]";
        }
        return "[Delete Failures: " + this.theInstance.deleteFailures.size() + "]";
    }

    private void waitUntilTrackCount() throws Exception {
        System.gc();
        Thread.sleep(500L);
        int count = 0;
        while (this.theInstance.getTrackCount() != 0 && count++ < 5) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                long i = 0L;
                while (this.theInstance.getTrackCount() != 0) {
                    list.add("A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String " + i++);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            list = null;
            System.gc();
            Thread.sleep(1000L);
        }
        if (this.theInstance.getTrackCount() != 0) {
            throw new IllegalStateException("Your JVM is not releasing References, try running the testcase with less memory (-Xmx)");
        }
    }
}

