/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.testtools.FileBasedTestCase;
import org.apache.commons.io.testtools.YellOnCloseInputStream;
import org.apache.commons.io.testtools.YellOnFlushAndCloseOutputStream;

public class CopyUtilsTest
extends FileBasedTestCase {
    private static final int FILE_SIZE = 4097;
    private byte[] inData = this.generateTestData(4097L);

    public CopyUtilsTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCtor() {
        new CopyUtils();
    }

    public void testCopy_byteArrayToOutputStream() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        CopyUtils.copy((byte[])this.inData, (OutputStream)((Object)out));
        CopyUtilsTest.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        CopyUtilsTest.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testCopy_byteArrayToWriter() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        CopyUtils.copy((byte[])this.inData, (Writer)writer);
        ((Writer)writer).flush();
        CopyUtilsTest.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        CopyUtilsTest.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testCopy_byteArrayToWriterWithEncoding() throws Exception {
        String inDataStr = "data";
        String charsetName = "UTF-8";
        StringWriter writer = new StringWriter();
        CopyUtils.copy((byte[])inDataStr.getBytes(charsetName), (Writer)writer, (String)charsetName);
        CopyUtilsTest.assertEquals((String)inDataStr, (String)writer.toString());
    }

    public void testCopy_inputStreamToOutputStream() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        int count = CopyUtils.copy((InputStream)in, (OutputStream)((Object)out));
        CopyUtilsTest.assertEquals((String)"Not all bytes were read", (int)0, (int)((InputStream)in).available());
        CopyUtilsTest.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        CopyUtilsTest.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
        CopyUtilsTest.assertEquals((int)this.inData.length, (int)count);
    }

    public void testCopy_inputStreamToWriter() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        CopyUtils.copy((InputStream)in, (Writer)writer);
        ((Writer)writer).flush();
        CopyUtilsTest.assertEquals((String)"Not all bytes were read", (int)0, (int)((InputStream)in).available());
        CopyUtilsTest.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        CopyUtilsTest.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testCopy_inputStreamToWriterWithEncoding() throws Exception {
        String inDataStr = "data";
        String charsetName = "UTF-8";
        StringWriter writer = new StringWriter();
        CopyUtils.copy((InputStream)new ByteArrayInputStream(inDataStr.getBytes(charsetName)), (Writer)writer, (String)charsetName);
        CopyUtilsTest.assertEquals((String)inDataStr, (String)writer.toString());
    }

    public void testCopy_readerToOutputStream() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        CopyUtils.copy((Reader)reader, (OutputStream)((Object)out));
        CopyUtilsTest.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        CopyUtilsTest.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testCopy_readerToWriter() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        int count = CopyUtils.copy((Reader)reader, (Writer)writer);
        ((Writer)writer).flush();
        CopyUtilsTest.assertEquals((String)"The number of characters returned by copy is wrong", (int)this.inData.length, (int)count);
        CopyUtilsTest.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        CopyUtilsTest.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testCopy_stringToOutputStream() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        CopyUtils.copy((String)str, (OutputStream)((Object)out));
        CopyUtilsTest.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        CopyUtilsTest.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testCopy_stringToWriter() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        CopyUtils.copy((String)str, (Writer)writer);
        ((Writer)writer).flush();
        CopyUtilsTest.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        CopyUtilsTest.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }
}

