/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.AbstractMonitorTestCase;
import org.apache.commons.io.monitor.CollectionFileListener;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class FileAlterationObserverTestCase
extends AbstractMonitorTestCase {
    public FileAlterationObserverTestCase(String name) {
        super(name);
        this.testDirName = "test-observer";
    }

    @Override
    protected void setUp() throws Exception {
        this.listener = new CollectionFileListener(true);
        super.setUp();
    }

    public void testAddRemoveListeners() {
        FileAlterationObserver observer = new FileAlterationObserver("/foo");
        observer.addListener(null);
        FileAlterationObserverTestCase.assertFalse((String)"Listeners[1]", (boolean)observer.getListeners().iterator().hasNext());
        observer.removeListener(null);
        FileAlterationObserverTestCase.assertFalse((String)"Listeners[2]", (boolean)observer.getListeners().iterator().hasNext());
        FileAlterationListenerAdaptor listener = new FileAlterationListenerAdaptor();
        observer.addListener((FileAlterationListener)listener);
        Iterator it = observer.getListeners().iterator();
        FileAlterationObserverTestCase.assertTrue((String)"Listeners[3]", (boolean)it.hasNext());
        FileAlterationObserverTestCase.assertEquals((String)"Added", (Object)listener, it.next());
        FileAlterationObserverTestCase.assertFalse((String)"Listeners[4]", (boolean)it.hasNext());
        observer.removeListener((FileAlterationListener)listener);
        FileAlterationObserverTestCase.assertFalse((String)"Listeners[5]", (boolean)observer.getListeners().iterator().hasNext());
    }

    public void testToString() {
        File file = new File("/foo");
        FileAlterationObserver observer = null;
        observer = new FileAlterationObserver(file);
        FileAlterationObserverTestCase.assertEquals((String)("FileAlterationObserver[file='" + file.getPath() + "', listeners=0]"), (String)observer.toString());
        observer = new FileAlterationObserver(file, (FileFilter)CanReadFileFilter.CAN_READ);
        FileAlterationObserverTestCase.assertEquals((String)("FileAlterationObserver[file='" + file.getPath() + "', CanReadFileFilter, listeners=0]"), (String)observer.toString());
        FileAlterationObserverTestCase.assertEquals((Object)file, (Object)observer.getDirectory());
    }

    public void testDirectory() {
        try {
            this.checkAndNotify();
            this.checkCollectionsEmpty("A");
            File testDirA = new File(this.testDir, "test-dir-A");
            File testDirB = new File(this.testDir, "test-dir-B");
            File testDirC = new File(this.testDir, "test-dir-C");
            testDirA.mkdir();
            testDirB.mkdir();
            testDirC.mkdir();
            File testDirAFile1 = this.touch(new File(testDirA, "A-file1.java"));
            File testDirAFile2 = this.touch(new File(testDirA, "A-file2.txt"));
            File testDirAFile3 = this.touch(new File(testDirA, "A-file3.java"));
            File testDirAFile4 = this.touch(new File(testDirA, "A-file4.java"));
            File testDirBFile1 = this.touch(new File(testDirB, "B-file1.java"));
            this.checkAndNotify();
            this.checkCollectionSizes("B", 3, 0, 0, 4, 0, 0);
            FileAlterationObserverTestCase.assertTrue((String)"B testDirA", (boolean)this.listener.getCreatedDirectories().contains(testDirA));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirB", (boolean)this.listener.getCreatedDirectories().contains(testDirB));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirC", (boolean)this.listener.getCreatedDirectories().contains(testDirC));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile1", (boolean)this.listener.getCreatedFiles().contains(testDirAFile1));
            FileAlterationObserverTestCase.assertFalse((String)"B testDirAFile2", (boolean)this.listener.getCreatedFiles().contains(testDirAFile2));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile3", (boolean)this.listener.getCreatedFiles().contains(testDirAFile3));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile4", (boolean)this.listener.getCreatedFiles().contains(testDirAFile4));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirBFile1", (boolean)this.listener.getCreatedFiles().contains(testDirBFile1));
            this.checkAndNotify();
            this.checkCollectionsEmpty("C");
            testDirAFile4 = this.touch(testDirAFile4);
            FileUtils.deleteDirectory((File)testDirB);
            this.checkAndNotify();
            this.checkCollectionSizes("D", 0, 0, 1, 0, 1, 1);
            FileAlterationObserverTestCase.assertTrue((String)"D testDirB", (boolean)this.listener.getDeletedDirectories().contains(testDirB));
            FileAlterationObserverTestCase.assertTrue((String)"D testDirAFile4", (boolean)this.listener.getChangedFiles().contains(testDirAFile4));
            FileAlterationObserverTestCase.assertTrue((String)"D testDirBFile1", (boolean)this.listener.getDeletedFiles().contains(testDirBFile1));
            FileUtils.deleteDirectory((File)this.testDir);
            this.checkAndNotify();
            this.checkCollectionSizes("E", 0, 0, 2, 0, 0, 3);
            FileAlterationObserverTestCase.assertTrue((String)"E testDirA", (boolean)this.listener.getDeletedDirectories().contains(testDirA));
            FileAlterationObserverTestCase.assertTrue((String)"E testDirAFile1", (boolean)this.listener.getDeletedFiles().contains(testDirAFile1));
            FileAlterationObserverTestCase.assertFalse((String)"E testDirAFile2", (boolean)this.listener.getDeletedFiles().contains(testDirAFile2));
            FileAlterationObserverTestCase.assertTrue((String)"E testDirAFile3", (boolean)this.listener.getDeletedFiles().contains(testDirAFile3));
            FileAlterationObserverTestCase.assertTrue((String)"E testDirAFile4", (boolean)this.listener.getDeletedFiles().contains(testDirAFile4));
            this.testDir.mkdir();
            this.checkAndNotify();
            this.checkCollectionsEmpty("F");
            this.checkAndNotify();
            this.checkCollectionsEmpty("G");
        }
        catch (Exception e) {
            e.printStackTrace();
            FileAlterationObserverTestCase.fail((String)("Threw " + e));
        }
    }

    public void testFileCreate() {
        try {
            this.checkAndNotify();
            this.checkCollectionsEmpty("A");
            File testDirA = new File(this.testDir, "test-dir-A");
            testDirA.mkdir();
            this.testDir = this.touch(this.testDir);
            testDirA = this.touch(testDirA);
            File testDirAFile1 = new File(testDirA, "A-file1.java");
            File testDirAFile2 = this.touch(new File(testDirA, "A-file2.java"));
            File testDirAFile3 = new File(testDirA, "A-file3.java");
            File testDirAFile4 = this.touch(new File(testDirA, "A-file4.java"));
            File testDirAFile5 = new File(testDirA, "A-file5.java");
            this.checkAndNotify();
            this.checkCollectionSizes("B", 1, 0, 0, 2, 0, 0);
            FileAlterationObserverTestCase.assertFalse((String)"B testDirAFile1", (boolean)this.listener.getCreatedFiles().contains(testDirAFile1));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile2", (boolean)this.listener.getCreatedFiles().contains(testDirAFile2));
            FileAlterationObserverTestCase.assertFalse((String)"B testDirAFile3", (boolean)this.listener.getCreatedFiles().contains(testDirAFile3));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile4", (boolean)this.listener.getCreatedFiles().contains(testDirAFile4));
            FileAlterationObserverTestCase.assertFalse((String)"B testDirAFile5", (boolean)this.listener.getCreatedFiles().contains(testDirAFile5));
            FileAlterationObserverTestCase.assertFalse((String)"B testDirAFile1 exists", (boolean)testDirAFile1.exists());
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile2 exists", (boolean)testDirAFile2.exists());
            FileAlterationObserverTestCase.assertFalse((String)"B testDirAFile3 exists", (boolean)testDirAFile3.exists());
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile4 exists", (boolean)testDirAFile4.exists());
            FileAlterationObserverTestCase.assertFalse((String)"B testDirAFile5 exists", (boolean)testDirAFile5.exists());
            this.checkAndNotify();
            this.checkCollectionsEmpty("C");
            testDirAFile1 = this.touch(testDirAFile1);
            testDirA = this.touch(testDirA);
            this.checkAndNotify();
            this.checkCollectionSizes("D", 0, 1, 0, 1, 0, 0);
            FileAlterationObserverTestCase.assertTrue((String)"D testDirAFile1 exists", (boolean)testDirAFile1.exists());
            FileAlterationObserverTestCase.assertTrue((String)"D testDirAFile1", (boolean)this.listener.getCreatedFiles().contains(testDirAFile1));
            testDirAFile3 = this.touch(testDirAFile3);
            testDirA = this.touch(testDirA);
            this.checkAndNotify();
            this.checkCollectionSizes("E", 0, 1, 0, 1, 0, 0);
            FileAlterationObserverTestCase.assertTrue((String)"E testDirAFile3 exists", (boolean)testDirAFile3.exists());
            FileAlterationObserverTestCase.assertTrue((String)"E testDirAFile3", (boolean)this.listener.getCreatedFiles().contains(testDirAFile3));
            testDirAFile5 = this.touch(testDirAFile5);
            testDirA = this.touch(testDirA);
            this.checkAndNotify();
            this.checkCollectionSizes("F", 0, 1, 0, 1, 0, 0);
            FileAlterationObserverTestCase.assertTrue((String)"F testDirAFile5 exists", (boolean)testDirAFile5.exists());
            FileAlterationObserverTestCase.assertTrue((String)"F testDirAFile5", (boolean)this.listener.getCreatedFiles().contains(testDirAFile5));
        }
        catch (Exception e) {
            FileAlterationObserverTestCase.fail((String)("Threw " + e));
        }
    }

    public void testFileUpdate() {
        try {
            this.checkAndNotify();
            this.checkCollectionsEmpty("A");
            File testDirA = new File(this.testDir, "test-dir-A");
            testDirA.mkdir();
            this.testDir = this.touch(this.testDir);
            testDirA = this.touch(testDirA);
            File testDirAFile1 = this.touch(new File(testDirA, "A-file1.java"));
            File testDirAFile2 = this.touch(new File(testDirA, "A-file2.java"));
            File testDirAFile3 = this.touch(new File(testDirA, "A-file3.java"));
            File testDirAFile4 = this.touch(new File(testDirA, "A-file4.java"));
            File testDirAFile5 = this.touch(new File(testDirA, "A-file5.java"));
            this.checkAndNotify();
            this.checkCollectionSizes("B", 1, 0, 0, 5, 0, 0);
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile1", (boolean)this.listener.getCreatedFiles().contains(testDirAFile1));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile2", (boolean)this.listener.getCreatedFiles().contains(testDirAFile2));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile3", (boolean)this.listener.getCreatedFiles().contains(testDirAFile3));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile4", (boolean)this.listener.getCreatedFiles().contains(testDirAFile4));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile5", (boolean)this.listener.getCreatedFiles().contains(testDirAFile5));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile1 exists", (boolean)testDirAFile1.exists());
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile2 exists", (boolean)testDirAFile2.exists());
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile3 exists", (boolean)testDirAFile3.exists());
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile4 exists", (boolean)testDirAFile4.exists());
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile5 exists", (boolean)testDirAFile5.exists());
            this.checkAndNotify();
            this.checkCollectionsEmpty("C");
            testDirAFile1 = this.touch(testDirAFile1);
            testDirA = this.touch(testDirA);
            this.checkAndNotify();
            this.checkCollectionSizes("D", 0, 1, 0, 0, 1, 0);
            FileAlterationObserverTestCase.assertTrue((String)"D testDirAFile1", (boolean)this.listener.getChangedFiles().contains(testDirAFile1));
            testDirAFile3 = this.touch(testDirAFile3);
            testDirA = this.touch(testDirA);
            this.checkAndNotify();
            this.checkCollectionSizes("E", 0, 1, 0, 0, 1, 0);
            FileAlterationObserverTestCase.assertTrue((String)"E testDirAFile3", (boolean)this.listener.getChangedFiles().contains(testDirAFile3));
            testDirAFile5 = this.touch(testDirAFile5);
            testDirA = this.touch(testDirA);
            this.checkAndNotify();
            this.checkCollectionSizes("F", 0, 1, 0, 0, 1, 0);
            FileAlterationObserverTestCase.assertTrue((String)"F testDirAFile5", (boolean)this.listener.getChangedFiles().contains(testDirAFile5));
        }
        catch (Exception e) {
            FileAlterationObserverTestCase.fail((String)("Threw " + e));
        }
    }

    public void testFileDelete() {
        try {
            this.checkAndNotify();
            this.checkCollectionsEmpty("A");
            File testDirA = new File(this.testDir, "test-dir-A");
            testDirA.mkdir();
            this.testDir = this.touch(this.testDir);
            testDirA = this.touch(testDirA);
            File testDirAFile1 = this.touch(new File(testDirA, "A-file1.java"));
            File testDirAFile2 = this.touch(new File(testDirA, "A-file2.java"));
            File testDirAFile3 = this.touch(new File(testDirA, "A-file3.java"));
            File testDirAFile4 = this.touch(new File(testDirA, "A-file4.java"));
            File testDirAFile5 = this.touch(new File(testDirA, "A-file5.java"));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile1 exists", (boolean)testDirAFile1.exists());
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile2 exists", (boolean)testDirAFile2.exists());
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile3 exists", (boolean)testDirAFile3.exists());
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile4 exists", (boolean)testDirAFile4.exists());
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile5 exists", (boolean)testDirAFile5.exists());
            this.checkAndNotify();
            this.checkCollectionSizes("B", 1, 0, 0, 5, 0, 0);
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile1", (boolean)this.listener.getCreatedFiles().contains(testDirAFile1));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile2", (boolean)this.listener.getCreatedFiles().contains(testDirAFile2));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile3", (boolean)this.listener.getCreatedFiles().contains(testDirAFile3));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile4", (boolean)this.listener.getCreatedFiles().contains(testDirAFile4));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile5", (boolean)this.listener.getCreatedFiles().contains(testDirAFile5));
            this.checkAndNotify();
            this.checkCollectionsEmpty("C");
            FileUtils.deleteQuietly((File)testDirAFile1);
            testDirA = this.touch(testDirA);
            this.checkAndNotify();
            this.checkCollectionSizes("D", 0, 1, 0, 0, 0, 1);
            FileAlterationObserverTestCase.assertFalse((String)"D testDirAFile1 exists", (boolean)testDirAFile1.exists());
            FileAlterationObserverTestCase.assertTrue((String)"D testDirAFile1", (boolean)this.listener.getDeletedFiles().contains(testDirAFile1));
            FileUtils.deleteQuietly((File)testDirAFile3);
            testDirA = this.touch(testDirA);
            this.checkAndNotify();
            this.checkCollectionSizes("E", 0, 1, 0, 0, 0, 1);
            FileAlterationObserverTestCase.assertFalse((String)"E testDirAFile3 exists", (boolean)testDirAFile3.exists());
            FileAlterationObserverTestCase.assertTrue((String)"E testDirAFile3", (boolean)this.listener.getDeletedFiles().contains(testDirAFile3));
            FileUtils.deleteQuietly((File)testDirAFile5);
            testDirA = this.touch(testDirA);
            this.checkAndNotify();
            this.checkCollectionSizes("F", 0, 1, 0, 0, 0, 1);
            FileAlterationObserverTestCase.assertFalse((String)"F testDirAFile5 exists", (boolean)testDirAFile5.exists());
            FileAlterationObserverTestCase.assertTrue((String)"F testDirAFile5", (boolean)this.listener.getDeletedFiles().contains(testDirAFile5));
        }
        catch (Exception e) {
            FileAlterationObserverTestCase.fail((String)("Threw " + e));
        }
    }

    public void testObserveSingleFile() {
        try {
            File testDirA = new File(this.testDir, "test-dir-A");
            File testDirAFile1 = new File(testDirA, "A-file1.java");
            testDirA.mkdir();
            IOFileFilter nameFilter = FileFilterUtils.nameFileFilter((String)testDirAFile1.getName());
            this.createObserver(testDirA, (FileFilter)nameFilter);
            this.checkAndNotify();
            this.checkCollectionsEmpty("A");
            FileAlterationObserverTestCase.assertFalse((String)"A testDirAFile1 exists", (boolean)testDirAFile1.exists());
            testDirAFile1 = this.touch(testDirAFile1);
            File testDirAFile2 = this.touch(new File(testDirA, "A-file2.txt"));
            File testDirAFile3 = this.touch(new File(testDirA, "A-file3.java"));
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile1 exists", (boolean)testDirAFile1.exists());
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile2 exists", (boolean)testDirAFile2.exists());
            FileAlterationObserverTestCase.assertTrue((String)"B testDirAFile3 exists", (boolean)testDirAFile3.exists());
            this.checkAndNotify();
            this.checkCollectionSizes("C", 0, 0, 0, 1, 0, 0);
            FileAlterationObserverTestCase.assertTrue((String)"C created", (boolean)this.listener.getCreatedFiles().contains(testDirAFile1));
            FileAlterationObserverTestCase.assertFalse((String)"C created", (boolean)this.listener.getCreatedFiles().contains(testDirAFile2));
            FileAlterationObserverTestCase.assertFalse((String)"C created", (boolean)this.listener.getCreatedFiles().contains(testDirAFile3));
            testDirAFile1 = this.touch(testDirAFile1);
            testDirAFile2 = this.touch(testDirAFile2);
            testDirAFile3 = this.touch(testDirAFile3);
            this.checkAndNotify();
            this.checkCollectionSizes("D", 0, 0, 0, 0, 1, 0);
            FileAlterationObserverTestCase.assertTrue((String)"D changed", (boolean)this.listener.getChangedFiles().contains(testDirAFile1));
            FileAlterationObserverTestCase.assertFalse((String)"D changed", (boolean)this.listener.getChangedFiles().contains(testDirAFile2));
            FileAlterationObserverTestCase.assertFalse((String)"D changed", (boolean)this.listener.getChangedFiles().contains(testDirAFile3));
            FileUtils.deleteQuietly((File)testDirAFile1);
            FileUtils.deleteQuietly((File)testDirAFile2);
            FileUtils.deleteQuietly((File)testDirAFile3);
            FileAlterationObserverTestCase.assertFalse((String)"E testDirAFile1 exists", (boolean)testDirAFile1.exists());
            FileAlterationObserverTestCase.assertFalse((String)"E testDirAFile2 exists", (boolean)testDirAFile2.exists());
            FileAlterationObserverTestCase.assertFalse((String)"E testDirAFile3 exists", (boolean)testDirAFile3.exists());
            this.checkAndNotify();
            this.checkCollectionSizes("E", 0, 0, 0, 0, 0, 1);
            FileAlterationObserverTestCase.assertTrue((String)"E deleted", (boolean)this.listener.getDeletedFiles().contains(testDirAFile1));
            FileAlterationObserverTestCase.assertFalse((String)"E deleted", (boolean)this.listener.getDeletedFiles().contains(testDirAFile2));
            FileAlterationObserverTestCase.assertFalse((String)"E deleted", (boolean)this.listener.getDeletedFiles().contains(testDirAFile3));
        }
        catch (Exception e) {
            FileAlterationObserverTestCase.fail((String)("Threw " + e));
        }
    }

    protected void checkAndNotify() throws Exception {
        this.observer.checkAndNotify();
    }
}

