/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;

public class CloseShieldOutputStreamTest
extends TestCase {
    private ByteArrayOutputStream original;
    private OutputStream shielded;
    private boolean closed;

    protected void setUp() {
        this.original = new ByteArrayOutputStream(){

            public void close() {
                CloseShieldOutputStreamTest.this.closed = true;
            }
        };
        this.shielded = new CloseShieldOutputStream((OutputStream)this.original);
        this.closed = false;
    }

    public void testClose() throws IOException {
        this.shielded.close();
        CloseShieldOutputStreamTest.assertFalse((String)"closed", (boolean)this.closed);
        try {
            this.shielded.write(120);
            CloseShieldOutputStreamTest.fail((String)"write(b)");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.original.write(121);
        CloseShieldOutputStreamTest.assertEquals((int)1, (int)this.original.size());
        CloseShieldOutputStreamTest.assertEquals((int)121, (int)this.original.toByteArray()[0]);
    }
}

