/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Writer;
import junit.framework.TestCase;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.io.output.ProxyWriter;
import org.apache.commons.io.output.StringBuilderWriter;

public class ProxyWriterTest
extends TestCase {
    public ProxyWriterTest(String name) {
        super(name);
    }

    public void testAppendCharSequence() {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        try {
            proxy.append((CharSequence)"ABC");
        }
        catch (Exception e) {
            ProxyWriterTest.fail((String)("Appending CharSequence threw " + e));
        }
        ProxyWriterTest.assertEquals((String)"ABC", (String)writer.toString());
    }

    public void testWriteString() {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        try {
            proxy.write("ABC");
        }
        catch (Exception e) {
            ProxyWriterTest.fail((String)("Writing String threw " + e));
        }
        ProxyWriterTest.assertEquals((String)"ABC", (String)writer.toString());
    }

    public void testWriteStringPartial() {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        try {
            proxy.write("ABC", 1, 2);
        }
        catch (Exception e) {
            ProxyWriterTest.fail((String)("Writing String threw " + e));
        }
        ProxyWriterTest.assertEquals((String)"BC", (String)writer.toString());
    }

    public void testWriteCharArray() {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        try {
            proxy.write(new char[]{'A', 'B', 'C'});
        }
        catch (Exception e) {
            ProxyWriterTest.fail((String)("Writing char[] threw " + e));
        }
        ProxyWriterTest.assertEquals((String)"ABC", (String)writer.toString());
    }

    public void testWriteCharArrayPartial() {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        try {
            proxy.write(new char[]{'A', 'B', 'C'}, 1, 2);
        }
        catch (Exception e) {
            ProxyWriterTest.fail((String)("Writing char[] threw " + e));
        }
        ProxyWriterTest.assertEquals((String)"BC", (String)writer.toString());
    }

    public void testNullString() {
        ProxyWriter proxy = new ProxyWriter((Writer)new NullWriter());
        try {
            proxy.write((String)null);
        }
        catch (Exception e) {
            ProxyWriterTest.fail((String)("Writing null String threw " + e));
        }
        try {
            proxy.write((String)null, 0, 0);
        }
        catch (Exception e) {
            ProxyWriterTest.fail((String)("Writing null String threw " + e));
        }
    }

    public void testNullCharArray() {
        ProxyWriter proxy = new ProxyWriter((Writer)new NullWriter());
        try {
            proxy.write((char[])null);
        }
        catch (Exception e) {
            ProxyWriterTest.fail((String)("Writing null char[] threw " + e));
        }
        try {
            proxy.write((char[])null, 0, 0);
        }
        catch (Exception e) {
            ProxyWriterTest.fail((String)("Writing null char[] threw " + e));
        }
    }

    public void testNullCharSequencec() {
        ProxyWriter proxy = new ProxyWriter((Writer)new NullWriter());
        try {
            proxy.append((CharSequence)null);
        }
        catch (Exception e) {
            ProxyWriterTest.fail((String)("Appending null CharSequence threw " + e));
        }
    }
}

