/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class FileUtilsCleanDirectoryTestCase
extends FileBasedTestCase {
    final File top = this.getLocalTestDirectory();

    public FileUtilsCleanDirectoryTestCase(String name) {
        super(name);
    }

    private File getLocalTestDirectory() {
        return new File(FileUtilsCleanDirectoryTestCase.getTestDirectory(), "list-files");
    }

    protected void setUp() throws Exception {
        this.top.mkdirs();
    }

    protected void tearDown() throws Exception {
        this.chmod(this.top, 775, true);
        FileUtils.deleteDirectory((File)this.top);
    }

    public void testCleanEmpty() throws Exception {
        FileUtilsCleanDirectoryTestCase.assertEquals((int)0, (int)this.top.list().length);
        FileUtils.cleanDirectory((File)this.top);
        FileUtilsCleanDirectoryTestCase.assertEquals((int)0, (int)this.top.list().length);
    }

    public void testDeletesRegular() throws Exception {
        FileUtils.touch((File)new File(this.top, "regular"));
        FileUtils.touch((File)new File(this.top, ".hidden"));
        FileUtilsCleanDirectoryTestCase.assertEquals((int)2, (int)this.top.list().length);
        FileUtils.cleanDirectory((File)this.top);
        FileUtilsCleanDirectoryTestCase.assertEquals((int)0, (int)this.top.list().length);
    }

    public void testDeletesNested() throws Exception {
        File nested = new File(this.top, "nested");
        FileUtilsCleanDirectoryTestCase.assertTrue((boolean)nested.mkdirs());
        FileUtils.touch((File)new File(nested, "file"));
        FileUtilsCleanDirectoryTestCase.assertEquals((int)1, (int)this.top.list().length);
        FileUtils.cleanDirectory((File)this.top);
        FileUtilsCleanDirectoryTestCase.assertEquals((int)0, (int)this.top.list().length);
    }

    public void testThrowsOnNullList() throws Exception {
        if (System.getProperty("os.name").startsWith("Win") || !this.chmod(this.top, 0, false)) {
            return;
        }
        try {
            FileUtils.cleanDirectory((File)this.top);
            FileUtilsCleanDirectoryTestCase.fail((String)"expected IOException");
        }
        catch (IOException e) {
            FileUtilsCleanDirectoryTestCase.assertEquals((String)("Failed to list contents of " + this.top.getAbsolutePath()), (String)e.getMessage());
        }
    }

    public void testThrowsOnCannotDeleteFile() throws Exception {
        File file = new File(this.top, "restricted");
        FileUtils.touch((File)file);
        if (System.getProperty("os.name").startsWith("Win") || !this.chmod(this.top, 500, false)) {
            return;
        }
        try {
            FileUtils.cleanDirectory((File)this.top);
            FileUtilsCleanDirectoryTestCase.fail((String)"expected IOException");
        }
        catch (IOException e) {
            FileUtilsCleanDirectoryTestCase.assertEquals((String)("Unable to delete file: " + file.getAbsolutePath()), (String)e.getMessage());
        }
    }

    private boolean chmod(File file, int mode, boolean recurse) throws InterruptedException {
        Process proc;
        ArrayList<String> args = new ArrayList<String>();
        args.add("chmod");
        if (recurse) {
            args.add("-R");
        }
        args.add(Integer.toString(mode));
        args.add(file.getAbsolutePath());
        try {
            proc = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        }
        catch (IOException e) {
            return false;
        }
        int result = proc.waitFor();
        return result == 0;
    }
}

