/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import junit.framework.TestCase;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.io.input.ProxyReader;

public class ProxyReaderTest
extends TestCase {
    public ProxyReaderTest(String name) {
        super(name);
    }

    public void testNullCharArray() {
        ProxyReaderImpl proxy = new ProxyReaderImpl((Reader)((Object)new CustomNullReader(0)));
        try {
            proxy.read(null);
        }
        catch (Exception e) {
            ProxyReaderTest.fail((String)("Writing null String threw " + e));
        }
        try {
            proxy.read(null, 0, 0);
        }
        catch (Exception e) {
            ProxyReaderTest.fail((String)("Writing null String threw " + e));
        }
    }

    public void testNullCharBuffer() {
        ProxyReaderImpl proxy = new ProxyReaderImpl((Reader)((Object)new CustomNullReader(0)));
        try {
            proxy.read(null);
        }
        catch (Exception e) {
            ProxyReaderTest.fail((String)("Writing null String threw " + e));
        }
    }

    private static class CustomNullReader
    extends NullReader {
        CustomNullReader(int len) {
            super((long)len);
        }

        public int read(char[] chars) throws IOException {
            return chars == null ? 0 : super.read(chars);
        }

        public int read(CharBuffer target) throws IOException {
            return target == null ? 0 : super.read(target);
        }
    }

    private static class ProxyReaderImpl
    extends ProxyReader {
        ProxyReaderImpl(Reader proxy) {
            super(proxy);
        }
    }
}

