/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.input.TeeInputStream;

public class TeeInputStreamTest
extends TestCase {
    private final String ASCII = "US-ASCII";
    private InputStream tee;
    private ByteArrayOutputStream output;

    protected void setUp() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream("abc".getBytes("US-ASCII"));
        this.output = new ByteArrayOutputStream();
        this.tee = new TeeInputStream((InputStream)input, (OutputStream)this.output);
    }

    public void testReadNothing() throws Exception {
        TeeInputStreamTest.assertEquals((String)"", (String)new String(this.output.toString("US-ASCII")));
    }

    public void testReadOneByte() throws Exception {
        TeeInputStreamTest.assertEquals((int)97, (int)this.tee.read());
        TeeInputStreamTest.assertEquals((String)"a", (String)new String(this.output.toString("US-ASCII")));
    }

    public void testReadEverything() throws Exception {
        TeeInputStreamTest.assertEquals((int)97, (int)this.tee.read());
        TeeInputStreamTest.assertEquals((int)98, (int)this.tee.read());
        TeeInputStreamTest.assertEquals((int)99, (int)this.tee.read());
        TeeInputStreamTest.assertEquals((int)-1, (int)this.tee.read());
        TeeInputStreamTest.assertEquals((String)"abc", (String)new String(this.output.toString("US-ASCII")));
    }

    public void testReadToArray() throws Exception {
        byte[] buffer = new byte[8];
        TeeInputStreamTest.assertEquals((int)3, (int)this.tee.read(buffer));
        TeeInputStreamTest.assertEquals((int)97, (int)buffer[0]);
        TeeInputStreamTest.assertEquals((int)98, (int)buffer[1]);
        TeeInputStreamTest.assertEquals((int)99, (int)buffer[2]);
        TeeInputStreamTest.assertEquals((int)-1, (int)this.tee.read(buffer));
        TeeInputStreamTest.assertEquals((String)"abc", (String)new String(this.output.toString("US-ASCII")));
    }

    public void testReadToArrayWithOffset() throws Exception {
        byte[] buffer = new byte[8];
        TeeInputStreamTest.assertEquals((int)3, (int)this.tee.read(buffer, 4, 4));
        TeeInputStreamTest.assertEquals((int)97, (int)buffer[4]);
        TeeInputStreamTest.assertEquals((int)98, (int)buffer[5]);
        TeeInputStreamTest.assertEquals((int)99, (int)buffer[6]);
        TeeInputStreamTest.assertEquals((int)-1, (int)this.tee.read(buffer, 4, 4));
        TeeInputStreamTest.assertEquals((String)"abc", (String)new String(this.output.toString("US-ASCII")));
    }

    public void testSkip() throws Exception {
        TeeInputStreamTest.assertEquals((int)97, (int)this.tee.read());
        TeeInputStreamTest.assertEquals((long)1L, (long)this.tee.skip(1L));
        TeeInputStreamTest.assertEquals((int)99, (int)this.tee.read());
        TeeInputStreamTest.assertEquals((int)-1, (int)this.tee.read());
        TeeInputStreamTest.assertEquals((String)"ac", (String)new String(this.output.toString("US-ASCII")));
    }

    public void testMarkReset() throws Exception {
        TeeInputStreamTest.assertEquals((int)97, (int)this.tee.read());
        this.tee.mark(1);
        TeeInputStreamTest.assertEquals((int)98, (int)this.tee.read());
        this.tee.reset();
        TeeInputStreamTest.assertEquals((int)98, (int)this.tee.read());
        TeeInputStreamTest.assertEquals((int)99, (int)this.tee.read());
        TeeInputStreamTest.assertEquals((int)-1, (int)this.tee.read());
        TeeInputStreamTest.assertEquals((String)"abbc", (String)new String(this.output.toString("US-ASCII")));
    }
}

