/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.FileFilter;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.CollectionFileListener;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public abstract class AbstractMonitorTestCase
extends TestCase {
    protected FileAlterationObserver observer;
    protected CollectionFileListener listener;
    protected String testDirName = null;
    protected File testDir;
    protected long pauseTime = 100L;

    public AbstractMonitorTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.testDir = new File(new File("."), this.testDirName);
        if (this.testDir.exists()) {
            FileUtils.cleanDirectory((File)this.testDir);
        } else {
            this.testDir.mkdir();
        }
        IOFileFilter files = FileFilterUtils.fileFileFilter();
        IOFileFilter javaSuffix = FileFilterUtils.suffixFileFilter((String)".java");
        IOFileFilter fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{files, javaSuffix});
        IOFileFilter directories = FileFilterUtils.directoryFileFilter();
        IOFileFilter visible = HiddenFileFilter.VISIBLE;
        IOFileFilter dirFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{directories, visible});
        IOFileFilter filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{dirFilter, fileFilter});
        this.createObserver(this.testDir, (FileFilter)filter);
    }

    protected void createObserver(File file, FileFilter fileFilter) {
        this.observer = new FileAlterationObserver(file, fileFilter);
        this.observer.addListener((FileAlterationListener)this.listener);
        this.observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor());
        try {
            this.observer.initialize();
        }
        catch (Exception e) {
            AbstractMonitorTestCase.fail((String)("Observer init() threw " + e));
        }
    }

    protected void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testDir);
    }

    protected void checkCollectionsEmpty(String label) {
        this.checkCollectionSizes("EMPTY-" + label, 0, 0, 0, 0, 0, 0);
    }

    protected void checkCollectionSizes(String label, int dirCreate, int dirChange, int dirDelete, int fileCreate, int fileChange, int fileDelete) {
        label = label + "[" + this.listener.getCreatedDirectories().size() + " " + this.listener.getChangedDirectories().size() + " " + this.listener.getDeletedDirectories().size() + " " + this.listener.getCreatedFiles().size() + " " + this.listener.getChangedFiles().size() + " " + this.listener.getDeletedFiles().size() + "]";
        AbstractMonitorTestCase.assertEquals((String)(label + ": No. of directories created"), (int)dirCreate, (int)this.listener.getCreatedDirectories().size());
        AbstractMonitorTestCase.assertEquals((String)(label + ": No. of directories changed"), (int)dirChange, (int)this.listener.getChangedDirectories().size());
        AbstractMonitorTestCase.assertEquals((String)(label + ": No. of directories deleted"), (int)dirDelete, (int)this.listener.getDeletedDirectories().size());
        AbstractMonitorTestCase.assertEquals((String)(label + ": No. of files created"), (int)fileCreate, (int)this.listener.getCreatedFiles().size());
        AbstractMonitorTestCase.assertEquals((String)(label + ": No. of files changed"), (int)fileChange, (int)this.listener.getChangedFiles().size());
        AbstractMonitorTestCase.assertEquals((String)(label + ": No. of files deleted"), (int)fileDelete, (int)this.listener.getDeletedFiles().size());
    }

    protected File touch(File file) {
        long lastModified = file.exists() ? file.lastModified() : 0L;
        try {
            FileUtils.touch((File)file);
            file = new File(file.getParent(), file.getName());
            while (lastModified == file.lastModified()) {
                this.sleepHandleInterruped(this.pauseTime);
                FileUtils.touch((File)file);
                file = new File(file.getParent(), file.getName());
            }
        }
        catch (Exception e) {
            AbstractMonitorTestCase.fail((String)("Touching " + file + ": " + e));
        }
        this.sleepHandleInterruped(this.pauseTime);
        return file;
    }

    protected void sleepHandleInterruped(long timeInMilliseconds) {
        try {
            Thread.sleep(timeInMilliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

