/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileUtilsCleanDirectoryTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File top;

    @Before
    public void setUp() throws Exception {
        this.top = this.temporaryFolder.getRoot();
    }

    @Test
    public void testCleanEmpty() throws Exception {
        Assert.assertEquals((long)0L, (long)this.top.list().length);
        FileUtils.cleanDirectory((File)this.top);
        Assert.assertEquals((long)0L, (long)this.top.list().length);
    }

    @Test
    public void testDeletesRegular() throws Exception {
        FileUtils.touch((File)new File(this.top, "regular"));
        FileUtils.touch((File)new File(this.top, ".hidden"));
        Assert.assertEquals((long)2L, (long)this.top.list().length);
        FileUtils.cleanDirectory((File)this.top);
        Assert.assertEquals((long)0L, (long)this.top.list().length);
    }

    @Test
    public void testDeletesNested() throws Exception {
        File nested = new File(this.top, "nested");
        Assert.assertTrue((boolean)nested.mkdirs());
        FileUtils.touch((File)new File(nested, "file"));
        Assert.assertEquals((long)1L, (long)this.top.list().length);
        FileUtils.cleanDirectory((File)this.top);
        Assert.assertEquals((long)0L, (long)this.top.list().length);
    }

    @Test
    public void testThrowsOnNullList() throws Exception {
        if (System.getProperty("os.name").startsWith("Win") || !this.chmod(this.top, 0, false)) {
            return;
        }
        try {
            FileUtils.cleanDirectory((File)this.top);
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)("Failed to list contents of " + this.top.getAbsolutePath()), (Object)e.getMessage());
        }
    }

    @Test
    public void testThrowsOnCannotDeleteFile() throws Exception {
        File file = new File(this.top, "restricted");
        FileUtils.touch((File)file);
        if (System.getProperty("os.name").startsWith("Win") || !this.chmod(this.top, 500, false)) {
            return;
        }
        try {
            FileUtils.cleanDirectory((File)this.top);
            Assert.fail((String)"expected IOException");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)("Unable to delete file: " + file.getAbsolutePath()), (Object)e.getMessage());
        }
    }

    private boolean chmod(File file, int mode, boolean recurse) throws InterruptedException {
        Process proc;
        ArrayList<String> args = new ArrayList<String>();
        args.add("chmod");
        if (recurse) {
            args.add("-R");
        }
        args.add(Integer.toString(mode));
        args.add(file.getAbsolutePath());
        try {
            proc = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        }
        catch (IOException e) {
            return false;
        }
        int result = proc.waitFor();
        return result == 0;
    }
}

