/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.CollectionFileListener;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractMonitorTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    protected FileAlterationObserver observer;
    protected CollectionFileListener listener;
    protected File testDir;
    protected long pauseTime = 100L;

    @Before
    public void setUp() throws Exception {
        this.testDir = this.temporaryFolder.getRoot();
        IOFileFilter files = FileFilterUtils.fileFileFilter();
        IOFileFilter javaSuffix = FileFilterUtils.suffixFileFilter((String)".java");
        IOFileFilter fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{files, javaSuffix});
        IOFileFilter directories = FileFilterUtils.directoryFileFilter();
        IOFileFilter visible = HiddenFileFilter.VISIBLE;
        IOFileFilter dirFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{directories, visible});
        IOFileFilter filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{dirFilter, fileFilter});
        this.createObserver(this.testDir, (FileFilter)filter);
    }

    protected void createObserver(File file, FileFilter fileFilter) {
        this.observer = new FileAlterationObserver(file, fileFilter);
        this.observer.addListener((FileAlterationListener)this.listener);
        this.observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor());
        try {
            this.observer.initialize();
        }
        catch (Exception e) {
            Assert.fail((String)("Observer init() threw " + e));
        }
    }

    protected void checkCollectionsEmpty(String label) {
        this.checkCollectionSizes("EMPTY-" + label, 0, 0, 0, 0, 0, 0);
    }

    protected void checkCollectionSizes(String label, int dirCreate, int dirChange, int dirDelete, int fileCreate, int fileChange, int fileDelete) {
        label = label + "[" + this.listener.getCreatedDirectories().size() + " " + this.listener.getChangedDirectories().size() + " " + this.listener.getDeletedDirectories().size() + " " + this.listener.getCreatedFiles().size() + " " + this.listener.getChangedFiles().size() + " " + this.listener.getDeletedFiles().size() + "]";
        Assert.assertEquals((String)(label + ": No. of directories created"), (long)dirCreate, (long)this.listener.getCreatedDirectories().size());
        Assert.assertEquals((String)(label + ": No. of directories changed"), (long)dirChange, (long)this.listener.getChangedDirectories().size());
        Assert.assertEquals((String)(label + ": No. of directories deleted"), (long)dirDelete, (long)this.listener.getDeletedDirectories().size());
        Assert.assertEquals((String)(label + ": No. of files created"), (long)fileCreate, (long)this.listener.getCreatedFiles().size());
        Assert.assertEquals((String)(label + ": No. of files changed"), (long)fileChange, (long)this.listener.getChangedFiles().size());
        Assert.assertEquals((String)(label + ": No. of files deleted"), (long)fileDelete, (long)this.listener.getDeletedFiles().size());
    }

    protected File touch(File file) {
        long lastModified = file.exists() ? file.lastModified() : 0L;
        try {
            FileUtils.touch((File)file);
            file = new File(file.getParent(), file.getName());
            while (lastModified == file.lastModified()) {
                TestUtils.sleepQuietly(this.pauseTime);
                FileUtils.touch((File)file);
                file = new File(file.getParent(), file.getName());
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Touching " + file + ": " + e));
        }
        TestUtils.sleepQuietly(this.pauseTime);
        return file;
    }
}

