/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.testtools;

import java.io.IOException;
import java.io.OutputStream;
import junit.framework.AssertionFailedError;
import org.apache.commons.io.output.ProxyOutputStream;

public class YellOnFlushAndCloseOutputStream
extends ProxyOutputStream {
    private boolean yellForFlush;
    private boolean yellForClose;

    public YellOnFlushAndCloseOutputStream(OutputStream proxy, boolean yellForFlush, boolean yellForClose) {
        super(proxy);
        this.yellForFlush = yellForFlush;
        this.yellForClose = yellForClose;
    }

    public void flush() throws IOException {
        if (this.yellForFlush) {
            throw new AssertionFailedError("flush() was called on OutputStream");
        }
        super.flush();
    }

    public void close() throws IOException {
        if (this.yellForClose) {
            throw new AssertionFailedError("close() was called on OutputStream");
        }
        super.close();
    }

    public void off() {
        this.yellForFlush = false;
        this.yellForClose = false;
    }
}

