/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FilenameUtilsTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String SEP = "" + File.separatorChar;
    private static final boolean WINDOWS = File.separatorChar == '\\';
    private File testFile1;
    private File testFile2;
    private int testFile1Size;
    private int testFile2Size;

    @Before
    public void setUp() throws Exception {
        this.testFile1 = this.temporaryFolder.newFile("file1-test.txt");
        this.testFile2 = this.temporaryFolder.newFile("file1a-test.txt");
        this.testFile1Size = (int)this.testFile1.length();
        this.testFile2Size = (int)this.testFile2.length();
        if (!this.testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile1 + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output3 = new BufferedOutputStream(new FileOutputStream(this.testFile1));){
            TestUtils.generateTestData(output3, this.testFile1Size);
        }
        if (!this.testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile2 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output2 = new BufferedOutputStream(new FileOutputStream(this.testFile2));){
            TestUtils.generateTestData(output2, this.testFile2Size);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        if (!this.testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile1 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(this.testFile1));){
            TestUtils.generateTestData(output1, this.testFile1Size);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        if (!this.testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile2 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.testFile2));){
            TestUtils.generateTestData(output, this.testFile2Size);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testNormalize() throws Exception {
        Assert.assertEquals(null, (Object)FilenameUtils.normalize(null));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)":"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"1:\\a\\b\\c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"1:"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"1:a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\\\a\\b\\c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"\\\\a"));
        Assert.assertEquals((Object)("a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"a\\b/c.txt"));
        Assert.assertEquals((Object)("" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\a\\b/c.txt"));
        Assert.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"C:\\a\\b/c.txt"));
        Assert.assertEquals((Object)("" + SEP + "" + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\\\\server\\a\\b/c.txt"));
        Assert.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"~\\a\\b/c.txt"));
        Assert.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"~user\\a\\b/c.txt"));
        Assert.assertEquals((Object)("a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"a/b/../c"));
        Assert.assertEquals((Object)"c", (Object)FilenameUtils.normalize((String)"a/b/../../c"));
        Assert.assertEquals((Object)("c" + SEP), (Object)FilenameUtils.normalize((String)"a/b/../../c/"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"a/b/../../../c"));
        Assert.assertEquals((Object)("a" + SEP), (Object)FilenameUtils.normalize((String)"a/b/.."));
        Assert.assertEquals((Object)("a" + SEP), (Object)FilenameUtils.normalize((String)"a/b/../"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.normalize((String)"a/b/../.."));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.normalize((String)"a/b/../../"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"a/b/../../.."));
        Assert.assertEquals((Object)("a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"a/b/../c/../d"));
        Assert.assertEquals((Object)("a" + SEP + "d" + SEP), (Object)FilenameUtils.normalize((String)"a/b/../c/../d/"));
        Assert.assertEquals((Object)("a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"a/b//d"));
        Assert.assertEquals((Object)("a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"a/b/././."));
        Assert.assertEquals((Object)("a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"a/b/./././"));
        Assert.assertEquals((Object)("a" + SEP), (Object)FilenameUtils.normalize((String)"./a/"));
        Assert.assertEquals((Object)"a", (Object)FilenameUtils.normalize((String)"./a"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.normalize((String)"./"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.normalize((String)"."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)".."));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.normalize((String)""));
        Assert.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalize((String)"/a"));
        Assert.assertEquals((Object)(SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"/a/"));
        Assert.assertEquals((Object)(SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"/a/b/../c"));
        Assert.assertEquals((Object)(SEP + "c"), (Object)FilenameUtils.normalize((String)"/a/b/../../c"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"/a/b/../../../c"));
        Assert.assertEquals((Object)(SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"/a/b/.."));
        Assert.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalize((String)"/a/b/../.."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"/a/b/../../.."));
        Assert.assertEquals((Object)(SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"/a/b/../c/../d"));
        Assert.assertEquals((Object)(SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"/a/b//d"));
        Assert.assertEquals((Object)(SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"/a/b/././."));
        Assert.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalize((String)"/./a"));
        Assert.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalize((String)"/./"));
        Assert.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalize((String)"/."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"/../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"/.."));
        Assert.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalize((String)"/"));
        Assert.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalize((String)"~/a"));
        Assert.assertEquals((Object)("~" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"~/a/"));
        Assert.assertEquals((Object)("~" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"~/a/b/../c"));
        Assert.assertEquals((Object)("~" + SEP + "c"), (Object)FilenameUtils.normalize((String)"~/a/b/../../c"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"~/a/b/../../../c"));
        Assert.assertEquals((Object)("~" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"~/a/b/.."));
        Assert.assertEquals((Object)("~" + SEP + ""), (Object)FilenameUtils.normalize((String)"~/a/b/../.."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"~/a/b/../../.."));
        Assert.assertEquals((Object)("~" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"~/a/b/../c/../d"));
        Assert.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"~/a/b//d"));
        Assert.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"~/a/b/././."));
        Assert.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalize((String)"~/./a"));
        Assert.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalize((String)"~/./"));
        Assert.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalize((String)"~/."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"~/../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"~/.."));
        Assert.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalize((String)"~/"));
        Assert.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalize((String)"~"));
        Assert.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalize((String)"~user/a"));
        Assert.assertEquals((Object)("~user" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"~user/a/"));
        Assert.assertEquals((Object)("~user" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"~user/a/b/../c"));
        Assert.assertEquals((Object)("~user" + SEP + "c"), (Object)FilenameUtils.normalize((String)"~user/a/b/../../c"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"~user/a/b/../../../c"));
        Assert.assertEquals((Object)("~user" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"~user/a/b/.."));
        Assert.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalize((String)"~user/a/b/../.."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"~user/a/b/../../.."));
        Assert.assertEquals((Object)("~user" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"~user/a/b/../c/../d"));
        Assert.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"~user/a/b//d"));
        Assert.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"~user/a/b/././."));
        Assert.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalize((String)"~user/./a"));
        Assert.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalize((String)"~user/./"));
        Assert.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalize((String)"~user/."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"~user/../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"~user/.."));
        Assert.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.normalize((String)"~user/"));
        Assert.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.normalize((String)"~user"));
        Assert.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalize((String)"C:/a"));
        Assert.assertEquals((Object)("C:" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"C:/a/"));
        Assert.assertEquals((Object)("C:" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"C:/a/b/../c"));
        Assert.assertEquals((Object)("C:" + SEP + "c"), (Object)FilenameUtils.normalize((String)"C:/a/b/../../c"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:/a/b/../../../c"));
        Assert.assertEquals((Object)("C:" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"C:/a/b/.."));
        Assert.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalize((String)"C:/a/b/../.."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:/a/b/../../.."));
        Assert.assertEquals((Object)("C:" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"C:/a/b/../c/../d"));
        Assert.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"C:/a/b//d"));
        Assert.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"C:/a/b/././."));
        Assert.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalize((String)"C:/./a"));
        Assert.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalize((String)"C:/./"));
        Assert.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalize((String)"C:/."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:/../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:/.."));
        Assert.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalize((String)"C:/"));
        Assert.assertEquals((Object)"C:a", (Object)FilenameUtils.normalize((String)"C:a"));
        Assert.assertEquals((Object)("C:a" + SEP), (Object)FilenameUtils.normalize((String)"C:a/"));
        Assert.assertEquals((Object)("C:a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"C:a/b/../c"));
        Assert.assertEquals((Object)"C:c", (Object)FilenameUtils.normalize((String)"C:a/b/../../c"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:a/b/../../../c"));
        Assert.assertEquals((Object)("C:a" + SEP), (Object)FilenameUtils.normalize((String)"C:a/b/.."));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.normalize((String)"C:a/b/../.."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:a/b/../../.."));
        Assert.assertEquals((Object)("C:a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"C:a/b/../c/../d"));
        Assert.assertEquals((Object)("C:a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"C:a/b//d"));
        Assert.assertEquals((Object)("C:a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"C:a/b/././."));
        Assert.assertEquals((Object)"C:a", (Object)FilenameUtils.normalize((String)"C:./a"));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.normalize((String)"C:./"));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.normalize((String)"C:."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"C:.."));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.normalize((String)"C:"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalize((String)"//server/a"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"//server/a/"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalize((String)"//server/a/b/../c"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "c"), (Object)FilenameUtils.normalize((String)"//server/a/b/../../c"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"//server/a/b/../../../c"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP), (Object)FilenameUtils.normalize((String)"//server/a/b/.."));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalize((String)"//server/a/b/../.."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"//server/a/b/../../.."));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalize((String)"//server/a/b/../c/../d"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalize((String)"//server/a/b//d"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "b" + SEP), (Object)FilenameUtils.normalize((String)"//server/a/b/././."));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalize((String)"//server/./a"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalize((String)"//server/./"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalize((String)"//server/."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"//server/../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalize((String)"//server/.."));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalize((String)"//server/"));
    }

    @Test
    public void testNormalize_with_nullbytes() throws Exception {
        try {
            Assert.assertEquals((Object)("a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"a\\b/c\u0000.txt"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Assert.assertEquals((Object)("a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalize((String)"\u0000a\\b/c.txt"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNormalizeUnixWin() throws Exception {
        Assert.assertEquals((Object)"/a/c/", (Object)FilenameUtils.normalize((String)"/a/b/../c/", (boolean)true));
        Assert.assertEquals((Object)"/a/c/", (Object)FilenameUtils.normalize((String)"\\a\\b\\..\\c\\", (boolean)true));
        Assert.assertEquals((Object)"\\a\\c\\", (Object)FilenameUtils.normalize((String)"/a/b/../c/", (boolean)false));
        Assert.assertEquals((Object)"\\a\\c\\", (Object)FilenameUtils.normalize((String)"\\a\\b\\..\\c\\", (boolean)false));
    }

    @Test
    public void testNormalizeNoEndSeparator() throws Exception {
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator(null));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)":"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"1:\\a\\b\\c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"1:"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"1:a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"\\\\\\a\\b\\c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"\\\\a"));
        Assert.assertEquals((Object)("a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a\\b/c.txt"));
        Assert.assertEquals((Object)("" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"\\a\\b/c.txt"));
        Assert.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:\\a\\b/c.txt"));
        Assert.assertEquals((Object)("" + SEP + "" + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"\\\\server\\a\\b/c.txt"));
        Assert.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~\\a\\b/c.txt"));
        Assert.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP + "c.txt"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user\\a\\b/c.txt"));
        Assert.assertEquals((Object)("a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../c"));
        Assert.assertEquals((Object)"c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../c"));
        Assert.assertEquals((Object)"c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../c/"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../../c"));
        Assert.assertEquals((Object)"a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/.."));
        Assert.assertEquals((Object)"a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../.."));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../../.."));
        Assert.assertEquals((Object)("a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../c/../d"));
        Assert.assertEquals((Object)("a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/../c/../d/"));
        Assert.assertEquals((Object)("a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b//d"));
        Assert.assertEquals((Object)("a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/././."));
        Assert.assertEquals((Object)("a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"a/b/./././"));
        Assert.assertEquals((Object)"a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"./a/"));
        Assert.assertEquals((Object)"a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"./a"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator((String)"./"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator((String)"."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)".."));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.normalizeNoEndSeparator((String)""));
        Assert.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a"));
        Assert.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/"));
        Assert.assertEquals((Object)(SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../c"));
        Assert.assertEquals((Object)(SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../../c"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../../../c"));
        Assert.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/.."));
        Assert.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../.."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../../.."));
        Assert.assertEquals((Object)(SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../c/../d"));
        Assert.assertEquals((Object)(SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b//d"));
        Assert.assertEquals((Object)(SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/././."));
        Assert.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/./a"));
        Assert.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/./"));
        Assert.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"/../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"/.."));
        Assert.assertEquals((Object)(SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"/"));
        Assert.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a"));
        Assert.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/"));
        Assert.assertEquals((Object)("~" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../c"));
        Assert.assertEquals((Object)("~" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../../c"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../../../c"));
        Assert.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/.."));
        Assert.assertEquals((Object)("~" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../.."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../../.."));
        Assert.assertEquals((Object)("~" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/../c/../d"));
        Assert.assertEquals((Object)("~" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b//d"));
        Assert.assertEquals((Object)("~" + SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/a/b/././."));
        Assert.assertEquals((Object)("~" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/./a"));
        Assert.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/./"));
        Assert.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/.."));
        Assert.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~/"));
        Assert.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~"));
        Assert.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a"));
        Assert.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/"));
        Assert.assertEquals((Object)("~user" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../c"));
        Assert.assertEquals((Object)("~user" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../../c"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../../../c"));
        Assert.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/.."));
        Assert.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../.."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../../.."));
        Assert.assertEquals((Object)("~user" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/../c/../d"));
        Assert.assertEquals((Object)("~user" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b//d"));
        Assert.assertEquals((Object)("~user" + SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/a/b/././."));
        Assert.assertEquals((Object)("~user" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/./a"));
        Assert.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/./"));
        Assert.assertEquals((Object)("~user" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/.."));
        Assert.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user/"));
        Assert.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.normalizeNoEndSeparator((String)"~user"));
        Assert.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a"));
        Assert.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/"));
        Assert.assertEquals((Object)("C:" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../c"));
        Assert.assertEquals((Object)("C:" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../../c"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../../../c"));
        Assert.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/.."));
        Assert.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../.."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../../.."));
        Assert.assertEquals((Object)("C:" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/../c/../d"));
        Assert.assertEquals((Object)("C:" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b//d"));
        Assert.assertEquals((Object)("C:" + SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/a/b/././."));
        Assert.assertEquals((Object)("C:" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/./a"));
        Assert.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/./"));
        Assert.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/.."));
        Assert.assertEquals((Object)("C:" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:/"));
        Assert.assertEquals((Object)"C:a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a"));
        Assert.assertEquals((Object)"C:a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/"));
        Assert.assertEquals((Object)("C:a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../c"));
        Assert.assertEquals((Object)"C:c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../../c"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../../../c"));
        Assert.assertEquals((Object)"C:a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/.."));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../.."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../../.."));
        Assert.assertEquals((Object)("C:a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/../c/../d"));
        Assert.assertEquals((Object)("C:a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b//d"));
        Assert.assertEquals((Object)("C:a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:a/b/././."));
        Assert.assertEquals((Object)"C:a", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:./a"));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:./"));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:.."));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.normalizeNoEndSeparator((String)"C:"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../c"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "c"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../../c"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../../../c"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/.."));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../.."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../../.."));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/../c/../d"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "b" + SEP + "d"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b//d"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a" + SEP + "b"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/a/b/././."));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + "a"), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/./a"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/./"));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/."));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/../a"));
        Assert.assertEquals(null, (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/.."));
        Assert.assertEquals((Object)(SEP + SEP + "server" + SEP + ""), (Object)FilenameUtils.normalizeNoEndSeparator((String)"//server/"));
    }

    @Test
    public void testNormalizeNoEndSeparatorUnixWin() throws Exception {
        Assert.assertEquals((Object)"/a/c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../c/", (boolean)true));
        Assert.assertEquals((Object)"/a/c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"\\a\\b\\..\\c\\", (boolean)true));
        Assert.assertEquals((Object)"\\a\\c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"/a/b/../c/", (boolean)false));
        Assert.assertEquals((Object)"\\a\\c", (Object)FilenameUtils.normalizeNoEndSeparator((String)"\\a\\b\\..\\c\\", (boolean)false));
    }

    @Test
    public void testConcat() {
        Assert.assertEquals(null, (Object)FilenameUtils.concat((String)"", null));
        Assert.assertEquals(null, (Object)FilenameUtils.concat(null, null));
        Assert.assertEquals(null, (Object)FilenameUtils.concat(null, (String)""));
        Assert.assertEquals(null, (Object)FilenameUtils.concat(null, (String)"a"));
        Assert.assertEquals((Object)(SEP + "a"), (Object)FilenameUtils.concat(null, (String)"/a"));
        Assert.assertEquals(null, (Object)FilenameUtils.concat((String)"", (String)":"));
        Assert.assertEquals(null, (Object)FilenameUtils.concat((String)":", (String)""));
        Assert.assertEquals((Object)("f" + SEP), (Object)FilenameUtils.concat((String)"", (String)"f/"));
        Assert.assertEquals((Object)"f", (Object)FilenameUtils.concat((String)"", (String)"f"));
        Assert.assertEquals((Object)("a" + SEP + "f" + SEP), (Object)FilenameUtils.concat((String)"a/", (String)"f/"));
        Assert.assertEquals((Object)("a" + SEP + "f"), (Object)FilenameUtils.concat((String)"a", (String)"f"));
        Assert.assertEquals((Object)("a" + SEP + "b" + SEP + "f" + SEP), (Object)FilenameUtils.concat((String)"a/b/", (String)"f/"));
        Assert.assertEquals((Object)("a" + SEP + "b" + SEP + "f"), (Object)FilenameUtils.concat((String)"a/b", (String)"f"));
        Assert.assertEquals((Object)("a" + SEP + "f" + SEP), (Object)FilenameUtils.concat((String)"a/b/", (String)"../f/"));
        Assert.assertEquals((Object)("a" + SEP + "f"), (Object)FilenameUtils.concat((String)"a/b", (String)"../f"));
        Assert.assertEquals((Object)("a" + SEP + "c" + SEP + "g" + SEP), (Object)FilenameUtils.concat((String)"a/b/../c/", (String)"f/../g/"));
        Assert.assertEquals((Object)("a" + SEP + "c" + SEP + "g"), (Object)FilenameUtils.concat((String)"a/b/../c", (String)"f/../g"));
        Assert.assertEquals((Object)("a" + SEP + "c.txt" + SEP + "f"), (Object)FilenameUtils.concat((String)"a/c.txt", (String)"f"));
        Assert.assertEquals((Object)(SEP + "f" + SEP), (Object)FilenameUtils.concat((String)"", (String)"/f/"));
        Assert.assertEquals((Object)(SEP + "f"), (Object)FilenameUtils.concat((String)"", (String)"/f"));
        Assert.assertEquals((Object)(SEP + "f" + SEP), (Object)FilenameUtils.concat((String)"a/", (String)"/f/"));
        Assert.assertEquals((Object)(SEP + "f"), (Object)FilenameUtils.concat((String)"a", (String)"/f"));
        Assert.assertEquals((Object)(SEP + "c" + SEP + "d"), (Object)FilenameUtils.concat((String)"a/b/", (String)"/c/d"));
        Assert.assertEquals((Object)("C:c" + SEP + "d"), (Object)FilenameUtils.concat((String)"a/b/", (String)"C:c/d"));
        Assert.assertEquals((Object)("C:" + SEP + "c" + SEP + "d"), (Object)FilenameUtils.concat((String)"a/b/", (String)"C:/c/d"));
        Assert.assertEquals((Object)("~" + SEP + "c" + SEP + "d"), (Object)FilenameUtils.concat((String)"a/b/", (String)"~/c/d"));
        Assert.assertEquals((Object)("~user" + SEP + "c" + SEP + "d"), (Object)FilenameUtils.concat((String)"a/b/", (String)"~user/c/d"));
        Assert.assertEquals((Object)("~" + SEP), (Object)FilenameUtils.concat((String)"a/b/", (String)"~"));
        Assert.assertEquals((Object)("~user" + SEP), (Object)FilenameUtils.concat((String)"a/b/", (String)"~user"));
    }

    @Test
    public void testSeparatorsToUnix() {
        Assert.assertEquals(null, (Object)FilenameUtils.separatorsToUnix(null));
        Assert.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToUnix((String)"/a/b/c"));
        Assert.assertEquals((Object)"/a/b/c.txt", (Object)FilenameUtils.separatorsToUnix((String)"/a/b/c.txt"));
        Assert.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToUnix((String)"/a/b\\c"));
        Assert.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToUnix((String)"\\a\\b\\c"));
        Assert.assertEquals((Object)"D:/a/b/c", (Object)FilenameUtils.separatorsToUnix((String)"D:\\a\\b\\c"));
    }

    @Test
    public void testSeparatorsToWindows() {
        Assert.assertEquals(null, (Object)FilenameUtils.separatorsToWindows(null));
        Assert.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToWindows((String)"\\a\\b\\c"));
        Assert.assertEquals((Object)"\\a\\b\\c.txt", (Object)FilenameUtils.separatorsToWindows((String)"\\a\\b\\c.txt"));
        Assert.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToWindows((String)"\\a\\b/c"));
        Assert.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToWindows((String)"/a/b/c"));
        Assert.assertEquals((Object)"D:\\a\\b\\c", (Object)FilenameUtils.separatorsToWindows((String)"D:/a/b/c"));
    }

    @Test
    public void testSeparatorsToSystem() {
        if (WINDOWS) {
            Assert.assertEquals(null, (Object)FilenameUtils.separatorsToSystem(null));
            Assert.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToSystem((String)"\\a\\b\\c"));
            Assert.assertEquals((Object)"\\a\\b\\c.txt", (Object)FilenameUtils.separatorsToSystem((String)"\\a\\b\\c.txt"));
            Assert.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToSystem((String)"\\a\\b/c"));
            Assert.assertEquals((Object)"\\a\\b\\c", (Object)FilenameUtils.separatorsToSystem((String)"/a/b/c"));
            Assert.assertEquals((Object)"D:\\a\\b\\c", (Object)FilenameUtils.separatorsToSystem((String)"D:/a/b/c"));
        } else {
            Assert.assertEquals(null, (Object)FilenameUtils.separatorsToSystem(null));
            Assert.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToSystem((String)"/a/b/c"));
            Assert.assertEquals((Object)"/a/b/c.txt", (Object)FilenameUtils.separatorsToSystem((String)"/a/b/c.txt"));
            Assert.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToSystem((String)"/a/b\\c"));
            Assert.assertEquals((Object)"/a/b/c", (Object)FilenameUtils.separatorsToSystem((String)"\\a\\b\\c"));
            Assert.assertEquals((Object)"D:/a/b/c", (Object)FilenameUtils.separatorsToSystem((String)"D:\\a\\b\\c"));
        }
    }

    @Test
    public void testGetPrefixLength() {
        Assert.assertEquals((long)-1L, (long)FilenameUtils.getPrefixLength(null));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.getPrefixLength((String)":"));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.getPrefixLength((String)"1:\\a\\b\\c.txt"));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.getPrefixLength((String)"1:"));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.getPrefixLength((String)"1:a"));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.getPrefixLength((String)"\\\\\\a\\b\\c.txt"));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.getPrefixLength((String)"\\\\a"));
        Assert.assertEquals((long)0L, (long)FilenameUtils.getPrefixLength((String)""));
        Assert.assertEquals((long)1L, (long)FilenameUtils.getPrefixLength((String)"\\"));
        Assert.assertEquals((long)2L, (long)FilenameUtils.getPrefixLength((String)"C:"));
        Assert.assertEquals((long)3L, (long)FilenameUtils.getPrefixLength((String)"C:\\"));
        Assert.assertEquals((long)9L, (long)FilenameUtils.getPrefixLength((String)"//server/"));
        Assert.assertEquals((long)2L, (long)FilenameUtils.getPrefixLength((String)"~"));
        Assert.assertEquals((long)2L, (long)FilenameUtils.getPrefixLength((String)"~/"));
        Assert.assertEquals((long)6L, (long)FilenameUtils.getPrefixLength((String)"~user"));
        Assert.assertEquals((long)6L, (long)FilenameUtils.getPrefixLength((String)"~user/"));
        Assert.assertEquals((long)0L, (long)FilenameUtils.getPrefixLength((String)"a\\b\\c.txt"));
        Assert.assertEquals((long)1L, (long)FilenameUtils.getPrefixLength((String)"\\a\\b\\c.txt"));
        Assert.assertEquals((long)2L, (long)FilenameUtils.getPrefixLength((String)"C:a\\b\\c.txt"));
        Assert.assertEquals((long)3L, (long)FilenameUtils.getPrefixLength((String)"C:\\a\\b\\c.txt"));
        Assert.assertEquals((long)9L, (long)FilenameUtils.getPrefixLength((String)"\\\\server\\a\\b\\c.txt"));
        Assert.assertEquals((long)0L, (long)FilenameUtils.getPrefixLength((String)"a/b/c.txt"));
        Assert.assertEquals((long)1L, (long)FilenameUtils.getPrefixLength((String)"/a/b/c.txt"));
        Assert.assertEquals((long)3L, (long)FilenameUtils.getPrefixLength((String)"C:/a/b/c.txt"));
        Assert.assertEquals((long)9L, (long)FilenameUtils.getPrefixLength((String)"//server/a/b/c.txt"));
        Assert.assertEquals((long)2L, (long)FilenameUtils.getPrefixLength((String)"~/a/b/c.txt"));
        Assert.assertEquals((long)6L, (long)FilenameUtils.getPrefixLength((String)"~user/a/b/c.txt"));
        Assert.assertEquals((long)0L, (long)FilenameUtils.getPrefixLength((String)"a\\b\\c.txt"));
        Assert.assertEquals((long)1L, (long)FilenameUtils.getPrefixLength((String)"\\a\\b\\c.txt"));
        Assert.assertEquals((long)2L, (long)FilenameUtils.getPrefixLength((String)"~\\a\\b\\c.txt"));
        Assert.assertEquals((long)6L, (long)FilenameUtils.getPrefixLength((String)"~user\\a\\b\\c.txt"));
        Assert.assertEquals((long)9L, (long)FilenameUtils.getPrefixLength((String)"//server/a/b/c.txt"));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.getPrefixLength((String)"\\\\\\a\\b\\c.txt"));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.getPrefixLength((String)"///a/b/c.txt"));
        Assert.assertEquals((long)1L, (long)FilenameUtils.getPrefixLength((String)"/:foo"));
        Assert.assertEquals((long)1L, (long)FilenameUtils.getPrefixLength((String)"/:/"));
        Assert.assertEquals((long)1L, (long)FilenameUtils.getPrefixLength((String)"/:::::::.txt"));
    }

    @Test
    public void testIndexOfLastSeparator() {
        Assert.assertEquals((long)-1L, (long)FilenameUtils.indexOfLastSeparator(null));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.indexOfLastSeparator((String)"noseperator.inthispath"));
        Assert.assertEquals((long)3L, (long)FilenameUtils.indexOfLastSeparator((String)"a/b/c"));
        Assert.assertEquals((long)3L, (long)FilenameUtils.indexOfLastSeparator((String)"a\\b\\c"));
    }

    @Test
    public void testIndexOfExtension() {
        Assert.assertEquals((long)-1L, (long)FilenameUtils.indexOfExtension(null));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.indexOfExtension((String)"file"));
        Assert.assertEquals((long)4L, (long)FilenameUtils.indexOfExtension((String)"file.txt"));
        Assert.assertEquals((long)13L, (long)FilenameUtils.indexOfExtension((String)"a.txt/b.txt/c.txt"));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.indexOfExtension((String)"a/b/c"));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.indexOfExtension((String)"a\\b\\c"));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.indexOfExtension((String)"a/b.notextension/c"));
        Assert.assertEquals((long)-1L, (long)FilenameUtils.indexOfExtension((String)"a\\b.notextension\\c"));
    }

    @Test
    public void testGetPrefix() {
        Assert.assertEquals(null, (Object)FilenameUtils.getPrefix(null));
        Assert.assertEquals(null, (Object)FilenameUtils.getPrefix((String)":"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPrefix((String)"1:\\a\\b\\c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPrefix((String)"1:"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPrefix((String)"1:a"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPrefix((String)"\\\\\\a\\b\\c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPrefix((String)"\\\\a"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPrefix((String)""));
        Assert.assertEquals((Object)"\\", (Object)FilenameUtils.getPrefix((String)"\\"));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.getPrefix((String)"C:"));
        Assert.assertEquals((Object)"C:\\", (Object)FilenameUtils.getPrefix((String)"C:\\"));
        Assert.assertEquals((Object)"//server/", (Object)FilenameUtils.getPrefix((String)"//server/"));
        Assert.assertEquals((Object)"~/", (Object)FilenameUtils.getPrefix((String)"~"));
        Assert.assertEquals((Object)"~/", (Object)FilenameUtils.getPrefix((String)"~/"));
        Assert.assertEquals((Object)"~user/", (Object)FilenameUtils.getPrefix((String)"~user"));
        Assert.assertEquals((Object)"~user/", (Object)FilenameUtils.getPrefix((String)"~user/"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPrefix((String)"a\\b\\c.txt"));
        Assert.assertEquals((Object)"\\", (Object)FilenameUtils.getPrefix((String)"\\a\\b\\c.txt"));
        Assert.assertEquals((Object)"C:\\", (Object)FilenameUtils.getPrefix((String)"C:\\a\\b\\c.txt"));
        Assert.assertEquals((Object)"\\\\server\\", (Object)FilenameUtils.getPrefix((String)"\\\\server\\a\\b\\c.txt"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPrefix((String)"a/b/c.txt"));
        Assert.assertEquals((Object)"/", (Object)FilenameUtils.getPrefix((String)"/a/b/c.txt"));
        Assert.assertEquals((Object)"C:/", (Object)FilenameUtils.getPrefix((String)"C:/a/b/c.txt"));
        Assert.assertEquals((Object)"//server/", (Object)FilenameUtils.getPrefix((String)"//server/a/b/c.txt"));
        Assert.assertEquals((Object)"~/", (Object)FilenameUtils.getPrefix((String)"~/a/b/c.txt"));
        Assert.assertEquals((Object)"~user/", (Object)FilenameUtils.getPrefix((String)"~user/a/b/c.txt"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPrefix((String)"a\\b\\c.txt"));
        Assert.assertEquals((Object)"\\", (Object)FilenameUtils.getPrefix((String)"\\a\\b\\c.txt"));
        Assert.assertEquals((Object)"~\\", (Object)FilenameUtils.getPrefix((String)"~\\a\\b\\c.txt"));
        Assert.assertEquals((Object)"~user\\", (Object)FilenameUtils.getPrefix((String)"~user\\a\\b\\c.txt"));
    }

    @Test
    public void testGetPrefix_with_nullbyte() {
        try {
            Assert.assertEquals((Object)"~user\\", (Object)FilenameUtils.getPrefix((String)"~u\u0000ser\\a\\b\\c.txt"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPath() {
        Assert.assertEquals(null, (Object)FilenameUtils.getPath(null));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"noseperator.inthispath"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"/noseperator.inthispath"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"\\noseperator.inthispath"));
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"a/b/c.txt"));
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"a/b/c"));
        Assert.assertEquals((Object)"a/b/c/", (Object)FilenameUtils.getPath((String)"a/b/c/"));
        Assert.assertEquals((Object)"a\\b\\", (Object)FilenameUtils.getPath((String)"a\\b\\c"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPath((String)":"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPath((String)"1:/a/b/c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPath((String)"1:"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPath((String)"1:a"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPath((String)"///a/b/c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPath((String)"//a"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)""));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"C:"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"C:/"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"//server/"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"~"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"~/"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"~user"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"~user/"));
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"a/b/c.txt"));
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"/a/b/c.txt"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"C:a"));
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"C:a/b/c.txt"));
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"C:/a/b/c.txt"));
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"//server/a/b/c.txt"));
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"~/a/b/c.txt"));
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"~user/a/b/c.txt"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetPath_with_nullbyte() {
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getPath((String)"~user/a/\u0000b/c.txt"));
    }

    @Test
    public void testGetPathNoEndSeparator() {
        Assert.assertEquals(null, (Object)FilenameUtils.getPath(null));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPath((String)"noseperator.inthispath"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"/noseperator.inthispath"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"\\noseperator.inthispath"));
        Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"a/b/c.txt"));
        Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"a/b/c"));
        Assert.assertEquals((Object)"a/b/c", (Object)FilenameUtils.getPathNoEndSeparator((String)"a/b/c/"));
        Assert.assertEquals((Object)"a\\b", (Object)FilenameUtils.getPathNoEndSeparator((String)"a\\b\\c"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPathNoEndSeparator((String)":"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPathNoEndSeparator((String)"1:/a/b/c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPathNoEndSeparator((String)"1:"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPathNoEndSeparator((String)"1:a"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPathNoEndSeparator((String)"///a/b/c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.getPathNoEndSeparator((String)"//a"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)""));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"C:"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"C:/"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"//server/"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"~"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"~/"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"~user"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"~user/"));
        Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"a/b/c.txt"));
        Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"/a/b/c.txt"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getPathNoEndSeparator((String)"C:a"));
        Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"C:a/b/c.txt"));
        Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"C:/a/b/c.txt"));
        Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"//server/a/b/c.txt"));
        Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"~/a/b/c.txt"));
        Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"~user/a/b/c.txt"));
    }

    @Test
    public void testGetPathNoEndSeparator_with_null_byte() {
        try {
            Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getPathNoEndSeparator((String)"~user/a\u0000/b/c.txt"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFullPath() {
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPath(null));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getFullPath((String)"noseperator.inthispath"));
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getFullPath((String)"a/b/c.txt"));
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getFullPath((String)"a/b/c"));
        Assert.assertEquals((Object)"a/b/c/", (Object)FilenameUtils.getFullPath((String)"a/b/c/"));
        Assert.assertEquals((Object)"a\\b\\", (Object)FilenameUtils.getFullPath((String)"a\\b\\c"));
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPath((String)":"));
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPath((String)"1:/a/b/c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPath((String)"1:"));
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPath((String)"1:a"));
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPath((String)"///a/b/c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPath((String)"//a"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getFullPath((String)""));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.getFullPath((String)"C:"));
        Assert.assertEquals((Object)"C:/", (Object)FilenameUtils.getFullPath((String)"C:/"));
        Assert.assertEquals((Object)"//server/", (Object)FilenameUtils.getFullPath((String)"//server/"));
        Assert.assertEquals((Object)"~/", (Object)FilenameUtils.getFullPath((String)"~"));
        Assert.assertEquals((Object)"~/", (Object)FilenameUtils.getFullPath((String)"~/"));
        Assert.assertEquals((Object)"~user/", (Object)FilenameUtils.getFullPath((String)"~user"));
        Assert.assertEquals((Object)"~user/", (Object)FilenameUtils.getFullPath((String)"~user/"));
        Assert.assertEquals((Object)"a/b/", (Object)FilenameUtils.getFullPath((String)"a/b/c.txt"));
        Assert.assertEquals((Object)"/a/b/", (Object)FilenameUtils.getFullPath((String)"/a/b/c.txt"));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.getFullPath((String)"C:a"));
        Assert.assertEquals((Object)"C:a/b/", (Object)FilenameUtils.getFullPath((String)"C:a/b/c.txt"));
        Assert.assertEquals((Object)"C:/a/b/", (Object)FilenameUtils.getFullPath((String)"C:/a/b/c.txt"));
        Assert.assertEquals((Object)"//server/a/b/", (Object)FilenameUtils.getFullPath((String)"//server/a/b/c.txt"));
        Assert.assertEquals((Object)"~/a/b/", (Object)FilenameUtils.getFullPath((String)"~/a/b/c.txt"));
        Assert.assertEquals((Object)"~user/a/b/", (Object)FilenameUtils.getFullPath((String)"~user/a/b/c.txt"));
    }

    @Test
    public void testGetFullPathNoEndSeparator() {
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator(null));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"noseperator.inthispath"));
        Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"a/b/c.txt"));
        Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"a/b/c"));
        Assert.assertEquals((Object)"a/b/c", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"a/b/c/"));
        Assert.assertEquals((Object)"a\\b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"a\\b\\c"));
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator((String)":"));
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator((String)"1:/a/b/c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator((String)"1:"));
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator((String)"1:a"));
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator((String)"///a/b/c.txt"));
        Assert.assertEquals(null, (Object)FilenameUtils.getFullPathNoEndSeparator((String)"//a"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getFullPathNoEndSeparator((String)""));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"C:"));
        Assert.assertEquals((Object)"C:/", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"C:/"));
        Assert.assertEquals((Object)"//server/", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"//server/"));
        Assert.assertEquals((Object)"~", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"~"));
        Assert.assertEquals((Object)"~/", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"~/"));
        Assert.assertEquals((Object)"~user", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"~user"));
        Assert.assertEquals((Object)"~user/", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"~user/"));
        Assert.assertEquals((Object)"a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"a/b/c.txt"));
        Assert.assertEquals((Object)"/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"/a/b/c.txt"));
        Assert.assertEquals((Object)"C:", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"C:a"));
        Assert.assertEquals((Object)"C:a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"C:a/b/c.txt"));
        Assert.assertEquals((Object)"C:/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"C:/a/b/c.txt"));
        Assert.assertEquals((Object)"//server/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"//server/a/b/c.txt"));
        Assert.assertEquals((Object)"~/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"~/a/b/c.txt"));
        Assert.assertEquals((Object)"~user/a/b", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"~user/a/b/c.txt"));
    }

    @Test
    public void testGetFullPathNoEndSeparator_IO_248() {
        Assert.assertEquals((Object)"/", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"/"));
        Assert.assertEquals((Object)"\\", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"\\"));
        Assert.assertEquals((Object)"/", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"/abc"));
        Assert.assertEquals((Object)"\\", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"\\abc"));
        Assert.assertEquals((Object)"/abc", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"/abc/xyz"));
        Assert.assertEquals((Object)"\\abc", (Object)FilenameUtils.getFullPathNoEndSeparator((String)"\\abc\\xyz"));
    }

    @Test
    public void testGetName() {
        Assert.assertEquals(null, (Object)FilenameUtils.getName(null));
        Assert.assertEquals((Object)"noseperator.inthispath", (Object)FilenameUtils.getName((String)"noseperator.inthispath"));
        Assert.assertEquals((Object)"c.txt", (Object)FilenameUtils.getName((String)"a/b/c.txt"));
        Assert.assertEquals((Object)"c", (Object)FilenameUtils.getName((String)"a/b/c"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getName((String)"a/b/c/"));
        Assert.assertEquals((Object)"c", (Object)FilenameUtils.getName((String)"a\\b\\c"));
    }

    @Test
    public void testInjectionFailure() {
        try {
            Assert.assertEquals((Object)"c", (Object)FilenameUtils.getName((String)"a\\b\\\u0000c"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBaseName() {
        Assert.assertEquals(null, (Object)FilenameUtils.getBaseName(null));
        Assert.assertEquals((Object)"noseperator", (Object)FilenameUtils.getBaseName((String)"noseperator.inthispath"));
        Assert.assertEquals((Object)"c", (Object)FilenameUtils.getBaseName((String)"a/b/c.txt"));
        Assert.assertEquals((Object)"c", (Object)FilenameUtils.getBaseName((String)"a/b/c"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getBaseName((String)"a/b/c/"));
        Assert.assertEquals((Object)"c", (Object)FilenameUtils.getBaseName((String)"a\\b\\c"));
        Assert.assertEquals((Object)"file.txt", (Object)FilenameUtils.getBaseName((String)"file.txt.bak"));
    }

    @Test
    public void testGetBaseName_with_nullByte() {
        try {
            Assert.assertEquals((Object)"file.txt", (Object)FilenameUtils.getBaseName((String)"fil\u0000e.txt.bak"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetExtension() {
        Assert.assertEquals(null, (Object)FilenameUtils.getExtension(null));
        Assert.assertEquals((Object)"ext", (Object)FilenameUtils.getExtension((String)"file.ext"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getExtension((String)"README"));
        Assert.assertEquals((Object)"com", (Object)FilenameUtils.getExtension((String)"domain.dot.com"));
        Assert.assertEquals((Object)"jpeg", (Object)FilenameUtils.getExtension((String)"image.jpeg"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getExtension((String)"a.b/c"));
        Assert.assertEquals((Object)"txt", (Object)FilenameUtils.getExtension((String)"a.b/c.txt"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getExtension((String)"a/b/c"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getExtension((String)"a.b\\c"));
        Assert.assertEquals((Object)"txt", (Object)FilenameUtils.getExtension((String)"a.b\\c.txt"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getExtension((String)"a\\b\\c"));
        Assert.assertEquals((Object)"", (Object)FilenameUtils.getExtension((String)"C:\\temp\\foo.bar\\README"));
        Assert.assertEquals((Object)"ext", (Object)FilenameUtils.getExtension((String)"../filename.ext"));
    }

    @Test
    public void testRemoveExtension() {
        Assert.assertEquals(null, (Object)FilenameUtils.removeExtension(null));
        Assert.assertEquals((Object)"file", (Object)FilenameUtils.removeExtension((String)"file.ext"));
        Assert.assertEquals((Object)"README", (Object)FilenameUtils.removeExtension((String)"README"));
        Assert.assertEquals((Object)"domain.dot", (Object)FilenameUtils.removeExtension((String)"domain.dot.com"));
        Assert.assertEquals((Object)"image", (Object)FilenameUtils.removeExtension((String)"image.jpeg"));
        Assert.assertEquals((Object)"a.b/c", (Object)FilenameUtils.removeExtension((String)"a.b/c"));
        Assert.assertEquals((Object)"a.b/c", (Object)FilenameUtils.removeExtension((String)"a.b/c.txt"));
        Assert.assertEquals((Object)"a/b/c", (Object)FilenameUtils.removeExtension((String)"a/b/c"));
        Assert.assertEquals((Object)"a.b\\c", (Object)FilenameUtils.removeExtension((String)"a.b\\c"));
        Assert.assertEquals((Object)"a.b\\c", (Object)FilenameUtils.removeExtension((String)"a.b\\c.txt"));
        Assert.assertEquals((Object)"a\\b\\c", (Object)FilenameUtils.removeExtension((String)"a\\b\\c"));
        Assert.assertEquals((Object)"C:\\temp\\foo.bar\\README", (Object)FilenameUtils.removeExtension((String)"C:\\temp\\foo.bar\\README"));
        Assert.assertEquals((Object)"../filename", (Object)FilenameUtils.removeExtension((String)"../filename.ext"));
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)FilenameUtils.equals(null, null));
        Assert.assertFalse((boolean)FilenameUtils.equals(null, (String)""));
        Assert.assertFalse((boolean)FilenameUtils.equals((String)"", null));
        Assert.assertTrue((boolean)FilenameUtils.equals((String)"", (String)""));
        Assert.assertTrue((boolean)FilenameUtils.equals((String)"file.txt", (String)"file.txt"));
        Assert.assertFalse((boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT"));
        Assert.assertFalse((boolean)FilenameUtils.equals((String)"a\\b\\file.txt", (String)"a/b/file.txt"));
    }

    @Test
    public void testEqualsOnSystem() {
        Assert.assertTrue((boolean)FilenameUtils.equalsOnSystem(null, null));
        Assert.assertFalse((boolean)FilenameUtils.equalsOnSystem(null, (String)""));
        Assert.assertFalse((boolean)FilenameUtils.equalsOnSystem((String)"", null));
        Assert.assertTrue((boolean)FilenameUtils.equalsOnSystem((String)"", (String)""));
        Assert.assertTrue((boolean)FilenameUtils.equalsOnSystem((String)"file.txt", (String)"file.txt"));
        Assert.assertEquals((Object)WINDOWS, (Object)FilenameUtils.equalsOnSystem((String)"file.txt", (String)"FILE.TXT"));
        Assert.assertFalse((boolean)FilenameUtils.equalsOnSystem((String)"a\\b\\file.txt", (String)"a/b/file.txt"));
    }

    @Test
    public void testEqualsNormalized() {
        Assert.assertTrue((boolean)FilenameUtils.equalsNormalized(null, null));
        Assert.assertFalse((boolean)FilenameUtils.equalsNormalized(null, (String)""));
        Assert.assertFalse((boolean)FilenameUtils.equalsNormalized((String)"", null));
        Assert.assertTrue((boolean)FilenameUtils.equalsNormalized((String)"", (String)""));
        Assert.assertTrue((boolean)FilenameUtils.equalsNormalized((String)"file.txt", (String)"file.txt"));
        Assert.assertFalse((boolean)FilenameUtils.equalsNormalized((String)"file.txt", (String)"FILE.TXT"));
        Assert.assertTrue((boolean)FilenameUtils.equalsNormalized((String)"a\\b\\file.txt", (String)"a/b/file.txt"));
        Assert.assertFalse((boolean)FilenameUtils.equalsNormalized((String)"a/b/", (String)"a/b"));
    }

    @Test
    public void testEqualsNormalizedOnSystem() {
        Assert.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem(null, null));
        Assert.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem(null, (String)""));
        Assert.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"", null));
        Assert.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"", (String)""));
        Assert.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"file.txt", (String)"file.txt"));
        Assert.assertEquals((Object)WINDOWS, (Object)FilenameUtils.equalsNormalizedOnSystem((String)"file.txt", (String)"FILE.TXT"));
        Assert.assertTrue((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"a\\b\\file.txt", (String)"a/b/file.txt"));
        Assert.assertFalse((boolean)FilenameUtils.equalsNormalizedOnSystem((String)"a/b/", (String)"a/b"));
    }

    @Test
    public void testEqualsNormalizedError_IO_128() {
        try {
            FilenameUtils.equalsNormalizedOnSystem((String)"//file.txt", (String)"file.txt");
            Assert.fail((String)"Invalid normalized first file");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            FilenameUtils.equalsNormalizedOnSystem((String)"file.txt", (String)"//file.txt");
            Assert.fail((String)"Invalid normalized second file");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            FilenameUtils.equalsNormalizedOnSystem((String)"//file.txt", (String)"//file.txt");
            Assert.fail((String)"Invalid normalized both filse");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testEquals_fullControl() {
        Assert.assertFalse((boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT", (boolean)true, (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT", (boolean)true, (IOCase)IOCase.INSENSITIVE));
        Assert.assertEquals((Object)WINDOWS, (Object)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT", (boolean)true, (IOCase)IOCase.SYSTEM));
        Assert.assertFalse((boolean)FilenameUtils.equals((String)"file.txt", (String)"FILE.TXT", (boolean)true, null));
    }

    @Test
    public void testIsExtension() {
        Assert.assertFalse((boolean)FilenameUtils.isExtension(null, (String)null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String)null));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String)null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String)""));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String)""));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", (String)"txt"));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String)"rtf"));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)""));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)"txt"));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String)"rtf"));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)""));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)"txt"));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String)"rtf"));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)""));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)"txt"));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String)"rtf"));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)""));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)"txt"));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)"rtf"));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String)"TXT"));
    }

    @Test
    public void testIsExtension_injection() {
        try {
            FilenameUtils.isExtension((String)"a.b\\fi\u0000le.txt", (String)"TXT");
            Assert.fail((String)"Should throw IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIsExtensionArray() {
        Assert.assertFalse((boolean)FilenameUtils.isExtension(null, (String[])null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])null));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String[])null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[0]));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[]{"txt"}));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[]{"rtf"}));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (String[])new String[]{"rtf", ""}));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", (String[])new String[]{"rtf", "txt"}));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[0]));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[]{"txt"}));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[]{"rtf"}));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (String[])new String[]{"rtf", "txt"}));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[0]));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[]{"txt"}));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[]{"rtf"}));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (String[])new String[]{"rtf", "txt"}));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[0]));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[]{"txt"}));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[]{"rtf"}));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (String[])new String[]{"rtf", "txt"}));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[0]));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"txt"}));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"rtf"}));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"rtf", "txt"}));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"TXT"}));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (String[])new String[]{"TXT", "RTF"}));
    }

    @Test
    public void testIsExtensionCollection() {
        Assert.assertFalse((boolean)FilenameUtils.isExtension(null, (Collection)null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", (Collection)null));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"file", (Collection)null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", new ArrayList()));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"file", new ArrayList<String>(Arrays.asList("rtf", ""))));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", (Collection)null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", new ArrayList()));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a/b/file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", (Collection)null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", new ArrayList()));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b/file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", (Collection)null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", new ArrayList()));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a\\b\\file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", (Collection)null));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList()));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("txt"))));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("rtf"))));
        Assert.assertTrue((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("rtf", "txt"))));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("TXT"))));
        Assert.assertFalse((boolean)FilenameUtils.isExtension((String)"a.b\\file.txt", new ArrayList<String>(Arrays.asList("TXT", "RTF"))));
    }
}

