/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.io.IOCase;
import org.junit.Assert;
import org.junit.Test;

public class IOCaseTestCase {
    private static final boolean WINDOWS = File.separatorChar == '\\';

    @Test
    public void test_forName() throws Exception {
        Assert.assertEquals((Object)IOCase.SENSITIVE, (Object)IOCase.forName((String)"Sensitive"));
        Assert.assertEquals((Object)IOCase.INSENSITIVE, (Object)IOCase.forName((String)"Insensitive"));
        Assert.assertEquals((Object)IOCase.SYSTEM, (Object)IOCase.forName((String)"System"));
        try {
            IOCase.forName((String)"Blah");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IOCase.forName(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_serialization() throws Exception {
        Assert.assertSame((Object)IOCase.SENSITIVE, (Object)this.serialize(IOCase.SENSITIVE));
        Assert.assertSame((Object)IOCase.INSENSITIVE, (Object)this.serialize(IOCase.INSENSITIVE));
        Assert.assertSame((Object)IOCase.SYSTEM, (Object)this.serialize(IOCase.SYSTEM));
    }

    @Test
    public void test_getName() throws Exception {
        Assert.assertEquals((Object)"Sensitive", (Object)IOCase.SENSITIVE.getName());
        Assert.assertEquals((Object)"Insensitive", (Object)IOCase.INSENSITIVE.getName());
        Assert.assertEquals((Object)"System", (Object)IOCase.SYSTEM.getName());
    }

    @Test
    public void test_toString() throws Exception {
        Assert.assertEquals((Object)"Sensitive", (Object)IOCase.SENSITIVE.toString());
        Assert.assertEquals((Object)"Insensitive", (Object)IOCase.INSENSITIVE.toString());
        Assert.assertEquals((Object)"System", (Object)IOCase.SYSTEM.toString());
    }

    @Test
    public void test_isCaseSensitive() throws Exception {
        Assert.assertTrue((boolean)IOCase.SENSITIVE.isCaseSensitive());
        Assert.assertFalse((boolean)IOCase.INSENSITIVE.isCaseSensitive());
        Assert.assertEquals((Object)(!WINDOWS ? 1 : 0), (Object)IOCase.SYSTEM.isCaseSensitive());
    }

    @Test
    public void test_checkCompare_functionality() throws Exception {
        Assert.assertTrue((IOCase.SENSITIVE.checkCompareTo("ABC", "") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((IOCase.SENSITIVE.checkCompareTo("", "ABC") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((IOCase.SENSITIVE.checkCompareTo("ABC", "DEF") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((IOCase.SENSITIVE.checkCompareTo("DEF", "ABC") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)IOCase.SENSITIVE.checkCompareTo("ABC", "ABC"));
        Assert.assertEquals((long)0L, (long)IOCase.SENSITIVE.checkCompareTo("", ""));
        try {
            IOCase.SENSITIVE.checkCompareTo("ABC", null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkCompareTo(null, "ABC");
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkCompareTo(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void test_checkCompare_case() throws Exception {
        Assert.assertEquals((long)0L, (long)IOCase.SENSITIVE.checkCompareTo("ABC", "ABC"));
        Assert.assertTrue((IOCase.SENSITIVE.checkCompareTo("ABC", "abc") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((IOCase.SENSITIVE.checkCompareTo("abc", "ABC") > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)IOCase.INSENSITIVE.checkCompareTo("ABC", "ABC"));
        Assert.assertEquals((long)0L, (long)IOCase.INSENSITIVE.checkCompareTo("ABC", "abc"));
        Assert.assertEquals((long)0L, (long)IOCase.INSENSITIVE.checkCompareTo("abc", "ABC"));
        Assert.assertEquals((long)0L, (long)IOCase.SYSTEM.checkCompareTo("ABC", "ABC"));
        Assert.assertEquals((Object)WINDOWS, (Object)(IOCase.SYSTEM.checkCompareTo("ABC", "abc") == 0 ? 1 : 0));
        Assert.assertEquals((Object)WINDOWS, (Object)(IOCase.SYSTEM.checkCompareTo("abc", "ABC") == 0 ? 1 : 0));
    }

    @Test
    public void test_checkEquals_functionality() throws Exception {
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", ""));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "A"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "AB"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkEquals("ABC", "ABC"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "BC"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "C"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "ABCD"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("", "ABC"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkEquals("", ""));
        try {
            IOCase.SENSITIVE.checkEquals("ABC", null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkEquals(null, "ABC");
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkEquals(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void test_checkEquals_case() throws Exception {
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkEquals("ABC", "ABC"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "Abc"));
        Assert.assertTrue((boolean)IOCase.INSENSITIVE.checkEquals("ABC", "ABC"));
        Assert.assertTrue((boolean)IOCase.INSENSITIVE.checkEquals("ABC", "Abc"));
        Assert.assertTrue((boolean)IOCase.SYSTEM.checkEquals("ABC", "ABC"));
        Assert.assertEquals((Object)WINDOWS, (Object)IOCase.SYSTEM.checkEquals("ABC", "Abc"));
    }

    @Test
    public void test_checkStartsWith_functionality() throws Exception {
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", ""));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "A"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "AB"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "ABC"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "BC"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "C"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "ABCD"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("", "ABC"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("", ""));
        try {
            IOCase.SENSITIVE.checkStartsWith("ABC", null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkStartsWith(null, "ABC");
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkStartsWith(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void test_checkStartsWith_case() throws Exception {
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "AB"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "Ab"));
        Assert.assertTrue((boolean)IOCase.INSENSITIVE.checkStartsWith("ABC", "AB"));
        Assert.assertTrue((boolean)IOCase.INSENSITIVE.checkStartsWith("ABC", "Ab"));
        Assert.assertTrue((boolean)IOCase.SYSTEM.checkStartsWith("ABC", "AB"));
        Assert.assertEquals((Object)WINDOWS, (Object)IOCase.SYSTEM.checkStartsWith("ABC", "Ab"));
    }

    @Test
    public void test_checkEndsWith_functionality() throws Exception {
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", ""));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "A"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "AB"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "ABC"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "BC"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "C"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "ABCD"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("", "ABC"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("", ""));
        try {
            IOCase.SENSITIVE.checkEndsWith("ABC", null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkEndsWith(null, "ABC");
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkEndsWith(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void test_checkEndsWith_case() throws Exception {
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "BC"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "Bc"));
        Assert.assertTrue((boolean)IOCase.INSENSITIVE.checkEndsWith("ABC", "BC"));
        Assert.assertTrue((boolean)IOCase.INSENSITIVE.checkEndsWith("ABC", "Bc"));
        Assert.assertTrue((boolean)IOCase.SYSTEM.checkEndsWith("ABC", "BC"));
        Assert.assertEquals((Object)WINDOWS, (Object)IOCase.SYSTEM.checkEndsWith("ABC", "Bc"));
    }

    @Test
    public void test_checkIndexOf_functionality() throws Exception {
        Assert.assertEquals((long)0L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "A"));
        Assert.assertEquals((long)-1L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 1, "A"));
        Assert.assertEquals((long)0L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "AB"));
        Assert.assertEquals((long)-1L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 1, "AB"));
        Assert.assertEquals((long)0L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "ABC"));
        Assert.assertEquals((long)-1L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 1, "ABC"));
        Assert.assertEquals((long)3L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "D"));
        Assert.assertEquals((long)3L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 3, "D"));
        Assert.assertEquals((long)-1L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 4, "D"));
        Assert.assertEquals((long)3L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "DE"));
        Assert.assertEquals((long)3L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 3, "DE"));
        Assert.assertEquals((long)-1L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 4, "DE"));
        Assert.assertEquals((long)3L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "DEF"));
        Assert.assertEquals((long)3L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 3, "DEF"));
        Assert.assertEquals((long)-1L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 4, "DEF"));
        Assert.assertEquals((long)9L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "J"));
        Assert.assertEquals((long)9L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 8, "J"));
        Assert.assertEquals((long)9L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 9, "J"));
        Assert.assertEquals((long)8L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "IJ"));
        Assert.assertEquals((long)8L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 8, "IJ"));
        Assert.assertEquals((long)-1L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 9, "IJ"));
        Assert.assertEquals((long)7L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 6, "HIJ"));
        Assert.assertEquals((long)7L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 7, "HIJ"));
        Assert.assertEquals((long)-1L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 8, "HIJ"));
        Assert.assertEquals((long)-1L, (long)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "DED"));
        Assert.assertEquals((long)-1L, (long)IOCase.SENSITIVE.checkIndexOf("DEF", 0, "ABCDEFGHIJ"));
        try {
            IOCase.SENSITIVE.checkIndexOf("ABC", 0, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkIndexOf(null, 0, "ABC");
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkIndexOf(null, 0, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void test_checkIndexOf_case() throws Exception {
        Assert.assertEquals((long)1L, (long)IOCase.SENSITIVE.checkIndexOf("ABC", 0, "BC"));
        Assert.assertEquals((long)-1L, (long)IOCase.SENSITIVE.checkIndexOf("ABC", 0, "Bc"));
        Assert.assertEquals((long)1L, (long)IOCase.INSENSITIVE.checkIndexOf("ABC", 0, "BC"));
        Assert.assertEquals((long)1L, (long)IOCase.INSENSITIVE.checkIndexOf("ABC", 0, "Bc"));
        Assert.assertEquals((long)1L, (long)IOCase.SYSTEM.checkIndexOf("ABC", 0, "BC"));
        Assert.assertEquals((long)(WINDOWS ? 1L : -1L), (long)IOCase.SYSTEM.checkIndexOf("ABC", 0, "Bc"));
    }

    @Test
    public void test_checkRegionMatches_functionality() throws Exception {
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, ""));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "A"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "AB"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "ABC"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "BC"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "C"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "ABCD"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("", 0, "ABC"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("", 0, ""));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, ""));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "A"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "AB"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "ABC"));
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "BC"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "C"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "ABCD"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("", 1, "ABC"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("", 1, ""));
        try {
            IOCase.SENSITIVE.checkRegionMatches("ABC", 0, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkRegionMatches(null, 0, "ABC");
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkRegionMatches(null, 0, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkRegionMatches("ABC", 1, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkRegionMatches(null, 1, "ABC");
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkRegionMatches(null, 1, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void test_checkRegionMatches_case() throws Exception {
        Assert.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "AB"));
        Assert.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "Ab"));
        Assert.assertTrue((boolean)IOCase.INSENSITIVE.checkRegionMatches("ABC", 0, "AB"));
        Assert.assertTrue((boolean)IOCase.INSENSITIVE.checkRegionMatches("ABC", 0, "Ab"));
        Assert.assertTrue((boolean)IOCase.SYSTEM.checkRegionMatches("ABC", 0, "AB"));
        Assert.assertEquals((Object)WINDOWS, (Object)IOCase.SYSTEM.checkRegionMatches("ABC", 0, "Ab"));
    }

    private IOCase serialize(IOCase value) throws Exception {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buf);
        out.writeObject(value);
        out.flush();
        out.close();
        ByteArrayInputStream bufin = new ByteArrayInputStream(buf.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bufin);
        return (IOCase)in.readObject();
    }
}

