/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class IOExceptionWithCauseTestCase {
    @Test
    public void testIOExceptionStringThrowable() {
        IllegalArgumentException cause = new IllegalArgumentException("cause");
        IOException exception = new IOException("message", cause);
        this.validate(exception, cause, "message");
    }

    @Test
    public void testIOExceptionThrowable() {
        IllegalArgumentException cause = new IllegalArgumentException("cause");
        IOException exception = new IOException(cause);
        this.validate(exception, cause, "java.lang.IllegalArgumentException: cause");
    }

    void validate(Throwable throwable, Throwable expectedCause, String expectedMessage) {
        Assert.assertEquals((Object)expectedMessage, (Object)throwable.getMessage());
        Assert.assertEquals((Object)expectedCause, (Object)throwable.getCause());
        Assert.assertSame((Object)expectedCause, (Object)throwable.getCause());
    }
}

