/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.SelectorAdapter;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class IOUtilsTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final int FILE_SIZE = 4097;
    private static final boolean WINDOWS = File.separatorChar == '\\';
    private char[] carr = null;
    private byte[] iarr = null;
    private File m_testFile;

    private File getTestDirectory() {
        return this.temporaryFolder.getRoot();
    }

    private void assertEqualContent(byte[] b0, byte[] b1) {
        Assert.assertTrue((String)"Content not equal according to java.util.Arrays#equals()", (boolean)Arrays.equals(b0, b1));
    }

    @Before
    public void setUp() {
        int i;
        try {
            this.m_testFile = new File(this.getTestDirectory(), "file2-test.txt");
            if (!this.m_testFile.getParentFile().exists()) {
                throw new IOException("Cannot create file " + this.m_testFile + " as the parent directory does not exist");
            }
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.m_testFile));
            try {
                TestUtils.generateTestData(output, 4097L);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Can't run this test because the environment could not be built: " + ioe.getMessage());
        }
        this.iarr = new byte[200];
        Arrays.fill(this.iarr, (byte)-1);
        for (i = 0; i < 80; ++i) {
            this.iarr[i] = (byte)i;
        }
        this.carr = new char[200];
        Arrays.fill(this.carr, '\uffff');
        for (i = 0; i < 80; ++i) {
            this.carr[i] = (char)i;
        }
    }

    @Test
    public void testCloseQuietly_AllCloseableIOException() {
        Closeable closeable = new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };
        IOUtils.closeQuietly((Closeable[])new Closeable[]{closeable, null, closeable});
    }

    @Test
    public void testCloseQuietly_CloseableIOException() {
        IOUtils.closeQuietly((Closeable)new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        });
    }

    @Test
    public void testCloseQuietly_Selector() {
        Selector selector = null;
        try {
            selector = Selector.open();
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((Selector)selector);
        }
    }

    @Test
    public void testCloseQuietly_SelectorIOException() {
        SelectorAdapter selector = new SelectorAdapter(){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };
        IOUtils.closeQuietly((Selector)selector);
    }

    @Test
    public void testCloseQuietly_SelectorNull() {
        Selector selector = null;
        IOUtils.closeQuietly(selector);
    }

    @Test
    public void testCloseQuietly_SelectorTwice() {
        Selector selector = null;
        try {
            selector = Selector.open();
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((Selector)selector);
            IOUtils.closeQuietly((Selector)selector);
        }
    }

    @Test
    public void testCloseQuietly_ServerSocket() throws IOException {
        IOUtils.closeQuietly((ServerSocket)null);
        IOUtils.closeQuietly((ServerSocket)new ServerSocket());
    }

    @Test
    public void testCloseQuietly_ServerSocketIOException() throws IOException {
        IOUtils.closeQuietly((ServerSocket)new ServerSocket(){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        });
    }

    @Test
    public void testCloseQuietly_Socket() {
        IOUtils.closeQuietly((Socket)null);
        IOUtils.closeQuietly((Socket)new Socket());
    }

    @Test
    public void testCloseQuietly_SocketIOException() {
        IOUtils.closeQuietly((Socket)new Socket(){

            @Override
            public synchronized void close() throws IOException {
                throw new IOException();
            }
        });
    }

    @Test
    public void testConstants() throws Exception {
        Assert.assertEquals((long)47L, (long)47L);
        Assert.assertEquals((long)92L, (long)92L);
        Assert.assertEquals((Object)"\n", (Object)"\n");
        Assert.assertEquals((Object)"\r\n", (Object)"\r\n");
        if (WINDOWS) {
            Assert.assertEquals((long)92L, (long)IOUtils.DIR_SEPARATOR);
            Assert.assertEquals((Object)"\r\n", (Object)IOUtils.LINE_SEPARATOR);
        } else {
            Assert.assertEquals((long)47L, (long)IOUtils.DIR_SEPARATOR);
            Assert.assertEquals((Object)"\n", (Object)IOUtils.LINE_SEPARATOR);
        }
    }

    @Test
    public void testContentEquals_InputStream_InputStream() throws Exception {
        ByteArrayInputStream input1 = new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)input1, (InputStream)input1));
        input1 = new ByteArrayInputStream("ABC".getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)input1, (InputStream)input1));
        Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8))));
        Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)new BufferedInputStream(new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8))), (InputStream)new BufferedInputStream(new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)))));
        Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream("ABC".getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream("ABC".getBytes(StandardCharsets.UTF_8))));
        Assert.assertFalse((boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream("ABCD".getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream("ABC".getBytes(StandardCharsets.UTF_8))));
        Assert.assertFalse((boolean)IOUtils.contentEquals((InputStream)new ByteArrayInputStream("ABC".getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream("ABCD".getBytes(StandardCharsets.UTF_8))));
    }

    @Test
    public void testContentEquals_Reader_Reader() throws Exception {
        StringReader input1 = new StringReader("");
        Assert.assertTrue((boolean)IOUtils.contentEquals((Reader)input1, (Reader)input1));
        input1 = new StringReader("ABC");
        Assert.assertTrue((boolean)IOUtils.contentEquals((Reader)input1, (Reader)input1));
        Assert.assertTrue((boolean)IOUtils.contentEquals((Reader)new StringReader(""), (Reader)new StringReader("")));
        Assert.assertTrue((boolean)IOUtils.contentEquals((Reader)new BufferedReader(new StringReader("")), (Reader)new BufferedReader(new StringReader(""))));
        Assert.assertTrue((boolean)IOUtils.contentEquals((Reader)new StringReader("ABC"), (Reader)new StringReader("ABC")));
        Assert.assertFalse((boolean)IOUtils.contentEquals((Reader)new StringReader("ABCD"), (Reader)new StringReader("ABC")));
        Assert.assertFalse((boolean)IOUtils.contentEquals((Reader)new StringReader("ABC"), (Reader)new StringReader("ABCD")));
    }

    @Test
    public void testContentEqualsIgnoreEOL() throws Exception {
        CharArrayReader input1 = new CharArrayReader("".toCharArray());
        Assert.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)input1, (Reader)input1));
        input1 = new CharArrayReader("321\r\n".toCharArray());
        Assert.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)input1, (Reader)input1));
        CharArrayReader r1 = new CharArrayReader("".toCharArray());
        CharArrayReader r2 = new CharArrayReader("".toCharArray());
        Assert.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)r1, (Reader)r2));
        r1 = new CharArrayReader("1".toCharArray());
        r2 = new CharArrayReader("1".toCharArray());
        Assert.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)r1, (Reader)r2));
        r1 = new CharArrayReader("1".toCharArray());
        r2 = new CharArrayReader("2".toCharArray());
        Assert.assertFalse((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)r1, (Reader)r2));
        r1 = new CharArrayReader("123\rabc".toCharArray());
        r2 = new CharArrayReader("123\nabc".toCharArray());
        Assert.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)r1, (Reader)r2));
        r1 = new CharArrayReader("321".toCharArray());
        r2 = new CharArrayReader("321\r\n".toCharArray());
        Assert.assertTrue((boolean)IOUtils.contentEqualsIgnoreEOL((Reader)r1, (Reader)r2));
    }

    @Test
    public void testCopy_ByteArray_OutputStream() throws Exception {
        byte[] in;
        File destination = TestUtils.newFile(this.getTestDirectory(), "copy8.txt");
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            in = IOUtils.toByteArray((InputStream)fin);
        }
        var4_3 = null;
        try (FileOutputStream fout = new FileOutputStream(destination);){
            CopyUtils.copy((byte[])in, (OutputStream)fout);
            fout.flush();
            TestUtils.checkFile(destination, this.m_testFile);
            TestUtils.checkWrite(fout);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        TestUtils.deleteFile(destination);
    }

    @Test
    public void testCopy_ByteArray_Writer() throws Exception {
        byte[] in;
        File destination = TestUtils.newFile(this.getTestDirectory(), "copy7.txt");
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            in = IOUtils.toByteArray((InputStream)fin);
        }
        var4_3 = null;
        try (FileWriter fout = new FileWriter(destination);){
            CopyUtils.copy((byte[])in, (Writer)fout);
            fout.flush();
            TestUtils.checkFile(destination, this.m_testFile);
            TestUtils.checkWrite(fout);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        TestUtils.deleteFile(destination);
    }

    @Test
    public void testCopy_String_Writer() throws Exception {
        String str;
        File destination = TestUtils.newFile(this.getTestDirectory(), "copy6.txt");
        try (FileReader fin = new FileReader(this.m_testFile);){
            str = IOUtils.toString((Reader)fin);
        }
        var4_3 = null;
        try (FileWriter fout = new FileWriter(destination);){
            CopyUtils.copy((String)str, (Writer)fout);
            fout.flush();
            TestUtils.checkFile(destination, this.m_testFile);
            TestUtils.checkWrite(fout);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        TestUtils.deleteFile(destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_CharExtraLength() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            Assert.assertEquals((long)200L, (long)IOUtils.copyLarge((Reader)is, (Writer)os, (long)0L, (long)2000L));
            char[] oarr = os.toCharArray();
            Assert.assertEquals((long)200L, (long)oarr.length);
            Assert.assertEquals((long)1L, (long)oarr[1]);
            Assert.assertEquals((long)79L, (long)oarr[79]);
            Assert.assertEquals((long)65535L, (long)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_CharFullLength() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            Assert.assertEquals((long)200L, (long)IOUtils.copyLarge((Reader)is, (Writer)os, (long)0L, (long)-1L));
            char[] oarr = os.toCharArray();
            Assert.assertEquals((long)200L, (long)oarr.length);
            Assert.assertEquals((long)1L, (long)oarr[1]);
            Assert.assertEquals((long)79L, (long)oarr[79]);
            Assert.assertEquals((long)65535L, (long)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_CharNoSkip() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            Assert.assertEquals((long)100L, (long)IOUtils.copyLarge((Reader)is, (Writer)os, (long)0L, (long)100L));
            char[] oarr = os.toCharArray();
            Assert.assertEquals((long)100L, (long)oarr.length);
            Assert.assertEquals((long)1L, (long)oarr[1]);
            Assert.assertEquals((long)79L, (long)oarr[79]);
            Assert.assertEquals((long)65535L, (long)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_CharSkip() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            Assert.assertEquals((long)100L, (long)IOUtils.copyLarge((Reader)is, (Writer)os, (long)10L, (long)100L));
            char[] oarr = os.toCharArray();
            Assert.assertEquals((long)100L, (long)oarr.length);
            Assert.assertEquals((long)11L, (long)oarr[1]);
            Assert.assertEquals((long)79L, (long)oarr[69]);
            Assert.assertEquals((long)65535L, (long)oarr[70]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_CharSkipInvalid() throws IOException {
        CharArrayReader is = null;
        CharArrayWriter os = null;
        try {
            is = new CharArrayReader(this.carr);
            os = new CharArrayWriter();
            IOUtils.copyLarge((Reader)is, (Writer)os, (long)1000L, (long)100L);
            Assert.fail((String)"Should have thrown EOFException");
        }
        catch (EOFException eOFException) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)is);
        IOUtils.closeQuietly((Writer)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_ExtraLength() throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(this.iarr);
            os = new ByteArrayOutputStream();
            Assert.assertEquals((long)200L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)0L, (long)2000L));
            byte[] oarr = os.toByteArray();
            Assert.assertEquals((long)200L, (long)oarr.length);
            Assert.assertEquals((long)1L, (long)oarr[1]);
            Assert.assertEquals((long)79L, (long)oarr[79]);
            Assert.assertEquals((long)-1L, (long)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_FullLength() throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(this.iarr);
            os = new ByteArrayOutputStream();
            Assert.assertEquals((long)200L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)0L, (long)-1L));
            byte[] oarr = os.toByteArray();
            Assert.assertEquals((long)200L, (long)oarr.length);
            Assert.assertEquals((long)1L, (long)oarr[1]);
            Assert.assertEquals((long)79L, (long)oarr[79]);
            Assert.assertEquals((long)-1L, (long)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_NoSkip() throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(this.iarr);
            os = new ByteArrayOutputStream();
            Assert.assertEquals((long)100L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)0L, (long)100L));
            byte[] oarr = os.toByteArray();
            Assert.assertEquals((long)100L, (long)oarr.length);
            Assert.assertEquals((long)1L, (long)oarr[1]);
            Assert.assertEquals((long)79L, (long)oarr[79]);
            Assert.assertEquals((long)-1L, (long)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_Skip() throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(this.iarr);
            os = new ByteArrayOutputStream();
            Assert.assertEquals((long)100L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)10L, (long)100L));
            byte[] oarr = os.toByteArray();
            Assert.assertEquals((long)100L, (long)oarr.length);
            Assert.assertEquals((long)11L, (long)oarr[1]);
            Assert.assertEquals((long)79L, (long)oarr[69]);
            Assert.assertEquals((long)-1L, (long)oarr[70]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_SkipInvalid() throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(this.iarr);
            os = new ByteArrayOutputStream();
            IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)1000L, (long)100L);
            Assert.fail((String)"Should have thrown EOFException");
        }
        catch (EOFException eOFException) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRead_ReadableByteChannel() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(4097);
        FileInputStream fileInputStream = new FileInputStream(this.m_testFile);
        FileChannel input = fileInputStream.getChannel();
        try {
            Assert.assertEquals((long)4097L, (long)IOUtils.read((ReadableByteChannel)input, (ByteBuffer)buffer));
            Assert.assertEquals((long)0L, (long)IOUtils.read((ReadableByteChannel)input, (ByteBuffer)buffer));
            Assert.assertEquals((long)0L, (long)buffer.remaining());
            Assert.assertEquals((long)0L, (long)input.read(buffer));
            buffer.clear();
            try {
                IOUtils.readFully((ReadableByteChannel)input, (ByteBuffer)buffer);
                Assert.fail((String)"Should have failed with EOFxception");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable[])new Closeable[]{input, fileInputStream});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{input, fileInputStream});
    }

    @Test
    public void testReadFully_InputStream_ByteArray() throws Exception {
        int size = 1027;
        byte[] buffer = new byte[1027];
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[1027]);
        try {
            IOUtils.readFully((InputStream)input, (byte[])buffer, (int)0, (int)-1);
            Assert.fail((String)"Should have failed with IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        IOUtils.readFully((InputStream)input, (byte[])buffer, (int)0, (int)0);
        IOUtils.readFully((InputStream)input, (byte[])buffer, (int)0, (int)1026);
        try {
            IOUtils.readFully((InputStream)input, (byte[])buffer, (int)0, (int)2);
            Assert.fail((String)"Should have failed with EOFxception");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    @Test
    public void testReadFully_InputStream__ReturnByteArray() throws Exception {
        byte[] bytes = "abcd1234".getBytes("UTF-8");
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        byte[] result = IOUtils.readFully((InputStream)stream, (int)bytes.length);
        IOUtils.closeQuietly((InputStream)stream);
        this.assertEqualContent(result, bytes);
    }

    @Test
    public void testReadFully_InputStream_Offset() throws Exception {
        byte[] bytes = "abcd1234".getBytes("UTF-8");
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        byte[] buffer = "wx00000000".getBytes("UTF-8");
        IOUtils.readFully((InputStream)stream, (byte[])buffer, (int)2, (int)8);
        Assert.assertEquals((Object)"wxabcd1234", (Object)new String(buffer, 0, buffer.length, "UTF-8"));
        IOUtils.closeQuietly((InputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFully_ReadableByteChannel() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(4097);
        FileInputStream fileInputStream = new FileInputStream(this.m_testFile);
        FileChannel input = fileInputStream.getChannel();
        try {
            IOUtils.readFully((ReadableByteChannel)input, (ByteBuffer)buffer);
            Assert.assertEquals((long)4097L, (long)buffer.position());
            Assert.assertEquals((long)0L, (long)buffer.remaining());
            Assert.assertEquals((long)0L, (long)input.read(buffer));
            IOUtils.readFully((ReadableByteChannel)input, (ByteBuffer)buffer);
            Assert.assertEquals((long)4097L, (long)buffer.position());
            Assert.assertEquals((long)0L, (long)buffer.remaining());
            Assert.assertEquals((long)0L, (long)input.read(buffer));
            IOUtils.readFully((ReadableByteChannel)input, (ByteBuffer)buffer);
            buffer.clear();
            try {
                IOUtils.readFully((ReadableByteChannel)input, (ByteBuffer)buffer);
                Assert.fail((String)"Should have failed with EOFxception");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable[])new Closeable[]{input, fileInputStream});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{input, fileInputStream});
    }

    @Test
    public void testReadFully_Reader() throws Exception {
        int size = 1027;
        char[] buffer = new char[1027];
        CharArrayReader input = new CharArrayReader(new char[1027]);
        IOUtils.readFully((Reader)input, (char[])buffer, (int)0, (int)0);
        IOUtils.readFully((Reader)input, (char[])buffer, (int)0, (int)1024);
        try {
            IOUtils.readFully((Reader)input, (char[])buffer, (int)0, (int)-1);
            Assert.fail((String)"Should have failed with IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IOUtils.readFully((Reader)input, (char[])buffer, (int)0, (int)5);
            Assert.fail((String)"Should have failed with EOFException");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        IOUtils.closeQuietly((Reader)input);
    }

    @Test
    public void testReadFully_Reader_Offset() throws Exception {
        StringReader reader = new StringReader("abcd1234");
        char[] buffer = "wx00000000".toCharArray();
        IOUtils.readFully((Reader)reader, (char[])buffer, (int)2, (int)8);
        Assert.assertEquals((Object)"wxabcd1234", (Object)new String(buffer));
        IOUtils.closeQuietly((Reader)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLines_InputStream() throws Exception {
        File file = TestUtils.newFile(this.getTestDirectory(), "lines.txt");
        FileInputStream in = null;
        try {
            String[] data = new String[]{"hello", "world", "", "this is", "some text"};
            TestUtils.createLineBasedFile(file, data);
            in = new FileInputStream(file);
            List lines = IOUtils.readLines((InputStream)in);
            Assert.assertEquals(Arrays.asList(data), (Object)lines);
            Assert.assertEquals((long)-1L, (long)((InputStream)in).read());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            TestUtils.deleteFile(file);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        TestUtils.deleteFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLines_InputStream_String() throws Exception {
        File file = TestUtils.newFile(this.getTestDirectory(), "lines.txt");
        FileInputStream in = null;
        try {
            String[] data = new String[]{"hello", "/u1234", "", "this is", "some text"};
            TestUtils.createLineBasedFile(file, data);
            in = new FileInputStream(file);
            List lines = IOUtils.readLines((InputStream)in, (String)"UTF-8");
            Assert.assertEquals(Arrays.asList(data), (Object)lines);
            Assert.assertEquals((long)-1L, (long)((InputStream)in).read());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            TestUtils.deleteFile(file);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        TestUtils.deleteFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadLines_Reader() throws Exception {
        File file = TestUtils.newFile(this.getTestDirectory(), "lines.txt");
        InputStreamReader in = null;
        try {
            String[] data = new String[]{"hello", "/u1234", "", "this is", "some text"};
            TestUtils.createLineBasedFile(file, data);
            in = new InputStreamReader(new FileInputStream(file));
            List lines = IOUtils.readLines((Reader)in);
            Assert.assertEquals(Arrays.asList(data), (Object)lines);
            Assert.assertEquals((long)-1L, (long)((Reader)in).read());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            TestUtils.deleteFile(file);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        TestUtils.deleteFile(file);
    }

    @Test
    public void testSkip_FileReader() throws Exception {
        try (FileReader in = new FileReader(this.m_testFile);){
            Assert.assertEquals((long)4087L, (long)IOUtils.skip((Reader)in, (long)4087L));
            Assert.assertEquals((long)10L, (long)IOUtils.skip((Reader)in, (long)20L));
            Assert.assertEquals((long)0L, (long)IOUtils.skip((Reader)in, (long)10L));
        }
    }

    @Test
    public void testSkip_InputStream() throws Exception {
        try (FileInputStream in = new FileInputStream(this.m_testFile);){
            Assert.assertEquals((long)4087L, (long)IOUtils.skip((InputStream)in, (long)4087L));
            Assert.assertEquals((long)10L, (long)IOUtils.skip((InputStream)in, (long)20L));
            Assert.assertEquals((long)0L, (long)IOUtils.skip((InputStream)in, (long)10L));
        }
    }

    @Test
    public void testSkip_ReadableByteChannel() throws Exception {
        FileInputStream fileInputStream = new FileInputStream(this.m_testFile);
        FileChannel fileChannel = fileInputStream.getChannel();
        try {
            Assert.assertEquals((long)4087L, (long)IOUtils.skip((ReadableByteChannel)fileChannel, (long)4087L));
            Assert.assertEquals((long)10L, (long)IOUtils.skip((ReadableByteChannel)fileChannel, (long)20L));
            Assert.assertEquals((long)0L, (long)IOUtils.skip((ReadableByteChannel)fileChannel, (long)10L));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable[])new Closeable[]{fileChannel, fileInputStream});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{fileChannel, fileInputStream});
    }

    @Test
    public void testSkipFully_InputStream() throws Exception {
        int size = 1027;
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[1027]);
        try {
            IOUtils.skipFully((InputStream)input, (long)-1L);
            Assert.fail((String)"Should have failed with IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        IOUtils.skipFully((InputStream)input, (long)0L);
        IOUtils.skipFully((InputStream)input, (long)1026L);
        try {
            IOUtils.skipFully((InputStream)input, (long)2L);
            Assert.fail((String)"Should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipFully_ReadableByteChannel() throws Exception {
        FileInputStream fileInputStream = new FileInputStream(this.m_testFile);
        FileChannel fileChannel = fileInputStream.getChannel();
        try {
            try {
                IOUtils.skipFully((ReadableByteChannel)fileChannel, (long)-1L);
                Assert.fail((String)"Should have failed with IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            IOUtils.skipFully((ReadableByteChannel)fileChannel, (long)0L);
            IOUtils.skipFully((ReadableByteChannel)fileChannel, (long)4096L);
            try {
                IOUtils.skipFully((ReadableByteChannel)fileChannel, (long)2L);
                Assert.fail((String)"Should have failed with IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable[])new Closeable[]{fileChannel, fileInputStream});
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable[])new Closeable[]{fileChannel, fileInputStream});
    }

    @Test
    public void testSkipFully_Reader() throws Exception {
        int size = 1027;
        CharArrayReader input = new CharArrayReader(new char[1027]);
        IOUtils.skipFully((Reader)input, (long)0L);
        IOUtils.skipFully((Reader)input, (long)1024L);
        try {
            IOUtils.skipFully((Reader)input, (long)-1L);
            Assert.fail((String)"Should have failed with IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IOUtils.skipFully((Reader)input, (long)5L);
            Assert.fail((String)"Should have failed with IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IOUtils.closeQuietly((Reader)input);
    }

    @Test
    public void testStringToOutputStream() throws Exception {
        String str;
        File destination = TestUtils.newFile(this.getTestDirectory(), "copy5.txt");
        try (FileReader fin = new FileReader(this.m_testFile);){
            str = IOUtils.toString((Reader)fin);
        }
        var4_3 = null;
        try (FileOutputStream fout = new FileOutputStream(destination);){
            CopyUtils.copy((String)str, (OutputStream)fout);
            TestUtils.checkFile(destination, this.m_testFile);
            TestUtils.checkWrite(fout);
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        TestUtils.deleteFile(destination);
    }

    @Test
    public void testToBufferedInputStream_InputStream() throws Exception {
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            InputStream in = IOUtils.toBufferedInputStream((InputStream)fin);
            byte[] out = IOUtils.toByteArray((InputStream)in);
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((String)"Not all bytes were read", (long)0L, (long)fin.available());
            Assert.assertEquals((String)"Wrong output size", (long)4097L, (long)out.length);
            TestUtils.assertEqualContent(out, this.m_testFile);
        }
    }

    @Test
    public void testToBufferedInputStreamWithBufferSize_InputStream() throws Exception {
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            InputStream in = IOUtils.toBufferedInputStream((InputStream)fin, (int)2048);
            byte[] out = IOUtils.toByteArray((InputStream)in);
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((String)"Not all bytes were read", (long)0L, (long)fin.available());
            Assert.assertEquals((String)"Wrong output size", (long)4097L, (long)out.length);
            TestUtils.assertEqualContent(out, this.m_testFile);
        }
    }

    @Test
    public void testToByteArray_InputStream() throws Exception {
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            byte[] out = IOUtils.toByteArray((InputStream)fin);
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((String)"Not all bytes were read", (long)0L, (long)fin.available());
            Assert.assertEquals((String)"Wrong output size", (long)4097L, (long)out.length);
            TestUtils.assertEqualContent(out, this.m_testFile);
        }
    }

    @Test
    public void testToByteArray_InputStream_NegativeSize() throws Exception {
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            IOUtils.toByteArray((InputStream)fin, (int)-1);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException exc) {
            Assert.assertTrue((String)"Exception message does not start with \"Size must be equal or greater than zero\"", (boolean)exc.getMessage().startsWith("Size must be equal or greater than zero"));
        }
    }

    @Test
    public void testToByteArray_InputStream_Size() throws Exception {
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            byte[] out = IOUtils.toByteArray((InputStream)fin, (long)this.m_testFile.length());
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((String)"Not all bytes were read", (long)0L, (long)fin.available());
            Assert.assertEquals((String)("Wrong output size: out.length=" + out.length + "!=" + 4097), (long)4097L, (long)out.length);
            TestUtils.assertEqualContent(out, this.m_testFile);
        }
    }

    @Test
    public void testToByteArray_InputStream_SizeIllegal() throws Exception {
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            IOUtils.toByteArray((InputStream)fin, (long)(this.m_testFile.length() + 1L));
            Assert.fail((String)"IOException expected");
        }
        catch (IOException exc) {
            Assert.assertTrue((String)"Exception message does not start with \"Unexpected read size\"", (boolean)exc.getMessage().startsWith("Unexpected read size"));
        }
    }

    @Test
    public void testToByteArray_InputStream_SizeLong() throws Exception {
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            IOUtils.toByteArray((InputStream)fin, (long)0x80000000L);
            Assert.fail((String)"IOException expected");
        }
        catch (IllegalArgumentException exc) {
            Assert.assertTrue((String)"Exception message does not start with \"Size cannot be greater than Integer max value\"", (boolean)exc.getMessage().startsWith("Size cannot be greater than Integer max value"));
        }
    }

    @Test
    public void testToByteArray_InputStream_SizeZero() throws Exception {
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            byte[] out = IOUtils.toByteArray((InputStream)fin, (int)0);
            Assert.assertNotNull((String)"Out cannot be null", (Object)out);
            Assert.assertEquals((String)"Out length must be 0", (long)0L, (long)out.length);
        }
    }

    @Test
    public void testToByteArray_Reader() throws IOException {
        String charsetName = "UTF-8";
        byte[] expecteds = "UTF-8".getBytes("UTF-8");
        byte[] actuals = IOUtils.toByteArray((Reader)new InputStreamReader(new ByteArrayInputStream(expecteds)));
        Assert.assertArrayEquals((byte[])expecteds, (byte[])actuals);
        actuals = IOUtils.toByteArray((Reader)new InputStreamReader(new ByteArrayInputStream(expecteds)), (String)"UTF-8");
        Assert.assertArrayEquals((byte[])expecteds, (byte[])actuals);
    }

    @Test
    public void testToByteArray_String() throws Exception {
        try (FileReader fin = new FileReader(this.m_testFile);){
            String str = IOUtils.toString((Reader)fin);
            byte[] out = IOUtils.toByteArray((String)str);
            this.assertEqualContent(str.getBytes(), out);
        }
    }

    @Test
    public void testToByteArray_URI() throws Exception {
        URI url = this.m_testFile.toURI();
        byte[] actual = IOUtils.toByteArray((URI)url);
        Assert.assertEquals((long)4097L, (long)actual.length);
    }

    @Test
    public void testToByteArray_URL() throws Exception {
        URL url = this.m_testFile.toURI().toURL();
        byte[] actual = IOUtils.toByteArray((URL)url);
        Assert.assertEquals((long)4097L, (long)actual.length);
    }

    @Test
    public void testToByteArray_URLConnection() throws Exception {
        byte[] actual;
        URLConnection urlConn = this.m_testFile.toURI().toURL().openConnection();
        try {
            actual = IOUtils.toByteArray((URLConnection)urlConn);
        }
        finally {
            IOUtils.close((URLConnection)urlConn);
        }
        Assert.assertEquals((long)4097L, (long)actual.length);
    }

    @Test
    public void testToCharArray_InputStream() throws Exception {
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            char[] out = IOUtils.toCharArray((InputStream)fin);
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((String)"Not all chars were read", (long)0L, (long)fin.available());
            Assert.assertEquals((String)"Wrong output size", (long)4097L, (long)out.length);
            TestUtils.assertEqualContent(out, this.m_testFile);
        }
    }

    @Test
    public void testToCharArray_InputStream_CharsetName() throws Exception {
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            char[] out = IOUtils.toCharArray((InputStream)fin, (String)"UTF-8");
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((String)"Not all chars were read", (long)0L, (long)fin.available());
            Assert.assertEquals((String)"Wrong output size", (long)4097L, (long)out.length);
            TestUtils.assertEqualContent(out, this.m_testFile);
        }
    }

    @Test
    public void testToCharArray_Reader() throws Exception {
        try (FileReader fr = new FileReader(this.m_testFile);){
            char[] out = IOUtils.toCharArray((Reader)fr);
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((String)"Wrong output size", (long)4097L, (long)out.length);
            TestUtils.assertEqualContent(out, this.m_testFile);
        }
    }

    @Test
    public void testToInputStream_CharSequence() throws Exception {
        StringBuilder csq = new StringBuilder("Abc123Xyz!");
        InputStream inStream = IOUtils.toInputStream((CharSequence)csq);
        byte[] bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent(csq.toString().getBytes(), bytes);
        inStream = IOUtils.toInputStream((CharSequence)csq, (String)null);
        bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent(csq.toString().getBytes(), bytes);
        inStream = IOUtils.toInputStream((CharSequence)csq, (String)"UTF-8");
        bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent(csq.toString().getBytes("UTF-8"), bytes);
    }

    @Test
    public void testToInputStream_String() throws Exception {
        String str = "Abc123Xyz!";
        InputStream inStream = IOUtils.toInputStream((String)"Abc123Xyz!");
        byte[] bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent("Abc123Xyz!".getBytes(), bytes);
        inStream = IOUtils.toInputStream((String)"Abc123Xyz!", (String)null);
        bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent("Abc123Xyz!".getBytes(), bytes);
        inStream = IOUtils.toInputStream((String)"Abc123Xyz!", (String)"UTF-8");
        bytes = IOUtils.toByteArray((InputStream)inStream);
        this.assertEqualContent("Abc123Xyz!".getBytes("UTF-8"), bytes);
    }

    @Test
    public void testToString_ByteArray() throws Exception {
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            byte[] in = IOUtils.toByteArray((InputStream)fin);
            String str = IOUtils.toString((byte[])in);
            this.assertEqualContent(in, str.getBytes());
        }
    }

    @Test
    public void testToString_InputStream() throws Exception {
        try (FileInputStream fin = new FileInputStream(this.m_testFile);){
            String out = IOUtils.toString((InputStream)fin);
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((String)"Not all bytes were read", (long)0L, (long)fin.available());
            Assert.assertEquals((String)"Wrong output size", (long)4097L, (long)out.length());
        }
    }

    @Test
    public void testToString_Reader() throws Exception {
        try (FileReader fin = new FileReader(this.m_testFile);){
            String out = IOUtils.toString((Reader)fin);
            Assert.assertNotNull((Object)out);
            Assert.assertEquals((String)"Wrong output size", (long)4097L, (long)out.length());
        }
    }

    @Test
    public void testToString_URI() throws Exception {
        URI url = this.m_testFile.toURI();
        String out = IOUtils.toString((URI)url);
        Assert.assertNotNull((Object)out);
        Assert.assertEquals((String)"Wrong output size", (long)4097L, (long)out.length());
    }

    private void testToString_URI(String encoding) throws Exception {
        URI uri = this.m_testFile.toURI();
        String out = IOUtils.toString((URI)uri, (String)encoding);
        Assert.assertNotNull((Object)out);
        Assert.assertEquals((String)"Wrong output size", (long)4097L, (long)out.length());
    }

    @Test
    public void testToString_URI_CharsetName() throws Exception {
        this.testToString_URI("US-ASCII");
    }

    @Test
    public void testToString_URI_CharsetNameNull() throws Exception {
        this.testToString_URI(null);
    }

    @Test
    public void testToString_URL() throws Exception {
        URL url = this.m_testFile.toURI().toURL();
        String out = IOUtils.toString((URL)url);
        Assert.assertNotNull((Object)out);
        Assert.assertEquals((String)"Wrong output size", (long)4097L, (long)out.length());
    }

    private void testToString_URL(String encoding) throws Exception {
        URL url = this.m_testFile.toURI().toURL();
        String out = IOUtils.toString((URL)url, (String)encoding);
        Assert.assertNotNull((Object)out);
        Assert.assertEquals((String)"Wrong output size", (long)4097L, (long)out.length());
    }

    @Test
    public void testToString_URL_CharsetName() throws Exception {
        this.testToString_URL("US-ASCII");
    }

    @Test
    public void testToString_URL_CharsetNameNull() throws Exception {
        this.testToString_URL(null);
    }

    @Test
    public void testResourceToString_ExistingResourceAtRootPackage() throws Exception {
        long fileSize = new File(this.getClass().getResource("/test-file-simple-utf8.bin").getFile()).length();
        String content = IOUtils.resourceToString((String)"/test-file-simple-utf8.bin", (Charset)StandardCharsets.UTF_8);
        Assert.assertNotNull((Object)content);
        Assert.assertEquals((long)fileSize, (long)content.getBytes().length);
    }

    @Test
    public void testResourceToString_ExistingResourceAtRootPackage_WithClassLoader() throws Exception {
        long fileSize = new File(this.getClass().getResource("/test-file-simple-utf8.bin").getFile()).length();
        String content = IOUtils.resourceToString((String)"test-file-simple-utf8.bin", (Charset)StandardCharsets.UTF_8, (ClassLoader)ClassLoader.getSystemClassLoader());
        Assert.assertNotNull((Object)content);
        Assert.assertEquals((long)fileSize, (long)content.getBytes().length);
    }

    @Test
    public void testResourceToString_ExistingResourceAtSubPackage() throws Exception {
        long fileSize = new File(this.getClass().getResource("/org/apache/commons/io/FileUtilsTestDataCR.dat").getFile()).length();
        String content = IOUtils.resourceToString((String)"/org/apache/commons/io/FileUtilsTestDataCR.dat", (Charset)StandardCharsets.UTF_8);
        Assert.assertNotNull((Object)content);
        Assert.assertEquals((long)fileSize, (long)content.getBytes().length);
    }

    @Test
    public void testResourceToString_ExistingResourceAtSubPackage_WithClassLoader() throws Exception {
        long fileSize = new File(this.getClass().getResource("/org/apache/commons/io/FileUtilsTestDataCR.dat").getFile()).length();
        String content = IOUtils.resourceToString((String)"org/apache/commons/io/FileUtilsTestDataCR.dat", (Charset)StandardCharsets.UTF_8, (ClassLoader)ClassLoader.getSystemClassLoader());
        Assert.assertNotNull((Object)content);
        Assert.assertEquals((long)fileSize, (long)content.getBytes().length);
    }

    @Test(expected=IOException.class)
    public void testResourceToString_NonExistingResource() throws Exception {
        IOUtils.resourceToString((String)"/non-existing-file.bin", (Charset)StandardCharsets.UTF_8);
    }

    @Test(expected=IOException.class)
    public void testResourceToString_NonExistingResource_WithClassLoader() throws Exception {
        IOUtils.resourceToString((String)"non-existing-file.bin", (Charset)StandardCharsets.UTF_8, (ClassLoader)ClassLoader.getSystemClassLoader());
    }

    @Test
    public void testResourceToString_NullResource() throws Exception {
        boolean exceptionOccurred = false;
        try {
            IOUtils.resourceToString(null, (Charset)StandardCharsets.UTF_8);
            Assert.fail();
        }
        catch (NullPointerException npe) {
            exceptionOccurred = true;
            Assert.assertNotNull((Object)npe);
        }
        Assert.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testResourceToString_NullResource_WithClassLoader() throws Exception {
        boolean exceptionOccurred = false;
        try {
            IOUtils.resourceToString(null, (Charset)StandardCharsets.UTF_8, (ClassLoader)ClassLoader.getSystemClassLoader());
            Assert.fail();
        }
        catch (NullPointerException npe) {
            exceptionOccurred = true;
            Assert.assertNotNull((Object)npe);
        }
        Assert.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testResourceToString_NullCharset() throws Exception {
        IOUtils.resourceToString((String)"/test-file-utf8.bin", null);
    }

    @Test
    public void testResourceToString_NullCharset_WithClassLoader() throws Exception {
        IOUtils.resourceToString((String)"test-file-utf8.bin", null, (ClassLoader)ClassLoader.getSystemClassLoader());
    }

    @Test
    public void testResourceToByteArray_ExistingResourceAtRootPackage() throws Exception {
        long fileSize = new File(this.getClass().getResource("/test-file-utf8.bin").getFile()).length();
        byte[] bytes = IOUtils.resourceToByteArray((String)"/test-file-utf8.bin");
        Assert.assertNotNull((Object)bytes);
        Assert.assertEquals((long)fileSize, (long)bytes.length);
    }

    @Test
    public void testResourceToByteArray_ExistingResourceAtRootPackage_WithClassLoader() throws Exception {
        long fileSize = new File(this.getClass().getResource("/test-file-utf8.bin").getFile()).length();
        byte[] bytes = IOUtils.resourceToByteArray((String)"test-file-utf8.bin", (ClassLoader)ClassLoader.getSystemClassLoader());
        Assert.assertNotNull((Object)bytes);
        Assert.assertEquals((long)fileSize, (long)bytes.length);
    }

    @Test
    public void testResourceToByteArray_ExistingResourceAtSubPackage() throws Exception {
        long fileSize = new File(this.getClass().getResource("/org/apache/commons/io/FileUtilsTestDataCR.dat").getFile()).length();
        byte[] bytes = IOUtils.resourceToByteArray((String)"/org/apache/commons/io/FileUtilsTestDataCR.dat");
        Assert.assertNotNull((Object)bytes);
        Assert.assertEquals((long)fileSize, (long)bytes.length);
    }

    @Test
    public void testResourceToByteArray_ExistingResourceAtSubPackage_WithClassLoader() throws Exception {
        long fileSize = new File(this.getClass().getResource("/org/apache/commons/io/FileUtilsTestDataCR.dat").getFile()).length();
        byte[] bytes = IOUtils.resourceToByteArray((String)"org/apache/commons/io/FileUtilsTestDataCR.dat", (ClassLoader)ClassLoader.getSystemClassLoader());
        Assert.assertNotNull((Object)bytes);
        Assert.assertEquals((long)fileSize, (long)bytes.length);
    }

    @Test(expected=IOException.class)
    public void testResourceToByteArray_NonExistingResource() throws Exception {
        IOUtils.resourceToByteArray((String)"/non-existing-file.bin");
    }

    @Test(expected=IOException.class)
    public void testResourceToByteArray_NonExistingResource_WithClassLoader() throws Exception {
        IOUtils.resourceToByteArray((String)"non-existing-file.bin", (ClassLoader)ClassLoader.getSystemClassLoader());
    }

    @Test
    public void testResourceToByteArray_Null() throws Exception {
        boolean exceptionOccurred = false;
        try {
            IOUtils.resourceToByteArray(null);
            Assert.fail();
        }
        catch (NullPointerException npe) {
            exceptionOccurred = true;
            Assert.assertNotNull((Object)npe);
        }
        Assert.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testResourceToByteArray_Null_WithClassLoader() throws Exception {
        boolean exceptionOccurred = false;
        try {
            IOUtils.resourceToByteArray(null, (ClassLoader)ClassLoader.getSystemClassLoader());
            Assert.fail();
        }
        catch (NullPointerException npe) {
            exceptionOccurred = true;
            Assert.assertNotNull((Object)npe);
        }
        Assert.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testResourceToURL_ExistingResourceAtRootPackage() throws Exception {
        URL url = IOUtils.resourceToURL((String)"/test-file-utf8.bin");
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.getFile().endsWith("/test-file-utf8.bin"));
    }

    @Test
    public void testResourceToURL_ExistingResourceAtRootPackage_WithClassLoader() throws Exception {
        URL url = IOUtils.resourceToURL((String)"test-file-utf8.bin", (ClassLoader)ClassLoader.getSystemClassLoader());
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.getFile().endsWith("/test-file-utf8.bin"));
    }

    @Test
    public void testResourceToURL_ExistingResourceAtSubPackage() throws Exception {
        URL url = IOUtils.resourceToURL((String)"/org/apache/commons/io/FileUtilsTestDataCR.dat");
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.getFile().endsWith("/org/apache/commons/io/FileUtilsTestDataCR.dat"));
    }

    @Test
    public void testResourceToURL_ExistingResourceAtSubPackage_WithClassLoader() throws Exception {
        URL url = IOUtils.resourceToURL((String)"org/apache/commons/io/FileUtilsTestDataCR.dat", (ClassLoader)ClassLoader.getSystemClassLoader());
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.getFile().endsWith("/org/apache/commons/io/FileUtilsTestDataCR.dat"));
    }

    @Test(expected=IOException.class)
    public void testResourceToURL_NonExistingResource() throws Exception {
        IOUtils.resourceToURL((String)"/non-existing-file.bin");
    }

    @Test(expected=IOException.class)
    public void testResourceToURL_NonExistingResource_WithClassLoader() throws Exception {
        IOUtils.resourceToURL((String)"non-existing-file.bin", (ClassLoader)ClassLoader.getSystemClassLoader());
    }

    @Test
    public void testResourceToURL_Null() throws Exception {
        boolean exceptionOccurred = false;
        try {
            IOUtils.resourceToURL(null);
            Assert.fail();
        }
        catch (NullPointerException npe) {
            exceptionOccurred = true;
            Assert.assertNotNull((Object)npe);
        }
        Assert.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testResourceToURL_Null_WithClassLoader() throws Exception {
        boolean exceptionOccurred = false;
        try {
            IOUtils.resourceToURL(null, (ClassLoader)ClassLoader.getSystemClassLoader());
            Assert.fail();
        }
        catch (NullPointerException npe) {
            exceptionOccurred = true;
            Assert.assertNotNull((Object)npe);
        }
        Assert.assertTrue((boolean)exceptionOccurred);
    }

    @Test
    public void testAsBufferedNull() {
        try {
            IOUtils.buffer((InputStream)null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOUtils.buffer((OutputStream)null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOUtils.buffer((Reader)null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            IOUtils.buffer((Writer)null);
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testAsBufferedInputStream() {
        InputStream is = new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        };
        BufferedInputStream bis = IOUtils.buffer((InputStream)is);
        Assert.assertNotSame((Object)is, (Object)bis);
        Assert.assertSame((Object)bis, (Object)IOUtils.buffer((InputStream)bis));
    }

    @Test
    public void testAsBufferedInputStreamWithBufferSize() {
        InputStream is = new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        };
        BufferedInputStream bis = IOUtils.buffer((InputStream)is, (int)2048);
        Assert.assertNotSame((Object)is, (Object)bis);
        Assert.assertSame((Object)bis, (Object)IOUtils.buffer((InputStream)bis));
        Assert.assertSame((Object)bis, (Object)IOUtils.buffer((InputStream)bis, (int)1024));
    }

    @Test
    public void testAsBufferedOutputStream() {
        OutputStream is = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
        BufferedOutputStream bis = IOUtils.buffer((OutputStream)is);
        Assert.assertNotSame((Object)is, (Object)bis);
        Assert.assertSame((Object)bis, (Object)IOUtils.buffer((OutputStream)bis));
    }

    @Test
    public void testAsBufferedOutputStreamWithBufferSize() {
        OutputStream os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
        BufferedOutputStream bos = IOUtils.buffer((OutputStream)os, (int)2048);
        Assert.assertNotSame((Object)os, (Object)bos);
        Assert.assertSame((Object)bos, (Object)IOUtils.buffer((OutputStream)bos));
        Assert.assertSame((Object)bos, (Object)IOUtils.buffer((OutputStream)bos, (int)1024));
    }

    @Test
    public void testAsBufferedReader() {
        Reader is = new Reader(){

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return 0;
            }

            @Override
            public void close() throws IOException {
            }
        };
        BufferedReader bis = IOUtils.buffer((Reader)is);
        Assert.assertNotSame((Object)is, (Object)bis);
        Assert.assertSame((Object)bis, (Object)IOUtils.buffer((Reader)bis));
    }

    @Test
    public void testAsBufferedReaderWithBufferSize() {
        Reader r = new Reader(){

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return 0;
            }

            @Override
            public void close() throws IOException {
            }
        };
        BufferedReader br = IOUtils.buffer((Reader)r, (int)2048);
        Assert.assertNotSame((Object)r, (Object)br);
        Assert.assertSame((Object)br, (Object)IOUtils.buffer((Reader)br));
        Assert.assertSame((Object)br, (Object)IOUtils.buffer((Reader)br, (int)1024));
    }

    @Test
    public void testAsBufferedWriter() {
        Writer is = new Writer(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        BufferedWriter bis = IOUtils.buffer((Writer)is);
        Assert.assertNotSame((Object)is, (Object)bis);
        Assert.assertSame((Object)bis, (Object)IOUtils.buffer((Writer)bis));
    }

    @Test
    public void testAsBufferedWriterWithBufferSize() {
        Writer w = new Writer(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        BufferedWriter bw = IOUtils.buffer((Writer)w, (int)2024);
        Assert.assertNotSame((Object)w, (Object)bw);
        Assert.assertSame((Object)bw, (Object)IOUtils.buffer((Writer)bw));
        Assert.assertSame((Object)bw, (Object)IOUtils.buffer((Writer)bw, (int)1024));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyLarge_SkipWithInvalidOffset() throws IOException {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            is = new ByteArrayInputStream(this.iarr);
            os = new ByteArrayOutputStream();
            Assert.assertEquals((long)100L, (long)IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)-10L, (long)100L));
            byte[] oarr = os.toByteArray();
            Assert.assertEquals((long)100L, (long)oarr.length);
            Assert.assertEquals((long)1L, (long)oarr[1]);
            Assert.assertEquals((long)79L, (long)oarr[79]);
            Assert.assertEquals((long)-1L, (long)oarr[80]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }
}

