/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.util.Comparator;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.ComparatorAbstractTestCase;
import org.apache.commons.io.comparator.PathFileComparator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PathFileComparatorTest
extends ComparatorAbstractTestCase {
    @Before
    public void setUp() throws Exception {
        this.comparator = (AbstractFileComparator)PathFileComparator.PATH_COMPARATOR;
        this.reverse = PathFileComparator.PATH_REVERSE;
        this.equalFile1 = new File("foo/file.txt");
        this.equalFile2 = new File("foo/file.txt");
        this.lessFile = new File("abc/file.txt");
        this.moreFile = new File("xyz/file.txt");
    }

    @Test
    public void testCaseSensitivity() {
        File file3 = new File("FOO/file.txt");
        PathFileComparator sensitive = new PathFileComparator(null);
        Assert.assertTrue((String)"sensitive file1 & file2 = 0", (sensitive.compare(this.equalFile1, this.equalFile2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"sensitive file1 & file3 > 0", (sensitive.compare(this.equalFile1, file3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"sensitive file1 & less  > 0", (sensitive.compare(this.equalFile1, this.lessFile) > 0 ? 1 : 0) != 0);
        Comparator insensitive = PathFileComparator.PATH_INSENSITIVE_COMPARATOR;
        Assert.assertTrue((String)"insensitive file1 & file2 = 0", (insensitive.compare(this.equalFile1, this.equalFile2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"insensitive file1 & file3 = 0", (insensitive.compare(this.equalFile1, file3) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"insensitive file1 & file4 > 0", (insensitive.compare(this.equalFile1, this.lessFile) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"insensitive file3 & less  > 0", (insensitive.compare(file3, this.lessFile) > 0 ? 1 : 0) != 0);
    }
}

