/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class RegexFileFilterTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    public void assertFiltering(IOFileFilter filter, File file, boolean expected) throws Exception {
        Assert.assertEquals((String)("Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file), (Object)expected, (Object)filter.accept(file));
        if (file != null && file.getParentFile() != null) {
            Assert.assertEquals((String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file), (Object)expected, (Object)filter.accept(file.getParentFile(), file.getName()));
        } else if (file == null) {
            Assert.assertEquals((String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for null"), (Object)expected, (Object)filter.accept(file));
        }
    }

    @Test
    public void testRegex() throws Exception {
        RegexFileFilter filter = new RegexFileFilter("^.*[tT]est(-\\d+)?\\.java$");
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test-10.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test-.java"), false);
        filter = new RegexFileFilter("^[Tt]est.java$");
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), false);
        filter = new RegexFileFilter(Pattern.compile("^test.java$", 2));
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), true);
        filter = new RegexFileFilter("^test.java$", 2);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), true);
        filter = new RegexFileFilter("^test.java$", IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("tEST.java"), true);
        try {
            new RegexFileFilter((String)null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RegexFileFilter(null, 2);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RegexFileFilter(null, IOCase.INSENSITIVE);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new RegexFileFilter((Pattern)null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

