/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TailerTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Tailer tailer;

    private File getTestDirectory() {
        return this.temporaryFolder.getRoot();
    }

    @After
    public void tearDown() throws Exception {
        if (this.tailer != null) {
            this.tailer.stop();
        }
    }

    @Test
    public void testLongFile() throws Exception {
        long delay = 50L;
        File file = new File(this.getTestDirectory(), "testLongFile.txt");
        this.createFile(file, 0L);
        try (FileWriter writer = new FileWriter(file, true);){
            for (int i = 0; i < 100000; ++i) {
                writer.write("LineLineLineLineLineLineLineLineLineLine\n");
            }
            writer.write("SBTOURIST\n");
        }
        TestTailerListener listener = new TestTailerListener();
        this.tailer = new Tailer(file, (TailerListener)listener, 50L, false);
        long start = System.currentTimeMillis();
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        List<String> lines = listener.getLines();
        while (lines.isEmpty() || !lines.get(lines.size() - 1).equals("SBTOURIST")) {
            lines = listener.getLines();
        }
        System.out.println("Elapsed: " + (System.currentTimeMillis() - start));
        listener.clear();
    }

    @Test
    public void testBufferBreak() throws Exception {
        long delay = 50L;
        File file = new File(this.getTestDirectory(), "testBufferBreak.txt");
        this.createFile(file, 0L);
        this.writeString(file, "SBTOURIST\n");
        TestTailerListener listener = new TestTailerListener();
        this.tailer = new Tailer(file, (TailerListener)listener, 50L, false, 1);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        List<String> lines = listener.getLines();
        while (lines.isEmpty() || !lines.get(lines.size() - 1).equals("SBTOURIST")) {
            lines = listener.getLines();
        }
        listener.clear();
    }

    @Test
    public void testMultiByteBreak() throws Exception {
        System.out.println("testMultiByteBreak() Default charset: " + Charset.defaultCharset().displayName());
        long delay = 50L;
        File origin = new File(this.getClass().getResource("/test-file-utf8.bin").toURI());
        File file = new File(this.getTestDirectory(), "testMultiByteBreak.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        String osname = System.getProperty("os.name");
        boolean isWindows = osname.startsWith("Windows");
        Charset charsetUTF8 = StandardCharsets.UTF_8;
        this.tailer = new Tailer(file, charsetUTF8, (TailerListener)listener, 50L, false, isWindows, 4096);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charsetUTF8);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(origin), charsetUTF8));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                out.write(line);
                out.write("\n");
                lines.add(line);
            }
            ((Writer)out).close();
            long testDelayMillis = 500L;
            TestUtils.sleep(500L);
            List<String> tailerlines = listener.getLines();
            Assert.assertEquals((String)"line count", (long)lines.size(), (long)tailerlines.size());
            int len = lines.size();
            for (int i = 0; i < len; ++i) {
                String actual;
                String expected = (String)lines.get(i);
                if (expected.equals(actual = tailerlines.get(i))) continue;
                Assert.fail((String)("Line: " + i + "\nExp: (" + expected.length() + ") " + expected + "\nAct: (" + actual.length() + ") " + actual));
            }
        }
    }

    @Test
    public void testTailerEof() throws Exception {
        long delay = 50L;
        File file = new File(this.getTestDirectory(), "tailer2-test.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        this.tailer = new Tailer(file, (TailerListener)listener, 50L, false);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        this.writeString(file, "Line");
        TestUtils.sleep(100L);
        List<String> lines = listener.getLines();
        Assert.assertEquals((String)"1 line count", (long)0L, (long)lines.size());
        this.writeString(file, " one\n");
        TestUtils.sleep(100L);
        lines = listener.getLines();
        Assert.assertEquals((String)"1 line count", (long)1L, (long)lines.size());
        Assert.assertEquals((String)"1 line 1", (Object)"Line one", (Object)lines.get(0));
        listener.clear();
    }

    @Test
    public void testTailer() throws Exception {
        long delayMillis = 50L;
        File file = new File(this.getTestDirectory(), "tailer1-test.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        String osname = System.getProperty("os.name");
        boolean isWindows = osname.startsWith("Windows");
        this.tailer = new Tailer(file, (TailerListener)listener, 50L, false, isWindows);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        this.write(file, "Line one", "Line two");
        long testDelayMillis = 500L;
        TestUtils.sleep(500L);
        List<String> lines = listener.getLines();
        Assert.assertEquals((String)"1 line count", (long)2L, (long)lines.size());
        Assert.assertEquals((String)"1 line 1", (Object)"Line one", (Object)lines.get(0));
        Assert.assertEquals((String)"1 line 2", (Object)"Line two", (Object)lines.get(1));
        listener.clear();
        this.write(file, "Line three");
        TestUtils.sleep(500L);
        lines = listener.getLines();
        Assert.assertEquals((String)"2 line count", (long)1L, (long)lines.size());
        Assert.assertEquals((String)"2 line 3", (Object)"Line three", (Object)lines.get(0));
        listener.clear();
        lines = FileUtils.readLines((File)file, (String)"UTF-8");
        Assert.assertEquals((String)"3 line count", (long)3L, (long)lines.size());
        Assert.assertEquals((String)"3 line 1", (Object)"Line one", lines.get(0));
        Assert.assertEquals((String)"3 line 2", (Object)"Line two", lines.get(1));
        Assert.assertEquals((String)"3 line 3", (Object)"Line three", lines.get(2));
        file.delete();
        boolean exists = file.exists();
        Assert.assertFalse((String)"File should not exist", (boolean)exists);
        this.createFile(file, 0L);
        TestUtils.sleep(500L);
        this.write(file, "Line four");
        TestUtils.sleep(500L);
        lines = listener.getLines();
        Assert.assertEquals((String)"4 line count", (long)1L, (long)lines.size());
        Assert.assertEquals((String)"4 line 3", (Object)"Line four", (Object)lines.get(0));
        listener.clear();
        thread.interrupt();
        TestUtils.sleep(2000L);
        this.write(file, "Line five");
        Assert.assertEquals((String)"4 line count", (long)0L, (long)listener.getLines().size());
        Assert.assertNotNull((String)"Missing InterruptedException", (Object)listener.exception);
        Assert.assertTrue((String)("Unexpected Exception: " + listener.exception), (boolean)(listener.exception instanceof InterruptedException));
        Assert.assertEquals((String)"Expected init to be called", (long)1L, (long)listener.initialised);
        Assert.assertEquals((String)"fileNotFound should not be called", (long)0L, (long)listener.notFound);
        Assert.assertEquals((String)"fileRotated should be be called", (long)1L, (long)listener.rotated);
    }

    @Test
    public void testTailerEndOfFileReached() throws Exception {
        long delayMillis = 50L;
        long testDelayMillis = 500L;
        File file = new File(this.getTestDirectory(), "tailer-eof-test.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        String osname = System.getProperty("os.name");
        boolean isWindows = osname.startsWith("Windows");
        this.tailer = new Tailer(file, (TailerListener)listener, 50L, false, isWindows);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        this.write(file, "line1", "line2", "line3");
        TestUtils.sleep(500L);
        this.write(file, "line4", "line5", "line6");
        TestUtils.sleep(500L);
        this.write(file, "line7", "line8", "line9");
        TestUtils.sleep(500L);
        Assert.assertTrue((String)"end of file reached at least 3 times", (listener.reachedEndOfFile >= 3 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFile(File file, long size) throws IOException {
        if (!file.getParentFile().exists()) {
            throw new IOException("Cannot create file " + file + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
            TestUtils.generateTestData(output, size);
        }
        RandomAccessFile reader = null;
        try {
            while (reader == null) {
                try {
                    reader = new RandomAccessFile(file.getPath(), "r");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                try {
                    TestUtils.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    private void write(File file, String ... lines) throws Exception {
        try (FileWriter writer = new FileWriter(file, true);){
            for (String line : lines) {
                writer.write(line + "\n");
            }
        }
    }

    private void writeString(File file, String ... strings) throws Exception {
        try (FileWriter writer = new FileWriter(file, true);){
            for (String string : strings) {
                writer.write(string);
            }
        }
    }

    @Test
    public void testStopWithNoFile() throws Exception {
        File file = new File(this.getTestDirectory(), "nosuchfile");
        Assert.assertFalse((String)"nosuchfile should not exist", (boolean)file.exists());
        TestTailerListener listener = new TestTailerListener();
        int delay = 100;
        int idle = 50;
        this.tailer = Tailer.create((File)file, (TailerListener)listener, (long)100L, (boolean)false);
        TestUtils.sleep(50L);
        this.tailer.stop();
        TestUtils.sleep(150L);
        Assert.assertNull((String)"Should not generate Exception", (Object)listener.exception);
        Assert.assertEquals((String)"Expected init to be called", (long)1L, (long)listener.initialised);
        Assert.assertTrue((String)"fileNotFound should be called", (listener.notFound > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"fileRotated should be not be called", (long)0L, (long)listener.rotated);
        Assert.assertEquals((String)"end of file never reached", (long)0L, (long)listener.reachedEndOfFile);
    }

    @Test
    public void testInterrupt() throws Exception {
        File file = new File(this.getTestDirectory(), "nosuchfile");
        Assert.assertFalse((String)"nosuchfile should not exist", (boolean)file.exists());
        TestTailerListener listener = new TestTailerListener();
        int delay = 1000;
        int idle = 50;
        this.tailer = new Tailer(file, (TailerListener)listener, 1000L, false, 4096);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.setDaemon(true);
        thread.start();
        TestUtils.sleep(50L);
        thread.interrupt();
        TestUtils.sleep(1050L);
        Assert.assertNotNull((String)"Missing InterruptedException", (Object)listener.exception);
        Assert.assertTrue((String)("Unexpected Exception: " + listener.exception), (boolean)(listener.exception instanceof InterruptedException));
        Assert.assertEquals((String)"Expected init to be called", (long)1L, (long)listener.initialised);
        Assert.assertTrue((String)"fileNotFound should be called", (listener.notFound > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"fileRotated should be not be called", (long)0L, (long)listener.rotated);
        Assert.assertEquals((String)"end of file never reached", (long)0L, (long)listener.reachedEndOfFile);
    }

    @Test
    public void testStopWithNoFileUsingExecutor() throws Exception {
        File file = new File(this.getTestDirectory(), "nosuchfile");
        Assert.assertFalse((String)"nosuchfile should not exist", (boolean)file.exists());
        TestTailerListener listener = new TestTailerListener();
        int delay = 100;
        int idle = 50;
        this.tailer = new Tailer(file, (TailerListener)listener, 100L, false);
        ScheduledThreadPoolExecutor exec = new ScheduledThreadPoolExecutor(1);
        exec.execute((Runnable)this.tailer);
        TestUtils.sleep(50L);
        this.tailer.stop();
        TestUtils.sleep(150L);
        Assert.assertNull((String)"Should not generate Exception", (Object)listener.exception);
        Assert.assertEquals((String)"Expected init to be called", (long)1L, (long)listener.initialised);
        Assert.assertTrue((String)"fileNotFound should be called", (listener.notFound > 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"fileRotated should be not be called", (long)0L, (long)listener.rotated);
        Assert.assertEquals((String)"end of file never reached", (long)0L, (long)listener.reachedEndOfFile);
    }

    @Test
    public void testIO335() throws Exception {
        long delayMillis = 50L;
        File file = new File(this.getTestDirectory(), "tailer-testio334.txt");
        this.createFile(file, 0L);
        TestTailerListener listener = new TestTailerListener();
        this.tailer = new Tailer(file, (TailerListener)listener, 50L, false);
        Thread thread = new Thread((Runnable)this.tailer);
        thread.start();
        this.writeString(file, "CRLF\r\n", "LF\n", "CR\r", "CRCR\r\r", "trail");
        long testDelayMillis = 500L;
        TestUtils.sleep(500L);
        List<String> lines = listener.getLines();
        Assert.assertEquals((String)"line count", (long)4L, (long)lines.size());
        Assert.assertEquals((String)"line 1", (Object)"CRLF", (Object)lines.get(0));
        Assert.assertEquals((String)"line 2", (Object)"LF", (Object)lines.get(1));
        Assert.assertEquals((String)"line 3", (Object)"CR", (Object)lines.get(2));
        Assert.assertEquals((String)"line 4", (Object)"CRCR\r", (Object)lines.get(3));
    }

    private static class TestTailerListener
    extends TailerListenerAdapter {
        private final List<String> lines = Collections.synchronizedList(new ArrayList());
        volatile Exception exception = null;
        volatile int notFound = 0;
        volatile int rotated = 0;
        volatile int initialised = 0;
        volatile int reachedEndOfFile = 0;

        private TestTailerListener() {
        }

        public void handle(String line) {
            this.lines.add(line);
        }

        public List<String> getLines() {
            return this.lines;
        }

        public void clear() {
            this.lines.clear();
        }

        public void handle(Exception e) {
            this.exception = e;
        }

        public void init(Tailer tailer) {
            ++this.initialised;
        }

        public void fileNotFound() {
            ++this.notFound;
        }

        public void fileRotated() {
            ++this.rotated;
        }

        public void endOfFileReached() {
            ++this.reachedEndOfFile;
        }
    }
}

