/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ProxyOutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProxyOutputStreamTest {
    private ByteArrayOutputStream original;
    private OutputStream proxied;

    @Before
    public void setUp() {
        this.original = new ByteArrayOutputStream(){

            public void write(byte[] ba) throws IOException {
                if (ba != null) {
                    super.write(ba);
                }
            }
        };
        this.proxied = new ProxyOutputStream((OutputStream)this.original);
    }

    @Test
    public void testWrite() throws Exception {
        this.proxied.write(121);
        Assert.assertEquals((long)1L, (long)this.original.size());
        Assert.assertEquals((long)121L, (long)this.original.toByteArray()[0]);
    }

    @Test
    public void testWriteNullBaSucceeds() throws Exception {
        byte[] ba = null;
        this.original.write(ba);
        this.proxied.write(ba);
    }
}

