/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.output.BrokenOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ClosedOutputStream;
import org.apache.commons.io.output.TaggedOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class TaggedOutputStreamTest {
    @Test
    public void testNormalStream() {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            TaggedOutputStream stream = new TaggedOutputStream((OutputStream)buffer);
            stream.write(97);
            stream.write(new byte[]{98});
            stream.write(new byte[]{99}, 0, 1);
            stream.flush();
            stream.close();
            Assert.assertEquals((long)3L, (long)buffer.size());
            Assert.assertEquals((long)97L, (long)buffer.toByteArray()[0]);
            Assert.assertEquals((long)98L, (long)buffer.toByteArray()[1]);
            Assert.assertEquals((long)99L, (long)buffer.toByteArray()[2]);
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception thrown");
        }
    }

    @Test
    public void testBrokenStream() {
        IOException exception = new IOException("test exception");
        TaggedOutputStream stream = new TaggedOutputStream((OutputStream)new BrokenOutputStream(exception));
        try {
            stream.write(120);
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)stream.isCauseOf((Exception)e));
            try {
                stream.throwIfCauseOf((Exception)e);
                Assert.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assert.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            stream.flush();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)stream.isCauseOf((Exception)e));
            try {
                stream.throwIfCauseOf((Exception)e);
                Assert.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assert.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            stream.close();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)stream.isCauseOf((Exception)e));
            try {
                stream.throwIfCauseOf((Exception)e);
                Assert.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assert.assertEquals((Object)exception, (Object)e2);
            }
        }
    }

    @Test
    public void testOtherException() throws Exception {
        IOException exception = new IOException("test exception");
        ClosedOutputStream closed = new ClosedOutputStream();
        TaggedOutputStream stream = new TaggedOutputStream((OutputStream)closed);
        Assert.assertFalse((boolean)stream.isCauseOf((Exception)exception));
        Assert.assertFalse((boolean)stream.isCauseOf((Exception)new TaggedIOException(exception, (Serializable)UUID.randomUUID())));
        try {
            stream.throwIfCauseOf((Exception)exception);
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception thrown");
        }
        try {
            stream.throwIfCauseOf((Exception)new TaggedIOException(exception, (Serializable)UUID.randomUUID()));
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception thrown");
        }
        stream.close();
    }
}

