/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileCleaningTrackerTestCase {
    @TempDir
    public File temporaryFolder;
    private File testFile;
    private FileCleaningTracker theInstance;

    protected FileCleaningTracker newInstance() {
        return new FileCleaningTracker();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.testFile = new File(this.temporaryFolder, "file-test.txt");
        this.theInstance = this.newInstance();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.theInstance != null) {
            this.theInstance.q = new ReferenceQueue();
            this.theInstance.trackers.clear();
            this.theInstance.deleteFailures.clear();
            this.theInstance.exitWhenFinished = false;
            this.theInstance.reaper = null;
        }
        this.theInstance = null;
    }

    @Test
    public void testFileCleanerFile() throws Exception {
        String path = this.testFile.getPath();
        Assertions.assertFalse((boolean)this.testFile.exists());
        RandomAccessFile r = new RandomAccessFile(this.testFile, "rw");
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        this.theInstance.track(path, (Object)r);
        Assertions.assertEquals((int)1, (int)this.theInstance.getTrackCount());
        r.close();
        this.testFile = null;
        r = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(new File(path));
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        Assertions.assertEquals((Object)false, (Object)new File(path).exists(), (String)this.showFailures());
    }

    @Test
    public void testFileCleanerDirectory() throws Exception {
        TestUtils.createFile(this.testFile, 100L);
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertTrue((boolean)this.temporaryFolder.exists());
        Object obj = new Object();
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        this.theInstance.track(this.temporaryFolder, obj);
        Assertions.assertEquals((int)1, (int)this.theInstance.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertTrue((boolean)this.testFile.getParentFile().exists());
    }

    @Test
    public void testFileCleanerDirectory_NullStrategy() throws Exception {
        TestUtils.createFile(this.testFile, 100L);
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertTrue((boolean)this.temporaryFolder.exists());
        Object obj = new Object();
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        this.theInstance.track(this.temporaryFolder, obj, null);
        Assertions.assertEquals((int)1, (int)this.theInstance.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertTrue((boolean)this.testFile.getParentFile().exists());
    }

    @Test
    public void testFileCleanerDirectory_ForceStrategy() throws Exception {
        if (!this.testFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.testFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.testFile));){
            TestUtils.generateTestData(output, 100L);
        }
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertTrue((boolean)this.temporaryFolder.exists());
        Object obj = new Object();
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        this.theInstance.track(this.temporaryFolder, obj, FileDeleteStrategy.FORCE);
        Assertions.assertEquals((int)1, (int)this.theInstance.getTrackCount());
        obj = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(this.testFile.getParentFile());
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        Assertions.assertEquals((Object)false, (Object)new File(this.testFile.getPath()).exists(), (String)this.showFailures());
        Assertions.assertEquals((Object)false, (Object)this.testFile.getParentFile().exists(), (String)this.showFailures());
    }

    @Test
    public void testFileCleanerNull() throws Exception {
        try {
            this.theInstance.track((File)null, new Object());
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.theInstance.track((File)null, new Object(), FileDeleteStrategy.NORMAL);
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.theInstance.track((String)null, new Object());
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.theInstance.track((String)null, new Object(), FileDeleteStrategy.NORMAL);
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testFileCleanerExitWhenFinishedFirst() throws Exception {
        Assertions.assertFalse((boolean)this.theInstance.exitWhenFinished);
        this.theInstance.exitWhenFinished();
        Assertions.assertTrue((boolean)this.theInstance.exitWhenFinished);
        Assertions.assertEquals(null, (Object)this.theInstance.reaper);
        this.waitUntilTrackCount();
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        Assertions.assertTrue((boolean)this.theInstance.exitWhenFinished);
        Assertions.assertEquals(null, (Object)this.theInstance.reaper);
    }

    @Test
    public void testFileCleanerExitWhenFinished_NoTrackAfter() throws Exception {
        Assertions.assertFalse((boolean)this.theInstance.exitWhenFinished);
        this.theInstance.exitWhenFinished();
        Assertions.assertTrue((boolean)this.theInstance.exitWhenFinished);
        Assertions.assertEquals(null, (Object)this.theInstance.reaper);
        String path = this.testFile.getPath();
        Object marker = new Object();
        try {
            this.theInstance.track(path, marker);
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)this.theInstance.exitWhenFinished);
        Assertions.assertEquals(null, (Object)this.theInstance.reaper);
    }

    @Test
    public void testFileCleanerExitWhenFinished1() throws Exception {
        String path = this.testFile.getPath();
        Assertions.assertEquals((Object)false, (Object)this.testFile.exists(), (String)("1-testFile exists: " + this.testFile));
        RandomAccessFile r = new RandomAccessFile(this.testFile, "rw");
        Assertions.assertEquals((Object)true, (Object)this.testFile.exists(), (String)"2-testFile exists");
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount(), (String)"3-Track Count");
        this.theInstance.track(path, (Object)r);
        Assertions.assertEquals((int)1, (int)this.theInstance.getTrackCount(), (String)"4-Track Count");
        Assertions.assertEquals((Object)false, (Object)this.theInstance.exitWhenFinished, (String)"5-exitWhenFinished");
        Assertions.assertEquals((Object)true, (Object)this.theInstance.reaper.isAlive(), (String)"6-reaper.isAlive");
        Assertions.assertEquals((Object)false, (Object)this.theInstance.exitWhenFinished, (String)"7-exitWhenFinished");
        this.theInstance.exitWhenFinished();
        Assertions.assertEquals((Object)true, (Object)this.theInstance.exitWhenFinished, (String)"8-exitWhenFinished");
        Assertions.assertEquals((Object)true, (Object)this.theInstance.reaper.isAlive(), (String)"9-reaper.isAlive");
        r.close();
        this.testFile = null;
        r = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(new File(path));
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount(), (String)"10-Track Count");
        Assertions.assertEquals((Object)false, (Object)new File(path).exists(), (String)("11-testFile exists " + this.showFailures()));
        Assertions.assertEquals((Object)true, (Object)this.theInstance.exitWhenFinished, (String)"12-exitWhenFinished");
        Assertions.assertEquals((Object)false, (Object)this.theInstance.reaper.isAlive(), (String)"13-reaper.isAlive");
    }

    @Test
    public void testFileCleanerExitWhenFinished2() throws Exception {
        String path = this.testFile.getPath();
        Assertions.assertFalse((boolean)this.testFile.exists());
        RandomAccessFile r = new RandomAccessFile(this.testFile, "rw");
        Assertions.assertTrue((boolean)this.testFile.exists());
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        this.theInstance.track(path, (Object)r);
        Assertions.assertEquals((int)1, (int)this.theInstance.getTrackCount());
        Assertions.assertFalse((boolean)this.theInstance.exitWhenFinished);
        Assertions.assertTrue((boolean)this.theInstance.reaper.isAlive());
        r.close();
        this.testFile = null;
        r = null;
        this.waitUntilTrackCount();
        this.pauseForDeleteToComplete(new File(path));
        Assertions.assertEquals((int)0, (int)this.theInstance.getTrackCount());
        Assertions.assertEquals((Object)false, (Object)new File(path).exists(), (String)this.showFailures());
        Assertions.assertFalse((boolean)this.theInstance.exitWhenFinished);
        Assertions.assertTrue((boolean)this.theInstance.reaper.isAlive());
        Assertions.assertFalse((boolean)this.theInstance.exitWhenFinished);
        this.theInstance.exitWhenFinished();
        for (int i = 0; i < 20 && this.theInstance.reaper.isAlive(); ++i) {
            TestUtils.sleep(500L);
        }
        Assertions.assertTrue((boolean)this.theInstance.exitWhenFinished);
        Assertions.assertFalse((boolean)this.theInstance.reaper.isAlive());
    }

    private void pauseForDeleteToComplete(File file) {
        int count = 0;
        while (file.exists() && count++ < 40) {
            try {
                TestUtils.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            file = new File(file.getPath());
        }
    }

    private String showFailures() throws Exception {
        if (this.theInstance.deleteFailures.size() == 1) {
            return "[Delete Failed: " + (String)this.theInstance.deleteFailures.get(0) + "]";
        }
        return "[Delete Failures: " + this.theInstance.deleteFailures.size() + "]";
    }

    private void waitUntilTrackCount() throws Exception {
        System.gc();
        TestUtils.sleep(500L);
        int count = 0;
        while (this.theInstance.getTrackCount() != 0 && count++ < 5) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                long i = 0L;
                while (this.theInstance.getTrackCount() != 0) {
                    list.add("A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String A Big String " + i++);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            list = null;
            System.gc();
            TestUtils.sleep(1000L);
        }
        if (this.theInstance.getTrackCount() != 0) {
            throw new IllegalStateException("Your JVM is not releasing References, try running the testcase with less memory (-Xmx)");
        }
    }
}

