/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.io.testtools.TestUtils;
import org.apache.commons.io.testtools.YellOnCloseInputStream;
import org.apache.commons.io.testtools.YellOnFlushAndCloseOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOUtilsCopyTestCase {
    private static final int FILE_SIZE = 4097;
    private final byte[] inData = TestUtils.generateTestData(4097L);

    @Test
    public void testCopy_inputStreamToOutputStream() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        int count = IOUtils.copy((InputStream)in, (OutputStream)((Object)out));
        Assertions.assertEquals((int)0, (int)((InputStream)in).available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertTrue((boolean)Arrays.equals(this.inData, baout.toByteArray()), (String)"Content differs");
        Assertions.assertEquals((int)this.inData.length, (int)count);
    }

    @Test
    public void testCopy_inputStreamToOutputStream_IO84() throws Exception {
        long size = 0x80000000L;
        NullInputStream in = new NullInputStream(0x80000000L);
        NullOutputStream out = NullOutputStream.NULL_OUTPUT_STREAM;
        Assertions.assertEquals((int)-1, (int)IOUtils.copy((InputStream)in, (OutputStream)out));
        in.close();
        Assertions.assertEquals((long)0x80000000L, (long)IOUtils.copyLarge((InputStream)in, (OutputStream)out), (String)"copyLarge()");
    }

    @Test
    public void testCopy_inputStreamToOutputStream_nullIn() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Assertions.assertThrows(NullPointerException.class, () -> IOUtilsCopyTestCase.lambda$testCopy_inputStreamToOutputStream_nullIn$0((OutputStream)out));
    }

    @Test
    public void testCopy_inputStreamToOutputStream_nullOut() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(this.inData);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((InputStream)in, (OutputStream)null));
    }

    @Test
    public void testCopy_inputStreamToOutputStreamWithBufferSize() throws Exception {
        this.testCopy_inputStreamToOutputStreamWithBufferSize(1);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(2);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(4);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(8);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(16);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(32);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(64);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(128);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(256);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(512);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(1024);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(2048);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(4096);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(8192);
        this.testCopy_inputStreamToOutputStreamWithBufferSize(16384);
    }

    private void testCopy_inputStreamToOutputStreamWithBufferSize(int bufferSize) throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        long count = IOUtils.copy((InputStream)in, (OutputStream)((Object)out), (int)bufferSize);
        Assertions.assertEquals((int)0, (int)((InputStream)in).available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertTrue((boolean)Arrays.equals(this.inData, baout.toByteArray()), (String)"Content differs");
        Assertions.assertEquals((long)this.inData.length, (long)count);
    }

    @Test
    public void testCopy_inputStreamToWriter() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.copy((InputStream)in, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)((InputStream)in).available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertTrue((boolean)Arrays.equals(this.inData, baout.toByteArray()), (String)"Content differs");
    }

    @Test
    public void testCopy_inputStreamToWriter_Encoding() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF8");
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)((InputStream)in).available(), (String)"Not all bytes were read");
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, "UTF8").getBytes("US-ASCII");
        Assertions.assertTrue((boolean)Arrays.equals(this.inData, bytes), (String)"Content differs");
    }

    @Test
    public void testCopy_inputStreamToWriter_Encoding_nullEncoding() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.copy((InputStream)in, (Writer)writer, (String)null);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)0, (int)((InputStream)in).available(), (String)"Not all bytes were read");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertTrue((boolean)Arrays.equals(this.inData, baout.toByteArray()), (String)"Content differs");
    }

    @Test
    public void testCopy_inputStreamToWriter_Encoding_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy(null, (Writer)writer, (String)"UTF8"));
    }

    @Test
    public void testCopy_inputStreamToWriter_Encoding_nullOut() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(this.inData);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((InputStream)in, null, (String)"UTF8"));
    }

    @Test
    public void testCopy_inputStreamToWriter_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((InputStream)null, (Writer)writer));
    }

    @Test
    public void testCopy_inputStreamToWriter_nullOut() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(this.inData);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((InputStream)in, (Writer)null));
    }

    @Test
    public void testCopy_readerToAppendable() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        long count = IOUtils.copy((Reader)reader, (Appendable)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((long)this.inData.length, (long)count, (String)"The number of characters returned by copy is wrong");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertTrue((boolean)Arrays.equals(this.inData, baout.toByteArray()), (String)"Content differs");
    }

    @Test
    public void testCopy_readerToAppendable_IO84() throws Exception {
        long size = 0x80000000L;
        NullReader reader = new NullReader(0x80000000L);
        NullWriter writer = new NullWriter();
        Assertions.assertEquals((long)0x80000000L, (long)IOUtils.copy((Reader)reader, (Appendable)writer));
        reader.close();
        Assertions.assertEquals((long)0x80000000L, (long)IOUtils.copyLarge((Reader)reader, (Writer)writer), (String)"copy()");
    }

    @Test
    public void testCopy_readerToAppendable_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((Reader)null, (Appendable)writer));
    }

    @Test
    public void testCopy_readerToAppendable_nullOut() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((Reader)reader, (Appendable)null));
    }

    @Test
    public void testCopy_readerToOutputStream() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.copy((Reader)reader, (OutputStream)((Object)out));
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertTrue((boolean)Arrays.equals(this.inData, baout.toByteArray()), (String)"Content differs");
    }

    @Test
    public void testCopy_readerToOutputStream_Encoding() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.copy((Reader)reader, (OutputStream)((Object)out), (String)"UTF16");
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, "UTF16").getBytes("US-ASCII");
        Assertions.assertTrue((boolean)Arrays.equals(this.inData, bytes), (String)"Content differs");
    }

    @Test
    public void testCopy_readerToOutputStream_Encoding_nullEncoding() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.copy((Reader)reader, (OutputStream)((Object)out), (String)null);
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertTrue((boolean)Arrays.equals(this.inData, baout.toByteArray()), (String)"Content differs");
    }

    @Test
    public void testCopy_readerToOutputStream_Encoding_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtilsCopyTestCase.lambda$testCopy_readerToOutputStream_Encoding_nullIn$8((OutputStream)((Object)out)));
    }

    @Test
    public void testCopy_readerToOutputStream_Encoding_nullOut() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((Reader)reader, null, (String)"UTF16"));
    }

    @Test
    public void testCopy_readerToOutputStream_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        Assertions.assertThrows(NullPointerException.class, () -> IOUtilsCopyTestCase.lambda$testCopy_readerToOutputStream_nullIn$10((OutputStream)((Object)out)));
    }

    @Test
    public void testCopy_readerToOutputStream_nullOut() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((Reader)reader, (OutputStream)null));
    }

    @Test
    public void testCopy_readerToWriter() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        int count = IOUtils.copy((Reader)reader, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        Assertions.assertEquals((int)this.inData.length, (int)count, (String)"The number of characters returned by copy is wrong");
        Assertions.assertEquals((int)this.inData.length, (int)baout.size(), (String)"Sizes differ");
        Assertions.assertTrue((boolean)Arrays.equals(this.inData, baout.toByteArray()), (String)"Content differs");
    }

    @Test
    public void testCopy_readerToWriter_IO84() throws Exception {
        long size = 0x80000000L;
        NullReader reader = new NullReader(0x80000000L);
        NullWriter writer = new NullWriter();
        Assertions.assertEquals((int)-1, (int)IOUtils.copy((Reader)reader, (Writer)writer));
        reader.close();
        Assertions.assertEquals((long)0x80000000L, (long)IOUtils.copyLarge((Reader)reader, (Writer)writer), (String)"copyLarge()");
    }

    @Test
    public void testCopy_readerToWriter_nullIn() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((Reader)null, (Writer)writer));
    }

    @Test
    public void testCopy_readerToWriter_nullOut() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        Assertions.assertThrows(NullPointerException.class, () -> IOUtils.copy((Reader)reader, (Writer)null));
    }

    private static /* synthetic */ void lambda$testCopy_readerToOutputStream_nullIn$10(OutputStream out) throws Throwable {
        IOUtils.copy((Reader)null, (OutputStream)out);
    }

    private static /* synthetic */ void lambda$testCopy_readerToOutputStream_Encoding_nullIn$8(OutputStream out) throws Throwable {
        IOUtils.copy(null, (OutputStream)out, (String)"UTF16");
    }

    private static /* synthetic */ void lambda$testCopy_inputStreamToOutputStream_nullIn$0(OutputStream out) throws Throwable {
        IOUtils.copy((InputStream)null, (OutputStream)out);
    }
}

