/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.util.Comparator;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.ComparatorAbstractTestCase;
import org.apache.commons.io.comparator.NameFileComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NameFileComparatorTest
extends ComparatorAbstractTestCase {
    @BeforeEach
    public void setUp() throws Exception {
        this.comparator = (AbstractFileComparator)NameFileComparator.NAME_INSENSITIVE_COMPARATOR;
        this.reverse = NameFileComparator.NAME_REVERSE;
        this.equalFile1 = new File("a/foo.txt");
        this.equalFile2 = new File("b/foo.txt");
        this.lessFile = new File("c/ABC.txt");
        this.moreFile = new File("d/XYZ.txt");
    }

    @Test
    public void testCaseSensitivity() {
        File file3 = new File("a/FOO.txt");
        NameFileComparator sensitive = new NameFileComparator(null);
        Assertions.assertTrue((sensitive.compare(this.equalFile1, this.equalFile2) == 0 ? 1 : 0) != 0, (String)"sensitive file1 & file2 = 0");
        Assertions.assertTrue((sensitive.compare(this.equalFile1, file3) > 0 ? 1 : 0) != 0, (String)"sensitive file1 & file3 > 0");
        Assertions.assertTrue((sensitive.compare(this.equalFile1, this.lessFile) > 0 ? 1 : 0) != 0, (String)"sensitive file1 & less  > 0");
        Comparator insensitive = NameFileComparator.NAME_INSENSITIVE_COMPARATOR;
        Assertions.assertTrue((insensitive.compare(this.equalFile1, this.equalFile2) == 0 ? 1 : 0) != 0, (String)"insensitive file1 & file2 = 0");
        Assertions.assertTrue((insensitive.compare(this.equalFile1, file3) == 0 ? 1 : 0) != 0, (String)"insensitive file1 & file3 = 0");
        Assertions.assertTrue((insensitive.compare(this.equalFile1, this.lessFile) > 0 ? 1 : 0) != 0, (String)"insensitive file1 & file4 > 0");
        Assertions.assertTrue((insensitive.compare(file3, this.lessFile) > 0 ? 1 : 0) != 0, (String)"insensitive file3 & less  > 0");
    }
}

