/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.math.BigInteger;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.junit.jupiter.api.Assertions;

class CounterAssertions {
    CounterAssertions() {
    }

    static void assertCounter(long expected, Counters.Counter actual, String message) {
        Assertions.assertEquals((long)expected, (long)actual.get(), (String)message);
        Assertions.assertEquals((Long)expected, (Long)actual.getLong(), (String)message);
        Assertions.assertEquals((Object)BigInteger.valueOf(expected), (Object)actual.getBigInteger(), (String)message);
    }

    static void assertCounts(long expectedDirCount, long expectedFileCount, long expectedByteCount, CountingPathVisitor actualVisitor) {
        CounterAssertions.assertCounts(expectedDirCount, expectedFileCount, expectedByteCount, actualVisitor.getPathCounters());
    }

    static void assertCounts(long expectedDirCount, long expectedFileCount, long expectedByteCount, Counters.PathCounters actualPathCounters) {
        CounterAssertions.assertCounter(expectedDirCount, actualPathCounters.getDirectoryCounter(), "getDirectoryCounter");
        CounterAssertions.assertCounter(expectedFileCount, actualPathCounters.getFileCounter(), "getFileCounter");
        CounterAssertions.assertCounter(expectedByteCount, actualPathCounters.getByteCounter(), "getByteCounter");
    }
}

