/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CountingInputStreamTest {
    @Test
    public void testCounting() throws Exception {
        String text = "A piece of text";
        byte[] bytes = "A piece of text".getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            byte[] result = new byte[21];
            byte[] ba = new byte[5];
            int found = cis.read(ba);
            System.arraycopy(ba, 0, result, 0, 5);
            Assertions.assertEquals((int)found, (int)cis.getCount());
            int value = cis.read();
            result[5] = (byte)value;
            Assertions.assertEquals((int)(++found), (int)cis.getCount());
            Assertions.assertEquals((int)(found += cis.read(result, 6, 5)), (int)cis.getCount());
            Assertions.assertEquals((int)(found += cis.read(result, 11, 10)), (int)cis.getCount());
            String textResult = new String(result).trim();
            Assertions.assertEquals((Object)textResult, (Object)"A piece of text");
        }
    }

    @Test
    public void testLargeFiles_IO84() throws Exception {
        long size = 0x80000000L;
        NullInputStream mock = new NullInputStream(0x80000000L);
        CountingInputStream cis = new CountingInputStream((InputStream)mock);
        NullOutputStream out = NullOutputStream.NULL_OUTPUT_STREAM;
        IOUtils.copyLarge((InputStream)cis, (OutputStream)out);
        try {
            cis.getCount();
            Assertions.fail((String)"Expected getCount() to throw an ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        try {
            cis.resetCount();
            Assertions.fail((String)"Expected resetCount() to throw an ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        mock.close();
        IOUtils.copyLarge((InputStream)cis, (OutputStream)out);
        Assertions.assertEquals((long)0x80000000L, (long)cis.getByteCount(), (String)"getByteCount()");
        Assertions.assertEquals((long)0x80000000L, (long)cis.resetByteCount(), (String)"resetByteCount()");
    }

    @Test
    public void testResetting() throws Exception {
        String text = "A piece of text";
        byte[] bytes = "A piece of text".getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            byte[] result = new byte[bytes.length];
            int found = cis.read(result, 0, 5);
            Assertions.assertEquals((int)found, (int)cis.getCount());
            int count = cis.resetCount();
            found = cis.read(result, 6, 5);
            Assertions.assertEquals((int)found, (int)count);
        }
    }

    @Test
    public void testZeroLength1() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            int found = cis.read();
            Assertions.assertEquals((int)-1, (int)found);
            Assertions.assertEquals((int)0, (int)cis.getCount());
        }
    }

    @Test
    public void testZeroLength2() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            byte[] result = new byte[10];
            int found = cis.read(result);
            Assertions.assertEquals((int)-1, (int)found);
            Assertions.assertEquals((int)0, (int)cis.getCount());
        }
    }

    @Test
    public void testZeroLength3() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            byte[] result = new byte[10];
            int found = cis.read(result, 0, 5);
            Assertions.assertEquals((int)-1, (int)found);
            Assertions.assertEquals((int)0, (int)cis.getCount());
        }
    }

    @Test
    public void testEOF1() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            int found = cis.read();
            Assertions.assertEquals((int)0, (int)found);
            Assertions.assertEquals((int)1, (int)cis.getCount());
            found = cis.read();
            Assertions.assertEquals((int)0, (int)found);
            Assertions.assertEquals((int)2, (int)cis.getCount());
            found = cis.read();
            Assertions.assertEquals((int)-1, (int)found);
            Assertions.assertEquals((int)2, (int)cis.getCount());
        }
    }

    @Test
    public void testEOF2() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            byte[] result = new byte[10];
            int found = cis.read(result);
            Assertions.assertEquals((int)2, (int)found);
            Assertions.assertEquals((int)2, (int)cis.getCount());
        }
    }

    @Test
    public void testEOF3() throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(new byte[2]);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            byte[] result = new byte[10];
            int found = cis.read(result, 0, 5);
            Assertions.assertEquals((int)2, (int)found);
            Assertions.assertEquals((int)2, (int)cis.getCount());
        }
    }

    @Test
    public void testSkipping() throws IOException {
        String text = "Hello World!";
        byte[] bytes = "Hello World!".getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (CountingInputStream cis = new CountingInputStream((InputStream)bais);){
            Assertions.assertEquals((long)6L, (long)cis.skip(6L));
            Assertions.assertEquals((int)6, (int)cis.getCount());
            byte[] result = new byte[6];
            cis.read(result);
            Assertions.assertEquals((Object)"World!", (Object)new String(result));
            Assertions.assertEquals((int)12, (int)cis.getCount());
        }
    }
}

