/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class LineIteratorTestCase {
    @TempDir
    public File temporaryFolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertLines(List<String> lines, LineIterator iterator) {
        try {
            for (int i = 0; i < lines.size(); ++i) {
                String line = iterator.nextLine();
                Assertions.assertEquals((Object)lines.get(i), (Object)line, (String)("nextLine() line " + i));
            }
            Assertions.assertFalse((boolean)iterator.hasNext(), (String)"No more expected");
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    private List<String> createLinesFile(File file, int lineCount) throws IOException {
        List<String> lines = this.createStringLines(lineCount);
        FileUtils.writeLines((File)file, lines);
        return lines;
    }

    private List<String> createLinesFile(File file, String encoding, int lineCount) throws IOException {
        List<String> lines = this.createStringLines(lineCount);
        FileUtils.writeLines((File)file, (String)encoding, lines);
        return lines;
    }

    private List<String> createStringLines(int lineCount) {
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < lineCount; ++i) {
            lines.add("LINE " + i);
        }
        return lines;
    }

    @Test
    public void testConstructor() throws Exception {
        try {
            new LineIterator(null);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testZeroLines() throws Exception {
        this.doTestFileWithSpecifiedLines(0);
    }

    @Test
    public void testOneLines() throws Exception {
        this.doTestFileWithSpecifiedLines(1);
    }

    @Test
    public void testTwoLines() throws Exception {
        this.doTestFileWithSpecifiedLines(2);
    }

    @Test
    public void testThreeLines() throws Exception {
        this.doTestFileWithSpecifiedLines(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingFile() throws Exception {
        File testFile = new File(this.temporaryFolder, "dummy-missing-file.txt");
        LineIterator iterator = null;
        try {
            iterator = FileUtils.lineIterator((File)testFile, (String)"UTF-8");
            Assertions.fail((String)"Expected FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidEncoding() throws Exception {
        String encoding = "UTF-8";
        File testFile = new File(this.temporaryFolder, "LineIterator-validEncoding.txt");
        this.createLinesFile(testFile, "UTF-8", 3);
        LineIterator iterator = FileUtils.lineIterator((File)testFile, (String)"UTF-8");
        try {
            int count = 0;
            while (iterator.hasNext()) {
                Assertions.assertNotNull((Object)iterator.next());
                ++count;
            }
            Assertions.assertEquals((int)3, (int)count);
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidEncoding() throws Exception {
        String encoding = "XXXXXXXX";
        File testFile = new File(this.temporaryFolder, "LineIterator-invalidEncoding.txt");
        this.createLinesFile(testFile, "UTF-8", 3);
        LineIterator iterator = null;
        try {
            iterator = FileUtils.lineIterator((File)testFile, (String)"XXXXXXXX");
            Assertions.fail((String)"Expected UnsupportedCharsetException");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    @Test
    public void testNextLineOnlyDefaultEncoding() throws Exception {
        File testFile = new File(this.temporaryFolder, "LineIterator-nextOnly.txt");
        List<String> lines = this.createLinesFile(testFile, 3);
        LineIterator iterator = FileUtils.lineIterator((File)testFile);
        this.assertLines(lines, iterator);
    }

    @Test
    public void testNextLineOnlyNullEncoding() throws Exception {
        String encoding = null;
        File testFile = new File(this.temporaryFolder, "LineIterator-nextOnly.txt");
        List<String> lines = this.createLinesFile(testFile, encoding, 3);
        LineIterator iterator = FileUtils.lineIterator((File)testFile, encoding);
        this.assertLines(lines, iterator);
    }

    @Test
    public void testNextLineOnlyUtf8Encoding() throws Exception {
        String encoding = "UTF-8";
        File testFile = new File(this.temporaryFolder, "LineIterator-nextOnly.txt");
        List<String> lines = this.createLinesFile(testFile, "UTF-8", 3);
        LineIterator iterator = FileUtils.lineIterator((File)testFile, (String)"UTF-8");
        this.assertLines(lines, iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNextOnly() throws Exception {
        String encoding = null;
        File testFile = new File(this.temporaryFolder, "LineIterator-nextOnly.txt");
        List<String> lines = this.createLinesFile(testFile, encoding, 3);
        LineIterator iterator = FileUtils.lineIterator((File)testFile, encoding);
        try {
            for (int i = 0; i < lines.size(); ++i) {
                String line = iterator.next();
                Assertions.assertEquals((Object)lines.get(i), (Object)line, (String)("next() line " + i));
            }
            Assertions.assertEquals((Object)false, (Object)iterator.hasNext(), (String)"No more expected");
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    @Test
    public void testNextWithException() throws Exception {
        BufferedReader reader = new BufferedReader(new StringReader("")){

            @Override
            public String readLine() throws IOException {
                throw new IOException("hasNext");
            }
        };
        try {
            new LineIterator((Reader)reader).hasNext();
            Assertions.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseEarly() throws Exception {
        String encoding = "UTF-8";
        File testFile = new File(this.temporaryFolder, "LineIterator-closeEarly.txt");
        this.createLinesFile(testFile, "UTF-8", 3);
        LineIterator iterator = FileUtils.lineIterator((File)testFile, (String)"UTF-8");
        try {
            Assertions.assertNotNull((Object)"Line expected", (String)iterator.next());
            Assertions.assertTrue((boolean)iterator.hasNext(), (String)"More expected");
            iterator.close();
            Assertions.assertFalse((boolean)iterator.hasNext(), (String)"No more expected");
            try {
                iterator.next();
                Assertions.fail();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                iterator.nextLine();
                Assertions.fail();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            iterator.close();
            try {
                iterator.next();
                Assertions.fail();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                iterator.nextLine();
                Assertions.fail();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestFileWithSpecifiedLines(int lineCount) throws IOException {
        String encoding = "UTF-8";
        String fileName = "LineIterator-" + lineCount + "-test.txt";
        File testFile = new File(this.temporaryFolder, fileName);
        List<String> lines = this.createLinesFile(testFile, "UTF-8", lineCount);
        LineIterator iterator = FileUtils.lineIterator((File)testFile, (String)"UTF-8");
        try {
            try {
                iterator.remove();
                Assertions.fail((String)"Remove is unsupported");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            int idx = 0;
            while (iterator.hasNext()) {
                String line = iterator.next();
                Assertions.assertEquals((Object)lines.get(idx), (Object)line, (String)("Comparing line " + idx));
                Assertions.assertTrue((idx < lines.size() ? 1 : 0) != 0, (String)("Exceeded expected idx=" + idx + " size=" + lines.size()));
                ++idx;
            }
            Assertions.assertEquals((int)idx, (int)lines.size(), (String)"Line Count doesn't match");
            try {
                iterator.next();
                Assertions.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                iterator.nextLine();
                Assertions.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    @Test
    public void testFilteringFileReader() throws Exception {
        String encoding = "UTF-8";
        String fileName = "LineIterator-Filter-test.txt";
        File testFile = new File(this.temporaryFolder, "LineIterator-Filter-test.txt");
        List<String> lines = this.createLinesFile(testFile, "UTF-8", 9);
        FileReader reader = new FileReader(testFile);
        this.testFiltering(lines, reader);
    }

    @Test
    public void testFilteringBufferedReader() throws Exception {
        String encoding = "UTF-8";
        String fileName = "LineIterator-Filter-test.txt";
        File testFile = new File(this.temporaryFolder, "LineIterator-Filter-test.txt");
        List<String> lines = this.createLinesFile(testFile, "UTF-8", 9);
        BufferedReader reader = new BufferedReader(new FileReader(testFile));
        this.testFiltering(lines, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFiltering(List<String> lines, Reader reader) {
        LineIterator iterator = new LineIterator(reader){

            protected boolean isValidLine(String line) {
                char c = line.charAt(line.length() - 1);
                return (c - 48) % 3 != 1;
            }
        };
        try {
            try {
                iterator.remove();
                Assertions.fail((String)"Remove is unsupported");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            int idx = 0;
            int actualLines = 0;
            while (iterator.hasNext()) {
                String line = iterator.next();
                ++actualLines;
                Assertions.assertEquals((Object)lines.get(idx), (Object)line, (String)("Comparing line " + idx));
                Assertions.assertTrue((idx < lines.size() ? 1 : 0) != 0, (String)("Exceeded expected idx=" + idx + " size=" + lines.size()));
                if (++idx % 3 != 1) continue;
                ++idx;
            }
            Assertions.assertEquals((int)9, (int)lines.size(), (String)"Line Count doesn't match");
            Assertions.assertEquals((int)9, (int)idx, (String)"Line Count doesn't match");
            Assertions.assertEquals((int)6, (int)actualLines, (String)"Line Count doesn't match");
            try {
                iterator.next();
                Assertions.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                iterator.nextLine();
                Assertions.fail((String)"Expected NoSuchElementException");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }
}

