/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import org.apache.commons.io.ThreadMonitor;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ThreadMonitorTestCase {
    @Test
    public void testTimeout() {
        try {
            Thread monitor = ThreadMonitor.start((long)100L);
            TestUtils.sleep(200L);
            ThreadMonitor.stop((Thread)monitor);
            Assertions.fail((String)"Expected InterruptedException");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testCompletedWithoutTimeout() {
        try {
            Thread monitor = ThreadMonitor.start((long)200L);
            TestUtils.sleep(100L);
            ThreadMonitor.stop((Thread)monitor);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Timed Out");
        }
    }

    @Test
    public void testNoTimeout() {
        Thread monitor;
        try {
            monitor = ThreadMonitor.start((long)-1L);
            Assertions.assertNull((Object)monitor, (String)"Timeout -1, Monitor should be null");
            TestUtils.sleep(100L);
            ThreadMonitor.stop((Thread)monitor);
        }
        catch (Exception e) {
            Assertions.fail((String)("Timeout -1, threw " + e));
        }
        try {
            monitor = ThreadMonitor.start((long)0L);
            Assertions.assertNull((Object)monitor, (String)"Timeout 0, Monitor should be null");
            TestUtils.sleep(100L);
            ThreadMonitor.stop((Thread)monitor);
        }
        catch (Exception e) {
            Assertions.fail((String)("Timeout 0, threw " + e));
        }
    }
}

