/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.CounterAssertions;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.PathUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PathUtilsDeleteTest {
    private Path tempDir;

    @AfterEach
    public void afterEach() throws IOException {
        if (Files.exists(this.tempDir, new LinkOption[0]) && PathUtils.isEmptyDirectory((Path)this.tempDir)) {
            Files.deleteIfExists(this.tempDir);
        }
    }

    @BeforeEach
    public void beforeEach() throws IOException {
        this.tempDir = Files.createTempDirectory(this.getClass().getCanonicalName(), new FileAttribute[0]);
    }

    @Test
    public void testDeleteDirectory1FileSize0() throws IOException {
        String fileName = "file-size-0.bin";
        FileUtils.copyFileToDirectory((File)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-0/file-size-0.bin", new String[0]).toFile(), (File)this.tempDir.toFile());
        CounterAssertions.assertCounts(0L, 1L, 0L, PathUtils.delete((Path)this.tempDir.resolve("file-size-0.bin")));
        Files.deleteIfExists(this.tempDir);
    }

    @Test
    public void testDeleteDirectory1FileSize1() throws IOException {
        String fileName = "file-size-1.bin";
        FileUtils.copyFileToDirectory((File)Paths.get("src/test/resources/org/apache/commons/io/dirs-1-file-size-1/file-size-1.bin", new String[0]).toFile(), (File)this.tempDir.toFile());
        CounterAssertions.assertCounts(0L, 1L, 1L, PathUtils.delete((Path)this.tempDir.resolve("file-size-1.bin")));
        Files.deleteIfExists(this.tempDir);
    }

    @Test
    public void testDeleteEmptyDirectory() throws IOException {
        this.testDeleteEmptyDirectory(PathUtils.delete((Path)this.tempDir));
        Files.deleteIfExists(this.tempDir);
    }

    private void testDeleteEmptyDirectory(Counters.PathCounters pathCounts) {
        CounterAssertions.assertCounts(1L, 0L, 0L, pathCounts);
    }

    @Test
    public void testDeleteFileDoesNotExist() throws IOException {
        CounterAssertions.assertCounts(0L, 0L, 0L, PathUtils.deleteFile((Path)this.tempDir.resolve("file-does-not-exist.bin")));
        Files.deleteIfExists(this.tempDir);
    }
}

