/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.BrokenInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BrokenInputStreamTest {
    private IOException exception;
    private InputStream stream;

    @BeforeEach
    public void setUp() {
        this.exception = new IOException("test exception");
        this.stream = new BrokenInputStream(this.exception);
    }

    @Test
    public void testRead() {
        try {
            this.stream.read();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.stream.read(new byte[1]);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
        try {
            this.stream.read(new byte[1], 0, 1);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testAvailable() {
        try {
            this.stream.available();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testSkip() {
        try {
            this.stream.skip(1L);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testReset() {
        try {
            this.stream.reset();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }

    @Test
    public void testClose() {
        try {
            this.stream.close();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)this.exception, (Object)e);
        }
    }
}

