/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import org.apache.commons.io.input.CharacterSetFilterReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharacterSetFilterReaderTest {
    @Test
    public void testInputSize0FilterSize0() throws IOException {
        StringReader input = new StringReader("");
        try (CharacterSetFilterReader reader = new CharacterSetFilterReader((Reader)input, new HashSet(0));){
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize0FilterSize1() throws IOException {
        StringReader input = new StringReader("");
        HashSet<Integer> codePoints = new HashSet<Integer>();
        codePoints.add(97);
        try (CharacterSetFilterReader reader = new CharacterSetFilterReader((Reader)input, codePoints);){
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize0NullFilter() throws IOException {
        StringReader input = new StringReader("");
        try (CharacterSetFilterReader reader = new CharacterSetFilterReader((Reader)input, null);){
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize1FilterSize1() throws IOException {
        try (StringReader input = new StringReader("a");){
            HashSet<Integer> codePoints = new HashSet<Integer>();
            codePoints.add(97);
            CharacterSetFilterReader reader = new CharacterSetFilterReader((Reader)input, codePoints);
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize2FilterSize1FilterAll() throws IOException {
        StringReader input = new StringReader("aa");
        HashSet<Integer> codePoints = new HashSet<Integer>();
        codePoints.add(97);
        try (CharacterSetFilterReader reader = new CharacterSetFilterReader((Reader)input, codePoints);){
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize2FilterSize1FilterFirst() throws IOException {
        StringReader input = new StringReader("ab");
        HashSet<Integer> codePoints = new HashSet<Integer>();
        codePoints.add(97);
        try (CharacterSetFilterReader reader = new CharacterSetFilterReader((Reader)input, codePoints);){
            Assertions.assertEquals((int)98, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize2FilterSize1FilterLast() throws IOException {
        StringReader input = new StringReader("ab");
        HashSet<Integer> codePoints = new HashSet<Integer>();
        codePoints.add(98);
        try (CharacterSetFilterReader reader = new CharacterSetFilterReader((Reader)input, codePoints);){
            Assertions.assertEquals((int)97, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize2FilterSize2FilterFirst() throws IOException {
        StringReader input = new StringReader("ab");
        HashSet<Integer> codePoints = new HashSet<Integer>();
        codePoints.add(97);
        codePoints.add(121);
        try (CharacterSetFilterReader reader = new CharacterSetFilterReader((Reader)input, codePoints);){
            Assertions.assertEquals((int)98, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize2FilterSize2FilterLast() throws IOException {
        StringReader input = new StringReader("ab");
        HashSet<Integer> codePoints = new HashSet<Integer>();
        codePoints.add(120);
        codePoints.add(98);
        try (CharacterSetFilterReader reader = new CharacterSetFilterReader((Reader)input, codePoints);){
            Assertions.assertEquals((int)97, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testInputSize2FilterSize2FilterNone() throws IOException {
        StringReader input = new StringReader("ab");
        HashSet<Integer> codePoints = new HashSet<Integer>();
        codePoints.add(120);
        codePoints.add(121);
        try (CharacterSetFilterReader reader = new CharacterSetFilterReader((Reader)input, codePoints);){
            Assertions.assertEquals((int)97, (int)reader.read());
            Assertions.assertEquals((int)98, (int)reader.read());
        }
    }
}

