/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NullInputStreamTest {
    @Test
    public void testRead() throws Exception {
        int size = 5;
        TestNullInputStream input = new TestNullInputStream(5);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertEquals((int)(5 - i), (int)((InputStream)((Object)input)).available(), (String)("Check Size [" + i + "]"));
            Assertions.assertEquals((int)i, (int)((InputStream)((Object)input)).read(), (String)("Check Value [" + i + "]"));
        }
        Assertions.assertEquals((int)0, (int)((InputStream)((Object)input)).available(), (String)"Available after contents all read");
        Assertions.assertEquals((int)-1, (int)((InputStream)((Object)input)).read(), (String)"End of File");
        Assertions.assertEquals((int)0, (int)((InputStream)((Object)input)).available(), (String)"Available after End of File");
        try {
            int result = ((InputStream)((Object)input)).read();
            Assertions.fail((String)("Should have thrown an IOException, byte=[" + result + "]"));
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"Read after end of file", (Object)e.getMessage());
        }
        ((InputStream)((Object)input)).close();
        Assertions.assertEquals((int)5, (int)((InputStream)((Object)input)).available(), (String)"Available after close");
    }

    @Test
    public void testReadByteArray() throws Exception {
        byte[] bytes = new byte[10];
        TestNullInputStream input = new TestNullInputStream(15);
        int count1 = ((InputStream)((Object)input)).read(bytes);
        Assertions.assertEquals((int)bytes.length, (int)count1, (String)"Read 1");
        for (int i = 0; i < count1; ++i) {
            Assertions.assertEquals((int)i, (int)bytes[i], (String)"Check Bytes 1");
        }
        int count2 = ((InputStream)((Object)input)).read(bytes);
        Assertions.assertEquals((int)5, (int)count2, (String)"Read 2");
        for (int i = 0; i < count2; ++i) {
            Assertions.assertEquals((int)(count1 + i), (int)bytes[i], (String)"Check Bytes 2");
        }
        int count3 = ((InputStream)((Object)input)).read(bytes);
        Assertions.assertEquals((int)-1, (int)count3, (String)"Read 3 (EOF)");
        try {
            int count4 = ((InputStream)((Object)input)).read(bytes);
            Assertions.fail((String)("Should have thrown an IOException, byte=[" + count4 + "]"));
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"Read after end of file", (Object)e.getMessage());
        }
        ((InputStream)((Object)input)).close();
        int offset = 2;
        int lth = 4;
        int count5 = ((InputStream)((Object)input)).read(bytes, 2, 4);
        Assertions.assertEquals((int)4, (int)count5, (String)"Read 5");
        for (int i = 2; i < 4; ++i) {
            Assertions.assertEquals((int)i, (int)bytes[i], (String)"Check Bytes 2");
        }
    }

    @Test
    public void testEOFException() throws Exception {
        TestNullInputStream input = new TestNullInputStream(2, false, true);
        Assertions.assertEquals((int)0, (int)((InputStream)((Object)input)).read(), (String)"Read 1");
        Assertions.assertEquals((int)1, (int)((InputStream)((Object)input)).read(), (String)"Read 2");
        try {
            int result = ((InputStream)((Object)input)).read();
            Assertions.fail((String)("Should have thrown an EOFException, byte=[" + result + "]"));
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        ((InputStream)((Object)input)).close();
    }

    @Test
    public void testMarkAndReset() throws Exception {
        int i;
        int position = 0;
        int readlimit = 10;
        TestNullInputStream input = new TestNullInputStream(100, true, false);
        Assertions.assertTrue((boolean)((InputStream)((Object)input)).markSupported(), (String)"Mark Should be Supported");
        try {
            ((InputStream)((Object)input)).reset();
            Assertions.fail((String)"Read limit exceeded, expected IOException ");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"No position has been marked", (Object)e.getMessage(), (String)"No Mark IOException message");
        }
        while (position < 3) {
            Assertions.assertEquals((int)position, (int)((InputStream)((Object)input)).read(), (String)("Read Before Mark [" + position + "]"));
            ++position;
        }
        ((InputStream)((Object)input)).mark(10);
        for (i = 0; i < 3; ++i) {
            Assertions.assertEquals((int)(position + i), (int)((InputStream)((Object)input)).read(), (String)("Read After Mark [" + i + "]"));
        }
        ((InputStream)((Object)input)).reset();
        for (i = 0; i < 11; ++i) {
            Assertions.assertEquals((int)(position + i), (int)((InputStream)((Object)input)).read(), (String)("Read After Reset [" + i + "]"));
        }
        try {
            ((InputStream)((Object)input)).reset();
            Assertions.fail((String)"Read limit exceeded, expected IOException ");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)("Marked position [" + position + "] is no longer valid - passed the read limit [" + 10 + "]"), (Object)e.getMessage(), (String)"Read limit IOException message");
        }
        ((InputStream)((Object)input)).close();
    }

    @Test
    public void testMarkNotSupported() throws Exception {
        TestNullInputStream input = new TestNullInputStream(100, false, true);
        Assertions.assertFalse((boolean)((InputStream)((Object)input)).markSupported(), (String)"Mark Should NOT be Supported");
        try {
            ((InputStream)((Object)input)).mark(5);
            Assertions.fail((String)"mark() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertEquals((Object)"Mark not supported", (Object)e.getMessage(), (String)"mark() error message");
        }
        try {
            ((InputStream)((Object)input)).reset();
            Assertions.fail((String)"reset() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertEquals((Object)"Mark not supported", (Object)e.getMessage(), (String)"reset() error message");
        }
        ((InputStream)((Object)input)).close();
    }

    @Test
    public void testSkip() throws Exception {
        TestNullInputStream input = new TestNullInputStream(10, true, false);
        Assertions.assertEquals((int)0, (int)((InputStream)((Object)input)).read(), (String)"Read 1");
        Assertions.assertEquals((int)1, (int)((InputStream)((Object)input)).read(), (String)"Read 2");
        Assertions.assertEquals((long)5L, (long)((InputStream)((Object)input)).skip(5L), (String)"Skip 1");
        Assertions.assertEquals((int)7, (int)((InputStream)((Object)input)).read(), (String)"Read 3");
        Assertions.assertEquals((long)2L, (long)((InputStream)((Object)input)).skip(5L), (String)"Skip 2");
        Assertions.assertEquals((long)-1L, (long)((InputStream)((Object)input)).skip(5L), (String)"Skip 3 (EOF)");
        try {
            ((InputStream)((Object)input)).skip(5L);
            Assertions.fail((String)"Expected IOException for skipping after end of file");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"Skip after end of file", (Object)e.getMessage(), (String)"Skip after EOF IOException message");
        }
        ((InputStream)((Object)input)).close();
    }

    private static final class TestNullInputStream
    extends NullInputStream {
        public TestNullInputStream(int size) {
            super((long)size);
        }

        public TestNullInputStream(int size, boolean markSupported, boolean throwEofException) {
            super((long)size, markSupported, throwEofException);
        }

        protected int processByte() {
            return (int)this.getPosition() - 1;
        }

        protected void processBytes(byte[] bytes, int offset, int length) {
            int startPos = (int)this.getPosition() - length;
            for (int i = offset; i < length; ++i) {
                bytes[i] = (byte)(startPos + i);
            }
        }
    }
}

